/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.manager;

import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.stargate.iris.codesender.CodeSender;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface IStargateIrisManager
extends INBTSerializable<CompoundTag>,
ITickable {
    @Nullable
    public CodeSender getCodeSender();

    public EnumIrisType getIrisType();

    public EnumIrisMode getIrisMode();

    public String getIrisCode();

    public EnumIrisState getIrisState();

    default public boolean isIrisOpened() {
        return this.getIrisState() == EnumIrisState.OPENED || this.getIrisType() == EnumIrisType.NULL;
    }

    default public boolean isIrisClosed() {
        return this.getIrisState() == EnumIrisState.CLOSED && this.getIrisType() != EnumIrisType.NULL;
    }

    default public boolean hasIris() {
        return this.getIrisType() != EnumIrisType.NULL;
    }

    default public boolean hasShield() {
        return this.getIrisType() == EnumIrisType.SHIELD;
    }

    default public boolean hasPhysicalIris() {
        return this.getIrisType() == EnumIrisType.IRIS_TRINIUM || this.getIrisType() == EnumIrisType.IRIS_TITANIUM || this.getIrisType() == EnumIrisType.IRIS_CREATIVE;
    }

    default public boolean hasCreativeIris() {
        return this.getIrisType() == EnumIrisType.IRIS_CREATIVE;
    }

    public ItemStack getIrisItem();

    public boolean canInsertItemAsIris(@Nullable Item var1);

    public boolean receiveIrisCode(CodeSender var1, String var2);

    public void setIrisCode(@Nullable String var1);

    public void setIrisMode(EnumIrisMode var1);

    public boolean toggleIris();

    public void hitIris();
}

