/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.network;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.chunkloader.ChunkManager;
import dev.tauri.jsg.api.helper.DimensionsHelper;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public class StargatePos
implements INBTSerializable<CompoundTag> {
    public boolean blacklisted = false;
    public ResourceKey<Level> dimension;
    public ResourceKey<Level> fakeGateDimension;
    public BlockPos gatePos;
    public BlockPos fakeGatePos;
    private AbstractSymbolType<?> gateSymbolType;
    private StargateType stargateType;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public StargatePos(ResourceKey<Level> dimension, BlockPos gatePos, AbstractSymbolType<?> gateSymbolType, StargateType stargateType) {
        this(dimension, dimension, gatePos, gatePos, gateSymbolType, stargateType);
    }

    public StargatePos(ResourceKey<Level> dimension, ResourceKey<Level> fakeGateDimension, BlockPos gatePos, BlockPos fakeGatePos, AbstractSymbolType<?> gateSymbolType, StargateType stargateType) {
        this.dimension = dimension;
        this.fakeGateDimension = fakeGateDimension;
        this.fakeGatePos = fakeGatePos;
        this.gatePos = gatePos;
        this.gateSymbolType = gateSymbolType;
        this.stargateType = stargateType;
    }

    public StargatePos(CompoundTag compound) {
        this.deserializeNBT(compound);
    }

    public StargatePos(ByteBuf buf) {
        this.fromBytes(new FriendlyByteBuf(buf));
    }

    public AbstractSymbolType<?> getGateSymbolType() {
        if (this.gateSymbolType != null) {
            return this.gateSymbolType;
        }
        this.gateSymbolType = this.getStargate().getSymbolType();
        return this.gateSymbolType;
    }

    public StargateType getStargateType() {
        if (this.stargateType != null) {
            return this.stargateType;
        }
        this.stargateType = StargateType.parse(this.getGateSymbolType());
        return this.stargateType;
    }

    public Level getWorld() {
        return (Level)Objects.requireNonNull(DimensionsHelper.getLevel(this.dimension));
    }

    protected void forceChunk() {
        ChunkManager.forceChunk((ServerLevel)this.getWorld(), new ChunkPos(this.gatePos));
    }

    protected void unforceChunk() {
        ChunkManager.unforceChunk((ServerLevel)this.getWorld(), new ChunkPos(this.gatePos));
    }

    public void forceChunkAndRun(Runnable runnable) {
        this.forceChunk();
        runnable.run();
        this.unforceChunk();
    }

    public void forceChunkAndCall(Consumer<Stargate<?>> consumer) {
        this.forceChunk();
        consumer.accept(this.getStargate());
        this.unforceChunk();
    }

    public Stargate<?> getStargate() {
        try {
            BlockEntity tile = this.getWorld().m_7702_(this.gatePos);
            if (tile == null) {
                this.forceChunk();
                tile = this.getWorld().m_7702_(this.gatePos);
                this.unforceChunk();
            }
            return (Stargate)tile;
        }
        catch (Exception e) {
            JSGApi.logger.error("Error while getting tile entity from SG pos!", e);
            return null;
        }
    }

    public BlockState getBlockState() {
        return this.getWorld().m_8055_(this.gatePos);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("dim", this.dimension.m_135782_().toString());
        compound.m_128359_("fakeDim", this.fakeGateDimension.m_135782_().toString());
        compound.m_128356_("pos", this.gatePos.m_121878_());
        compound.m_128356_("fakePos", this.fakeGatePos.m_121878_());
        compound.m_128359_("stargatePosName", this.name == null ? "" : this.name);
        if (this.gateSymbolType != null) {
            compound.m_128359_("gateSymbolType", this.gateSymbolType.getId());
        }
        if (this.stargateType != null) {
            compound.m_128359_("stargateTypeSaved", this.stargateType.getId());
        }
        compound.m_128379_("blacklisted", this.blacklisted);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dim")));
        this.fakeGateDimension = compound.m_128441_("fakeDim") ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("fakeDim"))) : this.dimension;
        this.gatePos = BlockPos.m_122022_((long)compound.m_128454_("pos"));
        this.fakeGatePos = compound.m_128441_("fakePos") ? BlockPos.m_122022_((long)compound.m_128454_("fakePos")) : this.gatePos;
        this.name = compound.m_128461_("stargatePosName");
        if (compound.m_128441_("gateSymbolType")) {
            this.gateSymbolType = compound.m_128425_("gateSymbolType", 1) ? AbstractSymbolType.byId(compound.m_128445_("gateSymbolType")) : AbstractSymbolType.byId(compound.m_128461_("gateSymbolType"));
        }
        if (compound.m_128441_("stargateTypeSaved")) {
            this.stargateType = compound.m_128425_("stargateTypeSaved", 3) ? StargateType.valueOf(compound.m_128451_("stargateTypeSaved")) : StargateType.valueOf(compound.m_128461_("stargateTypeSaved"));
        }
        this.blacklisted = compound.m_128471_("blacklisted");
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236858_(this.dimension);
        buf.m_236858_(this.fakeGateDimension);
        buf.writeLong(this.gatePos.m_121878_());
        buf.writeLong(this.fakeGatePos.m_121878_());
        if (this.name != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.name.length());
            buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        } else {
            buf.writeBoolean(false);
        }
        if (this.gateSymbolType != null) {
            buf.writeBoolean(true);
            buf.writeInt(AbstractSymbolType.getId(this.gateSymbolType));
        } else {
            buf.writeBoolean(false);
        }
        if (this.stargateType != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.stargateType.id);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.blacklisted);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.dimension = buf.m_236801_(Registries.f_256858_);
        this.fakeGateDimension = buf.m_236801_(Registries.f_256858_);
        this.gatePos = BlockPos.m_122022_((long)buf.readLong());
        this.fakeGatePos = BlockPos.m_122022_((long)buf.readLong());
        if (buf.readBoolean()) {
            int nameSize = buf.readInt();
            this.name = buf.readCharSequence(nameSize, StandardCharsets.UTF_8).toString();
        }
        if (buf.readBoolean()) {
            this.gateSymbolType = AbstractSymbolType.byId(buf.readInt());
        }
        if (buf.readBoolean()) {
            this.stargateType = StargateType.valueOf(buf.readInt());
        }
        this.blacklisted = buf.readBoolean();
    }

    public String toString() {
        return String.format("[dim=%s, pos=%s, name=%s]", this.dimension.m_135782_(), this.gatePos.toString(), this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension.hashCode();
        result = 31 * result + (this.gatePos == null ? 0 : this.gatePos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StargatePos)) {
            return false;
        }
        StargatePos other = (StargatePos)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.gatePos == null) {
            return other.gatePos == null;
        }
        return this.gatePos.equals((Object)other.gatePos);
    }
}

