/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.network.address.symbol;

import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.client.model.IModelLoader;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.util.Localizable;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface SymbolInterface
extends Localizable {
    public boolean origin();

    public float getAngle();

    public int getAngleIndex();

    public int getId();

    default public boolean brb() {
        return false;
    }

    public String getEnglishName();

    public ResourceLocation getIconResource(@Nullable PointOfOrigin var1);

    public ResourceLocation getModelResource(IPointOfOriginType var1, @Nullable PointOfOrigin var2, String var3);

    public AbstractSymbolType<?> getSymbolType();

    public boolean isValidForAddress();

    public SymbolInterface getNext(boolean var1);

    default public boolean renderIconByMinecraft() {
        return !this.origin();
    }

    default public boolean canBePressed() {
        return true;
    }

    default public void bindIconTexture(@Nullable PointOfOrigin origin) {
        ResourceLocation location = this.getIconResource(origin);
        if (this.renderIconByMinecraft()) {
            ITexture.bindTextureWithMc(location);
        } else {
            ITextureLoader loader = this.getSymbolType().getTextureLoader();
            if (this.origin() && LoadersHolder.JSG_HOLDER.texture().isTextureLoaded(location)) {
                loader = LoadersHolder.JSG_HOLDER.texture();
            }
            loader.getTexture(location).bindTexture();
        }
    }

    @NotNull
    default public AbstractOBJModel getModel(IPointOfOriginType type, @Nullable PointOfOrigin origin, String variant) {
        ResourceLocation location = this.getModelResource(type, origin, variant);
        IModelLoader loader = this.getSymbolType().getModelLoader();
        if (this.origin() && LoadersHolder.JSG_HOLDER.model().isModelLoaded(location)) {
            loader = LoadersHolder.JSG_HOLDER.model();
        }
        return loader.getModel(location);
    }
}

