/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.stargate.network.address.symbol.types;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.api.util.I18n;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SymbolUniverseEnum implements SymbolInterface
{
    TOP_CHEVRON(0, null),
    G1(1, "01.obj"),
    G2(2, "02.obj"),
    G3(3, "03.obj"),
    G4(4, "04.obj"),
    G5(5, "05.obj"),
    G6(6, "06.obj"),
    G7(7, "07.obj"),
    G8(8, "08.obj"),
    G9(9, "09.obj"),
    G10(10, "10.obj"),
    G11(11, "11.obj"),
    G12(12, "12.obj"),
    G13(13, "13.obj"),
    G14(14, "14.obj"),
    G15(15, "15.obj"),
    G16(16, "16.obj"),
    G17(17, "17.obj"),
    G18(18, "18.obj"),
    G19(19, "19.obj"),
    G20(20, "20.obj"),
    G21(21, "21.obj"),
    G22(22, "22.obj"),
    G23(23, "23.obj"),
    G24(24, "24.obj"),
    G25(25, "25.obj"),
    G26(26, "26.obj"),
    G27(27, "27.obj"),
    G28(28, "28.obj"),
    G29(29, "29.obj"),
    G30(30, "30.obj"),
    G31(31, "31.obj"),
    G32(32, "32.obj"),
    G33(33, "33.obj"),
    G34(34, "34.obj"),
    G35(35, "35.obj"),
    G36(36, "36.obj");

    public static final int ANGLE_PER_SECTION = 8;
    public final int id;
    public final int angle;
    public final int angleIndex;
    public final String englishName;
    public final String translationKey;
    private final ResourceLocation iconResource;
    private final ResourceLocation modelResource;

    private SymbolUniverseEnum(int id, String model) {
        this.id = id;
        this.modelResource = model != null ? LoadersHolder.JSG_HOLDER.model().getModelResource("universe/" + model) : new ResourceLocation("null");
        int id0 = id - 1;
        this.angleIndex = id0 + id0 / 4 + 1;
        this.angle = 360 - this.angleIndex * 8;
        this.englishName = "Glyph " + id;
        this.translationKey = "glyph.jsg.universe.g" + id;
        this.iconResource = JSGApi.rl("textures/gui/symbol/universe/g" + id + ".png");
    }

    @Override
    public boolean origin() {
        return this == G17;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public int getAngleIndex() {
        return this.angleIndex;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getEnglishName() {
        return this.englishName;
    }

    public String toString() {
        return this.getEnglishName();
    }

    @Override
    public ResourceLocation getIconResource(@Nullable PointOfOrigin origin) {
        if (this.origin()) {
            return Objects.requireNonNullElseGet(origin, () -> Objects.requireNonNull(StargateTypes.UNIVERSE.getDefaultPoO())).getPath("icon.png", false);
        }
        return this.iconResource;
    }

    @Override
    public ResourceLocation getModelResource(IPointOfOriginType type, @Nullable PointOfOrigin origin, String variant) {
        if (this.origin()) {
            return Objects.requireNonNullElseGet(origin, () -> Objects.requireNonNull(type.getDefaultPoO())).getPath(variant, true);
        }
        return this.modelResource;
    }

    @Override
    public String localize() {
        return I18n.format(this.translationKey);
    }

    public AbstractSymbolType<SymbolUniverseEnum> getSymbolType() {
        return SymbolTypeRegistry.UNIVERSE;
    }

    @Override
    public boolean isValidForAddress() {
        return this != TOP_CHEVRON && !this.origin();
    }

    @Override
    public SymbolInterface getNext(boolean previous) {
        SymbolUniverseEnum symbol;
        int id = this.getId();
        do {
            if ((id += previous ? -1 : 1) >= 0) continue;
            id = 36;
        } while ((symbol = SymbolTypeRegistry.UNIVERSE.valueOf(id %= 37)) == null || !symbol.isValidForAddress());
        return symbol;
    }

    @NotNull
    public static AbstractSymbolType<SymbolUniverseEnum> getProvider() {
        try {
            return (AbstractSymbolType)Class.forName("dev.tauri.jsg.stargate.network.symbol.SymbolUniverseProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            JSGApi.logger.error("Error while getting symbol provider: ", e);
            return null;
        }
    }
}

