/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.api.util.RotationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class JSGAxisAlignedBB
extends AABB {
    public static JSGAxisAlignedBB block() {
        return new JSGAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public JSGAxisAlignedBB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public JSGAxisAlignedBB(BlockPos block) {
        super(block);
    }

    public JSGAxisAlignedBB(AABB a) {
        super(a.f_82288_, a.f_82289_, a.f_82290_, a.f_82291_, a.f_82292_, a.f_82293_);
    }

    public JSGAxisAlignedBB(BoundingBox a) {
        super((double)a.m_162395_(), (double)a.m_162396_(), (double)a.m_162398_(), (double)a.m_162399_(), (double)a.m_162400_(), (double)a.m_162401_());
    }

    public JSGAxisAlignedBB(BlockPos min, BlockPos max) {
        super(min, max);
    }

    public JSGAxisAlignedBB(BlockPos center, int radius) {
        this(center.m_7918_(-radius, -radius, -radius), center.m_7918_(radius, radius, radius));
    }

    public JSGAxisAlignedBB(Vec3 p_82302_, Vec3 p_82303_) {
        super(p_82302_, p_82303_);
    }

    public JSGAxisAlignedBB rotate(int angle) {
        return switch (angle) {
            case 0 -> this;
            case 90 -> new JSGAxisAlignedBB(-this.f_82290_, this.f_82289_, this.f_82288_, -this.f_82293_, this.f_82292_, this.f_82291_);
            case 180 -> new JSGAxisAlignedBB(-this.f_82288_, this.f_82289_, -this.f_82290_, -this.f_82291_, this.f_82292_, -this.f_82293_);
            case -90, 270 -> new JSGAxisAlignedBB(this.f_82290_, this.f_82289_, -this.f_82288_, this.f_82293_, this.f_82292_, -this.f_82291_);
            default -> throw new IllegalArgumentException("Angle not one of [0, 90, 180, 270, -90]");
        };
    }

    public JSGAxisAlignedBB grow(Vec3 vector) {
        return this.grow(vector.m_7096_(), vector.m_7098_(), vector.m_7094_());
    }

    public JSGAxisAlignedBB grow(double x, double y, double z) {
        double d0 = this.f_82288_ - x;
        double d1 = this.f_82289_ - y;
        double d2 = this.f_82290_ - z;
        double d3 = this.f_82291_ + x;
        double d4 = this.f_82292_ + y;
        double d5 = this.f_82293_ + z;
        return new JSGAxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public JSGAxisAlignedBB mul(double mul) {
        double d0 = this.f_82288_ * mul;
        double d1 = this.f_82289_ * mul;
        double d2 = this.f_82290_ * mul;
        double d3 = this.f_82291_ * mul;
        double d4 = this.f_82292_ * mul;
        double d5 = this.f_82293_ * mul;
        return new JSGAxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public JSGAxisAlignedBB offset(double x, double y, double z) {
        return new JSGAxisAlignedBB(this.f_82288_ + x, this.f_82289_ + y, this.f_82290_ + z, this.f_82291_ + x, this.f_82292_ + y, this.f_82293_ + z);
    }

    public JSGAxisAlignedBB inset(BlockPos pos) {
        return this.inset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public JSGAxisAlignedBB inset(double x, double y, double z) {
        return new JSGAxisAlignedBB(this.f_82288_ - x, this.f_82289_ - y, this.f_82290_ - z, this.f_82291_ - x, this.f_82292_ - y, this.f_82293_ - z);
    }

    public JSGAxisAlignedBB move(BlockPos pPos) {
        return new JSGAxisAlignedBB(this.f_82288_ + (double)pPos.m_123341_(), this.f_82289_ + (double)pPos.m_123342_(), this.f_82290_ + (double)pPos.m_123343_(), this.f_82291_ + (double)pPos.m_123341_(), this.f_82292_ + (double)pPos.m_123342_(), this.f_82293_ + (double)pPos.m_123343_());
    }

    public JSGAxisAlignedBB offset(Vec3 vec) {
        return this.offset(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
    }

    public JSGAxisAlignedBB offset(Vec3i vec) {
        return this.offset(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public JSGAxisAlignedBB offset(BlockPos pos) {
        return this.offset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockPos getMinBlockPos() {
        return new BlockPos((int)this.f_82288_, (int)this.f_82289_, (int)this.f_82290_);
    }

    public BlockPos getMaxBlockPos() {
        return new BlockPos((int)this.f_82291_, (int)this.f_82292_, (int)this.f_82293_);
    }

    public JSGAxisAlignedBB rotate(Direction facingHorizontal, Direction facingVertical) {
        return this.rotate(facingHorizontal, facingVertical, new Vec3(0.0, 0.0, 0.0));
    }

    public JSGAxisAlignedBB rotate(Direction facingHorizontal, Direction facingVertical, Vec3 pivot) {
        return RotationUtil.rotate(this, RotationUtil.getRotation(facingVertical, facingHorizontal), pivot);
    }

    @NotNull
    public JSGAxisAlignedBB setMinX(double pMinX) {
        return new JSGAxisAlignedBB(pMinX, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    @NotNull
    public JSGAxisAlignedBB setMinY(double pMinY) {
        return new JSGAxisAlignedBB(this.f_82288_, pMinY, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    @NotNull
    public JSGAxisAlignedBB setMinZ(double pMinZ) {
        return new JSGAxisAlignedBB(this.f_82288_, this.f_82289_, pMinZ, this.f_82291_, this.f_82292_, this.f_82293_);
    }

    @NotNull
    public JSGAxisAlignedBB setMaxX(double pMaxX) {
        return new JSGAxisAlignedBB(this.f_82288_, this.f_82289_, this.f_82290_, pMaxX, this.f_82292_, this.f_82293_);
    }

    @NotNull
    public JSGAxisAlignedBB setMaxY(double pMaxY) {
        return new JSGAxisAlignedBB(this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, pMaxY, this.f_82293_);
    }

    @NotNull
    public JSGAxisAlignedBB setMaxZ(double pMaxZ) {
        return new JSGAxisAlignedBB(this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, pMaxZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack stack) {
        this.render(null, stack, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack stack, float r, float g, float b, float a) {
        this.render(null, stack, null, r, g, b, a);
    }

    public void render(Component name, PoseStack stack, MultiBufferSource bufferSource) {
        this.render(name, stack, bufferSource, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(Component name, PoseStack stack, MultiBufferSource bufferSource, float r, float g, float b, float a) {
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82289_, this.f_82290_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82288_, this.f_82289_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82291_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82289_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82289_, this.f_82293_, this.f_82291_, this.f_82289_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82292_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82290_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82292_, this.f_82290_, this.f_82288_, this.f_82292_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82291_, this.f_82292_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82292_, this.f_82293_, this.f_82291_, this.f_82292_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82289_, this.f_82290_, this.f_82288_, this.f_82292_, this.f_82290_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82291_, this.f_82289_, this.f_82290_, this.f_82291_, this.f_82292_, this.f_82290_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82288_, this.f_82289_, this.f_82293_, this.f_82288_, this.f_82292_, this.f_82293_, r, g, b, a);
        JSGAxisAlignedBB.renderLine(matrix, this.f_82291_, this.f_82289_, this.f_82293_, this.f_82291_, this.f_82292_, this.f_82293_, r, g, b, a);
        this.renderName(name, stack, bufferSource, r, g, b);
        stack.m_85849_();
        RenderSystem.disableDepthTest();
    }

    private void renderName(Component name, PoseStack stack, MultiBufferSource bufferSource, float r, float g, float b) {
        if (bufferSource == null) {
            return;
        }
        if (name == null) {
            return;
        }
        stack.m_85836_();
        stack.m_85837_(this.f_82291_, this.f_82292_, this.f_82293_);
        stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        float scale = 0.4f;
        stack.m_85841_(-0.025f * scale, -0.025f * scale, 0.025f * scale);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float backgroundOpacityConfig = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int backgroundOpacity = (int)(backgroundOpacityConfig * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float x = -font.m_92852_((FormattedText)name) / 2;
        int color = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        font.m_272077_(name, x, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundOpacity, 0xF000F0);
        font.m_272077_(name, x, 0.0f, color, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        stack.m_85849_();
    }

    private static void renderLine(Matrix4f m, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder buffer = t.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(m, (float)x1, (float)y1, (float)z1).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(m, (float)x2, (float)y2, (float)z2).m_85950_(r, g, b, a).m_5752_();
        t.m_85914_();
    }
}

