/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.util;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NBTUtils {
    public static <K, V> void mapToBytes(Map<K, V> map, ByteBuf buf, BiConsumer<ByteBuf, K> keyToBytes, BiConsumer<ByteBuf, V> valueToBytes) {
        buf.writeInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keyToBytes.accept(buf, e.getKey());
            valueToBytes.accept(buf, e.getValue());
        }
    }

    public static <M extends Map<K, V>, K, V> M mapFromBytes(M map, ByteBuf buf, Function<ByteBuf, K> keyFromBytes, Function<ByteBuf, V> valueFromBytes) {
        int size = buf.readInt();
        map.clear();
        for (int i = 0; i < size; ++i) {
            K k = keyFromBytes.apply(buf);
            V v = valueFromBytes.apply(buf);
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> CompoundTag serializeMap(Map<K, V> map, BiConsumer<CompoundTag, K> serializeKey, BiConsumer<CompoundTag, V> serializeValue) {
        CompoundTag mapTag = new CompoundTag();
        ListTag entriesTag = new ListTag();
        for (Map.Entry<K, V> e : map.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            serializeKey.accept(entryTag, e.getKey());
            serializeValue.accept(entryTag, e.getValue());
            entriesTag.add((Object)entryTag);
        }
        mapTag.m_128365_("entries", (Tag)entriesTag);
        return mapTag;
    }

    public static <M extends Map<K, V>, K, V> M deSerializeMap(M map, CompoundTag compound, Function<CompoundTag, K> deSerializeKey, Function<CompoundTag, V> deSerializeValue) {
        map.clear();
        ListTag entries = compound.m_128437_("entries", 10);
        for (Tag e : entries) {
            K k = deSerializeKey.apply((CompoundTag)e);
            V v = deSerializeValue.apply((CompoundTag)e);
            map.put(k, v);
        }
        return map;
    }
}

