/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.util.blockentity;

import dev.tauri.jsg.api.util.IUpgrade;
import dev.tauri.jsg.api.util.IUpgradeItem;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public interface IUpgradable {
    private BlockEntity self() {
        return (BlockEntity)this;
    }

    default public IItemHandler getItemHandler() {
        return (IItemHandler)this.self().getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElseThrow();
    }

    default public boolean hasUpgrade(IUpgrade upgrade) {
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iter = this.getUpgradeSlotsIterator();
        while (iter.hasNext()) {
            IUpgradeItem uItem;
            int slot = iter.next();
            Item item = itemHandler.getStackInSlot(slot).m_41720_();
            if (!(item instanceof IUpgradeItem) || (uItem = (IUpgradeItem)item).getUpgrade() != upgrade) continue;
            return true;
        }
        return false;
    }

    default public boolean hasUpgrade(Item item) {
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iter = this.getUpgradeSlotsIterator();
        while (iter.hasNext()) {
            int slot = iter.next();
            if (itemHandler.getStackInSlot(slot).m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    default public Iterator<Integer> getUpgradeSlotsIterator() {
        return IntStream.range(0, this.getItemHandler().getSlots()).iterator();
    }

    default public boolean tryInsertUpgrade(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return false;
        }
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iterator = this.getUpgradeSlotsIterator();
        while (iterator.hasNext()) {
            int slot = iterator.next();
            if (!itemHandler.getStackInSlot(slot).m_41619_() || !itemHandler.isItemValid(slot, stack)) continue;
            player.m_21008_(hand, itemHandler.insertItem(slot, stack, false));
            return true;
        }
        return false;
    }
}

