/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block;

import dev.tauri.jsg.api.block.util.IHighlightBlock;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.blockentity.PrinterBE;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrinterBlock
extends TickableBEBlock
implements ITabbedItem,
IHighlightBlock {
    public PrinterBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60999_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof PrinterBE) {
            ItemStack stack;
            PrinterBE printer = (PrinterBE)blockEntity;
            if (printer.tryInsertCartridge(player.m_21120_(hand))) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_41619_() && (stack = printer.getNextEmptyAndRemove()) != null) {
                ItemHandlerHelper.spawnItemStack(level, pos.m_7494_(), stack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, blockState, player);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof PrinterBE) {
            PrinterBE tile = (PrinterBE)blockEntity;
            for (ItemStack c : tile.cartridges) {
                ItemHandlerHelper.spawnItemStack(level, pos, c);
            }
            ItemHandlerHelper.spawnItemStack(level, pos, tile.inputPages);
            for (int i = 0; i < tile.outputPages.size() - (tile.printStarted <= 0L ? 0 : 1); ++i) {
                ItemHandlerHelper.spawnItemStack(level, pos, tile.outputPages.get(i));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PrinterBE(pPos, pState);
    }

    @Override
    @Nullable
    public RegistryObject<CreativeModeTab> getTab() {
        return TabRegistry.TAB_MACHINES;
    }

    @ParametersAreNonnullByDefault
    public void m_5871_(@NotNull ItemStack itemStack, @javax.annotation.Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_7705_(), components, tooltipFlag);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.rotateDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), rotation));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.flipDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), mirror));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.FACING_HORIZONTAL_PROPERTY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @NotNull
    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)ctx.m_8125_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Override
    public boolean renderHighlight(BlockState blockState) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_166049_((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)0.3f, (double)0.9);
    }
}

