/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.cartouche;

import dev.tauri.jsg.api.block.util.IItemBlock;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.api.item.JSGBlockItem;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.block.cartouche.CartoucheType;
import dev.tauri.jsg.blockentity.cartouche.CartoucheBE;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.item.cartouche.CartoucheItem;
import dev.tauri.jsg.item.notebook.NotebookItem;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.GlowInkSacItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class CartoucheBlock
extends TickableBEBlock
implements SimpleWaterloggedBlock,
ITabbedItem,
IItemBlock {
    public final Supplier<BlockState> material;
    public final CartoucheType type;

    public CartoucheBlock(Supplier<BlockState> material, CartoucheType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)material.get().m_60734_()).m_278166_(PushReaction.DESTROY).m_60971_((state, getter, pos) -> false).m_60955_().m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)Direction.NORTH)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        this.material = material;
        this.type = type;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.FACING_HORIZONTAL_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.FACING_VERTICAL_PROPERTY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61409_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        if (level.m_5776_()) {
            return null;
        }
        Direction hitFace = ctx.m_43719_();
        BlockPos hitPos = ctx.m_8083_();
        BlockState hitState = level.m_8055_(hitPos.m_121955_(hitFace.m_122424_().m_122436_()));
        if (!hitState.m_60783_((BlockGetter)level, hitPos, hitFace)) {
            return null;
        }
        Direction horizontalFacing = hitFace;
        Direction verticalFacing = Direction.SOUTH;
        if (hitFace.m_122434_() == Direction.Axis.Y) {
            horizontalFacing = ctx.m_43723_() == null ? Direction.SOUTH : ctx.m_43723_().m_6350_().m_122424_();
            verticalFacing = hitFace;
        }
        Quaternionf rotation = RotationUtil.getRotation(verticalFacing, horizontalFacing);
        for (int y = 1; y <= this.type.height - 1; ++y) {
            BlockPos topPos = RotationUtil.rotate(new BlockPos(0, y, 0), rotation).m_121955_((Vec3i)hitPos);
            if (level.m_8055_(topPos).m_247087_()) continue;
            return null;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)horizontalFacing)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(verticalFacing)))).m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            Quaternionf rotation = RotationUtil.getRotation(pState);
            int height = pState.m_61145_((Property)BlockStateProperties.f_61409_).orElse(-1);
            if (height < 0) {
                return Blocks.f_50016_.m_49966_();
            }
            for (int i = 0; i <= this.type.height - 1; ++i) {
                int y = i - height;
                if (y == 0) continue;
                BlockPos topPos = RotationUtil.rotate(new BlockPos(0, y, 0), rotation).m_121955_((Vec3i)pCurrentPos);
                pLevel.m_7731_(topPos, Blocks.f_50016_.m_49966_(), 3);
            }
            return Blocks.f_50016_.m_49966_();
        }
        return pState;
    }

    @ParametersAreNonnullByDefault
    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction horizontalFacing;
        Direction verticalFacing = JSGProperties.getDirectionByVerticalFacing(pState.m_61145_((Property)JSGProperties.FACING_VERTICAL_PROPERTY).orElse(0));
        Quaternionf rotation = RotationUtil.getRotation(verticalFacing, horizontalFacing = pState.m_61145_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY).orElse(Direction.SOUTH));
        BlockPos wallPos = RotationUtil.rotate(new BlockPos(0, 0, -1), rotation).m_121955_((Vec3i)pPos);
        BlockState wallState = pLevel.m_8055_(wallPos);
        if (!wallState.m_60783_((BlockGetter)pLevel, wallPos, verticalFacing != null ? verticalFacing : horizontalFacing)) {
            return false;
        }
        int height = pState.m_61145_((Property)BlockStateProperties.f_61409_).orElse(-1);
        if (height < 0) {
            return false;
        }
        if (height == 0) {
            for (int y = 1; y <= this.type.height - 1; ++y) {
                BlockPos posOver = RotationUtil.rotate(new BlockPos(0, y, 0), rotation).m_121955_((Vec3i)pPos);
                BlockState stateOver = pLevel.m_8055_(posOver);
                if (!stateOver.m_60713_((Block)this) || stateOver.m_61145_((Property)BlockStateProperties.f_61409_).orElse(-1) == y) continue;
                return false;
            }
            return true;
        }
        for (int y = 1; y <= height; ++y) {
            BlockPos posUnder = RotationUtil.rotate(new BlockPos(0, -y, 0), rotation).m_121955_((Vec3i)pPos);
            BlockState stateUnder = pLevel.m_8055_(posUnder);
            if (!stateUnder.m_60713_((Block)this)) {
                return false;
            }
            if (stateUnder.m_61145_((Property)BlockStateProperties.f_61409_).orElse(-1) == height - y) continue;
            return false;
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        Quaternionf rotation = RotationUtil.getRotation(pState);
        for (int y = 1; y <= this.type.height - 1; ++y) {
            BlockPos topPos = RotationUtil.rotate(new BlockPos(0, y, 0), rotation).m_121955_((Vec3i)pPos);
            pLevel.m_7731_(topPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(y)), y == this.type.height - 1 ? 3 : 2);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_) {
            CartoucheBlock.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        Integer height = state.m_61145_((Property)BlockStateProperties.f_61409_).orElse(0);
        Quaternionf rotation = RotationUtil.getRotation(state);
        BlockPos bottomPos = RotationUtil.rotate(new BlockPos(0, -height.intValue(), 0), rotation).m_121955_((Vec3i)pos);
        BlockState bottomState = level.m_8055_(bottomPos);
        if (!bottomState.m_60713_(state.m_60734_())) {
            return;
        }
        int maxY = ((CartoucheBlock)bottomState.m_60734_()).type.height;
        for (int y = 0; y <= maxY - 1; ++y) {
            BlockPos partPos = RotationUtil.rotate(new BlockPos(0, y, 0), rotation).m_121955_((Vec3i)bottomPos);
            BlockState partState = level.m_8055_(partPos);
            if (!partState.m_60713_(state.m_60734_()) || (Integer)partState.m_61143_((Property)BlockStateProperties.f_61409_) != y) continue;
            BlockState newState = partState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(partPos, newState, 35);
            level.m_5898_(player, 2001, partPos, Block.m_49956_((BlockState)partState));
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Integer height = state.m_61145_((Property)BlockStateProperties.f_61409_).orElse(0);
        Quaternionf rotation = RotationUtil.getRotation(state);
        BlockPos bePos = RotationUtil.rotate(new BlockPos(0, -height.intValue(), 0), rotation).m_121955_((Vec3i)pos);
        BlockEntity be = level.m_7702_(bePos);
        if (be instanceof CartoucheBE) {
            IAddress address;
            CompoundTag addressTag;
            CompoundTag pageTag;
            CartoucheBE cartouche = (CartoucheBE)be;
            ItemStack usedStack = player.m_21120_(hand);
            Item item = usedStack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (!level.m_5776_()) {
                    cartouche.setColor(dye.m_41089_());
                    level.m_5594_(null, cartouche.m_58899_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        usedStack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (usedStack.m_41720_() instanceof GlowInkSacItem) {
                if (!level.m_5776_()) {
                    cartouche.setShiny(true);
                    level.m_5594_(null, cartouche.m_58899_(), SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        usedStack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            ItemStack mainStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (mainStack.m_41720_() == ItemRegistry.BLACK_CHALK.get() && offStack.m_41720_() == ItemRegistry.NOTEBOOK_PAGE_EMPTY.get()) {
                IAddress address2;
                if (!level.f_46443_ && (address2 = cartouche.getAddress()) != null) {
                    CompoundTag addressCompound = PageNotebookItemFilled.getCompoundFromAddress(address2, cartouche.getSymbolsToDisplay(), PageNotebookItemFilled.getBiomeKeyFromWorld(level, cartouche.m_58899_()), cartouche.getPointOfOrigin(), NotebookPageSerialization.STARGATES);
                    ItemStack newStack = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get(), 1);
                    newStack.m_41751_(addressCompound);
                    player.m_36356_(newStack);
                    offStack.m_41774_(1);
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_12493_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    mainStack.m_220157_(1, level.f_46441_, (ServerPlayer)player);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (mainStack.m_41720_() == ItemRegistry.JSG_HAMMER.get() && offStack.m_41782_() && (pageTag = offStack.m_41783_()) != null && (addressTag = pageTag.m_128441_("addressList") ? NotebookItem.getSelectedPageFromCompound(pageTag) : pageTag) != null && (address = NotebookPageSerialization.getDeserializedAddress(addressTag)) instanceof StargateAddress) {
                StargateAddress stargateAddress = (StargateAddress)address;
                StargateAddressDynamic addressDynamic = new StargateAddressDynamic(stargateAddress);
                addressDynamic = addressDynamic.addOriginIfMissingAndImmutable();
                PointOfOrigin origin = null;
                if (addressTag.m_128441_("origin")) {
                    origin = PointOfOrigin.fromNBT(addressTag.m_128469_("origin"), null);
                }
                if (!level.f_46443_) {
                    int[] symbolsToDisplay = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
                    if (addressTag.m_128441_("symbolsToDisplay")) {
                        symbolsToDisplay = addressTag.m_128465_("symbolsToDisplay");
                    }
                    cartouche.setAddress(addressDynamic, origin, symbolsToDisplay);
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    mainStack.m_220157_(1, level.f_46441_, (ServerPlayer)player);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    @Override
    @Nullable
    public RegistryObject<CreativeModeTab> getTab() {
        return TabRegistry.TAB_CARTOUCHES;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.rotateDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), rotation));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.flipDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), mirror));
    }

    @NotNull
    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CartoucheBE(pPos, pState);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Quaternionf rotation = RotationUtil.getRotation(pState);
        JSGAxisAlignedBB aabb = RotationUtil.rotate(this.type.box(false), rotation, new Vec3(0.5, 0.5, 0.5));
        return Shapes.m_83064_((AABB)aabb);
    }

    @Override
    public JSGBlockItem getItemBlock() {
        return new CartoucheItem(this, new Item.Properties(), (List<RegistryObject<CreativeModeTab>>)this.getTabs());
    }
}

