/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.stargate;

import dev.tauri.jsg.api.block.stargate.IStargateBlock;
import dev.tauri.jsg.api.block.stargate.IStargateChevronBlock;
import dev.tauri.jsg.api.block.stargate.IStargateRingBlock;
import dev.tauri.jsg.api.block.util.IHighlightBlock;
import dev.tauri.jsg.api.block.util.IItemBlock;
import dev.tauri.jsg.api.block.util.WrenchRotatable;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.api.item.JSGBlockItem;
import dev.tauri.jsg.api.multistructure.merging.IMergeHelper;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.block.TickableBEBlock;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.item.stargate.StargateBaseItem;
import dev.tauri.jsg.registry.TabRegistry;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class StargateAbstractBaseBlock
extends TickableBEBlock
implements IItemBlock,
IStargateBlock,
IHighlightBlock,
SimpleWaterloggedBlock,
ITabbedItem,
WrenchRotatable {
    protected static final BlockBehaviour.Properties STARGATE_BASE_PROPS = BlockBehaviour.Properties.m_284310_().m_60913_(2.5f, 30.0f).m_60924_((state, getter, pos) -> true).m_60971_((state, getter, pos) -> false).m_60991_((state, getter, pos) -> false).m_60953_(s -> 0).m_60955_().m_60918_(SoundType.f_56743_).m_278166_(PushReaction.BLOCK).m_60999_();

    public StargateAbstractBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(true))).m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)Direction.NORTH)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public JSGBlockItem getItemBlock() {
        return new StargateBaseItem(this, new Item.Properties(), this.getTabs());
    }

    @Override
    @Nullable
    public RegistryObject<CreativeModeTab> getTab() {
        return TabRegistry.TAB_TRANSPORTATION;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.rotateDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), rotation));
    }

    @Override
    public void onWrenchUse(BlockState state, UseOnContext context) {
        BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
        if (be instanceof Stargate) {
            Stargate gate = (Stargate)be;
            if (gate.isMerged()) {
                return;
            }
            Direction facing = gate.getFacing();
            Direction vertical = gate.getFacingVertical();
            Pair<Direction, Direction> next = StargateAbstractBaseBlock.getNextDirections(facing, vertical);
            state = (BlockState)((BlockState)state.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)((Direction)next.left()))).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection((Direction)next.right())));
            context.m_43725_().m_7731_(context.m_8083_(), state, 3);
            gate.getMergeHelper().updateMemberStateAndCheck(null);
        }
    }

    public static Pair<Direction, Direction> getNextDirections(Direction facing, Direction facingVertical) {
        if (facingVertical == Direction.UP) {
            return Pair.of((Object)facing, (Object)Direction.DOWN);
        }
        if (facingVertical == Direction.DOWN) {
            return Pair.of((Object)facing.m_122427_(), (Object)Direction.SOUTH);
        }
        return Pair.of((Object)facing, (Object)Direction.UP);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return (BlockState)blockState.m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)BlockPosHelper.flipDir((Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY), mirror));
    }

    @Override
    public boolean renderHighlight(BlockState blockState, BlockGetter level, BlockPos pos) {
        CamouflageBE camoBE;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CamouflageBE && !(camoBE = (CamouflageBE)tile).getCamoBlock().m_60795_()) {
            return true;
        }
        return blockState.m_61138_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) && (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false;
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_7705_(), components, tooltipFlag);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean shift = player.m_6144_();
        boolean autoBuild = false;
        boolean guiDisplayed = false;
        boolean camoChanged = false;
        if (!level.f_46443_) {
            CamouflageBE tile;
            BlockEntity blockEntity;
            if (!shift && !(autoBuild = this.tryAutoBuild(player, level, pos, hand)) && hand == InteractionHand.MAIN_HAND && (blockEntity = level.m_7702_(pos)) instanceof CamouflageBE && !(camoChanged = (tile = (CamouflageBE)blockEntity).setCamoBlockByHeldItem(player.m_21120_(hand), player, new BlockPlaceContext(level, player, hand, player.m_21120_(hand), hitResult)))) {
                guiDisplayed = this.showGateInfo(player, hand, level, pos);
            }
        } else {
            return InteractionResult.m_19078_((boolean)true);
        }
        return !shift && (autoBuild || guiDisplayed || camoChanged) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    protected abstract boolean showGateInfo(Player var1, InteractionHand var2, Level var3, BlockPos var4);

    protected boolean tryAutoBuild(Player player, Level world, BlockPos basePos, InteractionHand hand) {
        Stargate gateTile = (Stargate)world.m_7702_(basePos);
        if (gateTile == null) {
            return false;
        }
        IMergeHelper mergeHelper = gateTile.getMergeHelper();
        ItemStack stack = player.m_21120_(hand);
        if (!gateTile.isMerged()) {
            boolean chevron = Block.m_49814_((Item)stack.m_41720_()) instanceof IStargateChevronBlock;
            boolean ring = Block.m_49814_((Item)stack.m_41720_()) instanceof IStargateRingBlock;
            if (!chevron && !ring) {
                return false;
            }
            List<IMergeHelper.MemberAutoBuildBlock> posList = mergeHelper.getAbsentBlockPositions(world, chevron);
            if (!posList.isEmpty()) {
                BlockPos pos = posList.get((int)0).pos;
                BlockState state = posList.get((int)0).state;
                world.m_7731_(pos, state, 3);
                SoundType soundType = state.m_60827_();
                world.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (posList.size() == 1) {
                    mergeHelper.updateMemberStateAndCheck(null);
                }
                return true;
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (level.f_46443_) {
            return;
        }
        BlockEntity e = level.m_7702_(blockPos);
        if (e instanceof Stargate) {
            Stargate stargate = (Stargate)e;
            stargate.getMergeHelper().updateMemberStateAndCheck(null);
            stargate.refresh();
            stargate.updateContainerItemsByItemStack(itemStack);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, blockState, player);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof Stargate) {
            Stargate stargate = (Stargate)blockEntity;
            stargate.getMergeHelper().updateMemberStateAndCheck(false);
            if (player.m_7500_()) {
                ItemStack drop = stargate.getDropBaseBlock((ServerPlayer)player);
                ItemHandlerHelper.spawnItemStack(level, pos, drop);
            }
            stargate.onGateBroken();
        }
    }

    @ParametersAreNonnullByDefault
    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity;
        super.m_7592_(level, pos, explosion);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof Stargate) {
            Stargate gateTile = (Stargate)blockEntity;
            gateTile.getMergeHelper().updateMemberStateAndCheck(false);
            gateTile.onGateBroken();
        }
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.RENDER_BLOCK_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.FACING_HORIZONTAL_PROPERTY});
        builder.m_61104_(new Property[]{JSGProperties.FACING_VERTICAL_PROPERTY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @NotNull
    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        float pitch = 0.0f;
        if (ctx.m_43723_() != null) {
            pitch = ctx.m_43723_().m_146909_();
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(JSGProperties.getVerticalDirectionByPitch(pitch).m_122424_())))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false ? Shapes.m_83144_() : StargateAbstractBaseBlock.getGateBlockShape(blockState, blockGetter, blockPos);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5909_(BlockState blockState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) != false ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public static VoxelShape getGateBlockShape(BlockState blockState, BlockGetter level, BlockPos pos) {
        if (((Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY)).booleanValue()) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83064_((AABB)StargateAbstractBaseBlock.getGateBlockShapeAABB(blockState, level, pos));
    }

    public static JSGAxisAlignedBB getGateBlockShapeAABB(BlockState blockState, BlockGetter level, BlockPos pos) {
        CamouflageBE camoBE;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CamouflageBE && !(camoBE = (CamouflageBE)tile).getCamoBlock().m_60795_()) {
            return JSGAxisAlignedBB.block();
        }
        return StargateAbstractBaseBlock.getGateBlockShapeAABB(blockState);
    }

    public static JSGAxisAlignedBB getGateBlockShapeAABB(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY)).booleanValue()) {
            return JSGAxisAlignedBB.block();
        }
        BlockPos min = new BlockPos(0, 0, 4);
        BlockPos max = new BlockPos(16, 16, 12);
        Direction horDir = (Direction)blockState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        Direction verDir = JSGProperties.getDirectionByVerticalFacing((Integer)blockState.m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        if (verDir != null) {
            min = new BlockPos(0, 4, 0);
            max = new BlockPos(16, 12, 16);
        } else {
            switch (horDir) {
                case EAST: 
                case WEST: {
                    min = new BlockPos(4, 0, 0);
                    max = new BlockPos(12, 16, 16);
                    break;
                }
            }
        }
        return new JSGAxisAlignedBB(Math.min(Math.abs((double)min.m_123341_() / 16.0), Math.abs((double)max.m_123341_() / 16.0)), Math.min(Math.abs((double)min.m_123342_() / 16.0), Math.abs((double)max.m_123342_() / 16.0)), Math.min(Math.abs((double)min.m_123343_() / 16.0), Math.abs((double)max.m_123343_() / 16.0)), Math.max(Math.abs((double)min.m_123341_() / 16.0), Math.abs((double)max.m_123341_() / 16.0)), Math.max(Math.abs((double)min.m_123342_() / 16.0), Math.abs((double)max.m_123342_() / 16.0)), Math.max(Math.abs((double)min.m_123343_() / 16.0), Math.abs((double)max.m_123343_() / 16.0)));
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

