/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.stargate.redstone;

import dev.tauri.jsg.api.block.JSGBlock;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicMemberBE;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.registry.TabRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStargateRedstoneIO
extends JSGBlock
implements ITabbedItem {
    protected static final BlockBehaviour.Properties IO_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60955_().m_60924_((pState, pLevel, pPos) -> true);

    public AbstractStargateRedstoneIO() {
        super(IO_PROPERTIES);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)Direction.SOUTH)).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    public boolean m_7899_(BlockState pState) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public StargateClassicBaseBE<?> getGate(BlockGetter level, BlockPos pos, BlockState state) {
        if (level == null) {
            return null;
        }
        if (state == null) {
            return null;
        }
        if (pos == null) {
            return null;
        }
        Direction facing = ((Direction)state.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY)).m_122424_();
        BlockEntity tile = level.m_7702_(pos.m_121955_(facing.m_122436_()));
        if (tile instanceof StargateClassicBaseBE) {
            StargateClassicBaseBE sg = (StargateClassicBaseBE)tile;
            return sg;
        }
        if (tile instanceof StargateClassicMemberBE) {
            BlockEntity blockEntity;
            StargateClassicMemberBE member = (StargateClassicMemberBE)tile;
            if (member.basePos != null && (blockEntity = level.m_7702_(member.basePos)) instanceof StargateClassicBaseBE) {
                StargateClassicBaseBE sg = (StargateClassicBaseBE)blockEntity;
                return sg;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public RegistryObject<CreativeModeTab> getTab() {
        return TabRegistry.TAB_TRANSPORTATION;
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_7705_(), components, tooltipFlag);
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        StargateClassicBaseBE<?> sg;
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.m_5776_() && (sg = this.getGate((BlockGetter)pLevel, pPos, pState)) != null) {
            sg.addRedstoneDevice(pPos);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlacer) {
        StargateClassicBaseBE<?> sg;
        super.m_5707_(pLevel, pPos, pState, pPlacer);
        if (!pLevel.m_5776_() && (sg = this.getGate((BlockGetter)pLevel, pPos, pState)) != null) {
            sg.removeRedstoneDevice(pPos);
        }
    }

    public abstract boolean shouldUpdateNeighbours(BlockState var1, ServerLevel var2, BlockPos var3, StargateClassicBaseBE<?> var4);

    @ParametersAreNonnullByDefault
    public void tickFromStargate(BlockState state, ServerLevel level, BlockPos pos, StargateClassicBaseBE<?> gateTile) {
        if (!this.shouldUpdateNeighbours(state, level, pos, gateTile)) {
            return;
        }
        AbstractStargateRedstoneIO.updateNeighbours((Level)level, pos, state);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{JSGProperties.FACING_HORIZONTAL_PROPERTY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)ctx.m_8125_().m_122424_());
    }

    @ParametersAreNonnullByDefault
    public int m_6378_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        StargateClassicBaseBE<?> gateTile = this.getGate(pLevel, pPos, pState);
        if (gateTile == null) {
            return 0;
        }
        return this.getOutputSignal(pState, pLevel, pPos, pDirection, gateTile);
    }

    public static void updateNeighbours(Level pLevel, BlockPos pPos, BlockState pState) {
        Block block = pState.m_60734_();
        pLevel.m_46672_(pPos, block);
        pLevel.m_46672_(pPos.m_7495_(), block);
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        StargateClassicBaseBE<?> gateTile = this.getGate((BlockGetter)pLevel, pPos, pState);
        if (gateTile == null) {
            return;
        }
        Direction blockDirection = (Direction)pState.m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        HashMap<Direction, Integer> signals = new HashMap<Direction, Integer>();
        for (Direction direction : Direction.values()) {
            Direction directionRotated = Direction.m_122364_((double)(blockDirection.m_122435_() + direction.m_122435_()));
            if (blockDirection.m_122434_() == Direction.Axis.Z) {
                directionRotated = directionRotated.m_122424_();
            }
            signals.put(direction.m_122434_() == Direction.Axis.Y ? direction : directionRotated, pLevel.m_277185_(pPos.m_121955_(direction.m_122436_()), direction));
        }
        this.processInputSignal(pState, (BlockGetter)pLevel, pPos, pFromPos, signals, gateTile);
    }

    @ParametersAreNonnullByDefault
    public abstract int getOutputSignal(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4, StargateClassicBaseBE<?> var5);

    @ParametersAreNonnullByDefault
    public abstract void processInputSignal(BlockState var1, BlockGetter var2, BlockPos var3, BlockPos var4, Map<Direction, Integer> var5, StargateClassicBaseBE<?> var6);
}

