/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity;

import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.block.invisible.InvisibleBlock;
import dev.tauri.jsg.config.JSGConfigUtil;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.state.CamoState;
import dev.tauri.jsg.state.StateProviderInterface;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CamouflageBE
extends BlockEntity
implements StateProviderInterface {
    private BlockState camoBlock = Blocks.f_50016_.m_49966_();
    private PacketDistributor.TargetPoint targetPointInternal;

    public void onCamoBlockChanged() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.targetPointInternal == null) {
            this.targetPointInternal = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
        }
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), StateType.CAMO_STATE, this.getState(StateType.CAMO_STATE)), this.targetPointInternal);
    }

    public void dropCamo() {
        if (this.camoBlock == null || this.camoBlock.m_60795_()) {
            return;
        }
        ItemHandlerHelper.spawnItemStack(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)this.camoBlock.m_60734_()));
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateType.CAMO_STATE));
        } else {
            this.onCamoBlockChanged();
        }
    }

    public CamouflageBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.onCamoBlockChanged();
    }

    public BlockState getCamoBlock() {
        if (this.camoBlock == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return this.camoBlock;
    }

    public boolean setCamoBlockByHeldItem(ItemStack stack, Player player, @Nullable BlockPlaceContext ctx) {
        BlockState blockState;
        if (stack.m_41619_()) {
            return this.removeCamoBlockAndDrop(player);
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            return false;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block == Blocks.f_50016_) {
            return this.removeCamoBlockAndDrop(player);
        }
        if (block instanceof FlowerBlock) {
            return false;
        }
        if (block instanceof BannerBlock) {
            return false;
        }
        if (block instanceof InvisibleBlock) {
            return false;
        }
        if (!this.getCamoBlock().m_60795_()) {
            return false;
        }
        BlockState blockState2 = blockState = ctx == null ? block.m_49966_() : block.m_5573_(ctx);
        if (!JSGConfigUtil.canBeUsedAsCamoBlock(blockState)) {
            return false;
        }
        this.setCamoBlock(blockState);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), block.m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean removeCamoBlockAndDrop(Player player) {
        if (!this.camoBlock.m_60795_()) {
            if (!player.m_7500_()) {
                ItemHandlerHelper.spawnItemStack(this.f_58857_, this.m_58899_(), new ItemStack((ItemLike)this.camoBlock.m_60734_()));
            }
            this.removeCamoBlock();
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void setCamoBlock(BlockState blockState) {
        this.camoBlock = blockState;
        this.m_6596_();
        this.onCamoBlockChanged();
    }

    public void removeCamoBlock() {
        this.camoBlock = Blocks.f_50016_.m_49966_();
        this.m_6596_();
        this.onCamoBlockChanged();
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        CompoundTag camoBlockData = new CompoundTag();
        String[] data = this.camoBlock.toString().split("\\[");
        camoBlockData.m_128359_("id", data[0].replace("Block{", "").replace("}", ""));
        if (data.length > 1) {
            CompoundTag properties = new CompoundTag();
            Stream.of(data[1].substring(0, data[1].length() - 1).split(",")).forEach(di -> {
                String[] keyValue = di.split("=");
                if (keyValue.length == 2) {
                    properties.m_128359_(keyValue[0].trim(), keyValue[1].trim());
                }
            });
            camoBlockData.m_128365_("properties", (Tag)properties);
        }
        compound.m_128365_("camoBlock_data", (Tag)camoBlockData);
        super.m_183515_(compound);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        if (compound.m_128441_("camoBlock_data")) {
            CompoundTag camoBlockData = compound.m_128469_("camoBlock_data");
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(camoBlockData.m_128461_("id")));
            if (block != null) {
                this.camoBlock = block.m_49966_();
                if (camoBlockData.m_128441_("properties")) {
                    CompoundTag camoProperties = camoBlockData.m_128469_("properties");
                    block.m_49966_().m_61147_().forEach(p -> {
                        if (camoProperties.m_128441_(p.m_61708_()) && p.m_6215_(camoProperties.m_128461_(p.m_61708_())).isPresent()) {
                            this.modifyCamoBLock((Property<?>)p, p.m_6215_(camoProperties.m_128461_(p.m_61708_())));
                        }
                    });
                }
            }
        } else if (compound.m_128441_("camoBlock_id")) {
            this.camoBlock = Block.m_49803_((int)compound.m_128451_("camoBlock_id"));
        }
        super.m_142466_(compound);
    }

    protected final <T extends Comparable<T>, V extends T> void modifyCamoBLock(Property<?> p, Optional<?> value) {
        if (this.camoBlock.m_61138_(p) && value.isPresent()) {
            this.camoBlock = (BlockState)this.camoBlock.m_61124_(p, (Comparable)value.get());
        }
    }

    @Override
    public State getState(StateType stateType) {
        if (stateType == StateType.CAMO_STATE) {
            return new CamoState(this.getCamoBlock());
        }
        return null;
    }

    @Override
    public State createState(StateType stateType) {
        if (stateType == StateType.CAMO_STATE) {
            return new CamoState();
        }
        return null;
    }

    @Override
    public void setState(StateType stateType, State state) {
        if (stateType == StateType.CAMO_STATE) {
            this.setCamoBlock(((CamoState)state).getState());
        }
    }
}

