/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.capacitor;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.power.general.SmallEnergyStorage;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.JSGItemStackHandler;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.screen.inventory.energy.capacitor.CapacitorContainerGuiUpdate;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.energy.CapacitorPowerLevelUpdate;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CapacitorBE
extends BlockEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface {
    protected final ItemStackHandler itemStackHandler = new JSGItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.getCapability(ForgeCapabilities.ENERGY, null).isPresent();
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CapacitorBE.this.m_6596_();
        }
    };
    private final SmallEnergyStorage energyStorage = new SmallEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            CapacitorBE.this.m_6596_();
        }
    };
    protected int energyStoredLastTick = 0;
    protected int energyTransferedLastTick = 0;
    private PacketDistributor.TargetPoint targetPoint;
    private int powerLevel;
    private int lastPowerLevel;

    public CapacitorBE(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    public CapacitorBE(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.CAPACITOR_BLOCK.get(), pos, state);
    }

    public PacketDistributor.TargetPoint getTargetPoint() {
        return this.targetPoint;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public SmallEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void onLoad() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.targetPoint = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
        } else {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateType.RENDERER_UPDATE));
        }
    }

    @Override
    public void tick(@NotNull Level level) {
        if (!level.f_46443_) {
            for (Direction facing : Direction.values()) {
                Optional cap;
                BlockEntity tile = level.m_7702_(this.m_58899_().m_121955_(facing.m_122436_()));
                if (tile == null || (cap = tile.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).resolve()).isEmpty()) continue;
                int extracted = this.getEnergyStorage().extractEnergy(JSGConfig.Stargate.stargateMaxEnergyTransfer.get(), true);
                extracted = ((IEnergyStorage)cap.get()).receiveEnergy(extracted, false);
                this.getEnergyStorage().extractEnergy(extracted, false);
            }
            ItemStack stack = this.itemStackHandler.getStackInSlot(0);
            if (!stack.m_41619_() && stack.getCapability(ForgeCapabilities.ENERGY, null).isPresent()) {
                IEnergyStorage targetEnergyStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).resolve().orElseThrow();
                int extracted = this.getEnergyStorage().extractEnergy(JSGConfig.Stargate.stargateMaxEnergyTransfer.get(), true);
                extracted = targetEnergyStorage.receiveEnergy(extracted, false);
                this.getEnergyStorage().extractEnergy(extracted, false);
            }
            this.powerLevel = Math.round((float)this.getEnergyStorage().getEnergyStored() / (float)this.getEnergyStorage().getMaxEnergyStored() * 10.0f);
            if (this.powerLevel != this.lastPowerLevel) {
                level.m_7731_(this.m_58899_(), (BlockState)level.m_8055_(this.m_58899_()).m_61124_((Property)JSGProperties.LEVEL, (Comparable)Integer.valueOf(this.powerLevel)), 3);
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), StateType.RENDERER_UPDATE, this.getState(StateType.RENDERER_UPDATE)), this.targetPoint);
                this.lastPowerLevel = this.powerLevel;
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("energyStorage", (Tag)this.getEnergyStorage().serializeNBT());
        compound.m_128365_("itemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.getEnergyStorage().deserializeNBT(compound.m_128469_("energyStorage"));
        this.itemStackHandler.deserializeNBT(compound.m_128469_("itemStackHandler"));
        super.m_142466_(compound);
    }

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(this::getEnergyStorage).cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemStackHandler).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public State getState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.RENDERER_UPDATE, () -> new CapacitorPowerLevelUpdate(this.powerLevel)).tryType(StateType.GUI_UPDATE, () -> new CapacitorContainerGuiUpdate(this.getEnergyStorage().getEnergyStored(), this.energyTransferedLastTick)).orElseThrow(this);
    }

    @Override
    public State createState(StateType stateType) {
        return stateType.stateSupplier().tryType(StateType.RENDERER_UPDATE, CapacitorPowerLevelUpdate::new).tryType(StateType.GUI_UPDATE, CapacitorContainerGuiUpdate::new).orElseThrow(this);
    }

    @Override
    public void setState(StateType stateType, State state) {
        stateType.stateExecutor().tryType(StateType.RENDERER_UPDATE, () -> {
            this.powerLevel = ((CapacitorPowerLevelUpdate)state).powerLevel;
            this.m_6596_();
            Level level = this.m_58904_();
            if (level == null) {
                return;
            }
            level.m_7731_(this.m_58899_(), (BlockState)level.m_8055_(this.m_58899_()).m_61124_((Property)JSGProperties.LEVEL, (Comparable)Integer.valueOf(this.powerLevel)), 3);
            level.m_151543_(this.m_58899_());
        }).tryType(StateType.GUI_UPDATE, () -> {
            CapacitorContainerGuiUpdate guiUpdate = (CapacitorContainerGuiUpdate)state;
            this.getEnergyStorage().setEnergyStored(guiUpdate.energyStored);
            this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
            this.m_6596_();
        }).run();
    }

    @Override
    public void sendState(StateType type, State state) {
    }
}

