/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.multistructure.IMultiStructureBE;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.power.JSGEnergyStorage;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.IPositionedSound;
import dev.tauri.jsg.api.sound.ISoundEvent;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.listener.IStargateListenerHandler;
import dev.tauri.jsg.api.stargate.manager.IStargateStateManager;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.IStargateGenerator;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfigEntry;
import dev.tauri.jsg.integration.ComputerDeviceHolder;
import dev.tauri.jsg.item.linkable.dialer.modes.UniverseDialerModes;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.multistructure.mergehelper.StargateAbstractMergeHelper;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.stargate.StargateListenerHandler;
import dev.tauri.jsg.stargate.manager.StargateAutoCloseManager;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.rig.StargateRIGManager;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.util.JSGAdvancementsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class StargateAbstractBaseBE<S extends StargateAbstractRendererState, E extends JSGEnergyStorage>
extends CamouflageBE
implements Stargate<E>,
IMultiStructureBE<StargateAbstractMergeHelper> {
    protected final StargateAbstractStateManager<?, S> stateManager = this.createStateManager();
    protected final StargateSoundManager<?> soundManager = this.createSoundManager();
    protected final StargateAbstractDialingManager<?> stargateDialingManager = this.createDialingManager();
    protected final StargateEnergyManager<?, E> stargateEnergyManager = this.createEnergyManager();
    protected final StargateRIGManager rigManager = new StargateRIGManager(this);
    protected final IStargateListenerHandler listenerHandler = new StargateListenerHandler(this);
    protected final StargateEventHorizonManager eventHorizon = this.createEventHorizonManager();
    protected StargateAutoCloseManager autoCloseManager;
    protected ComputerDeviceHolder computerDeviceHolder;
    protected final Map<AbstractSymbolType<?>, StargateAddress> gateAddressMap = new HashMap();
    protected StargatePos stargatePos;
    protected StargateAbstractMergeHelper mergeHelper = null;
    protected boolean isMerged;
    protected boolean addedToComputerNetwork;
    protected boolean needRegenerate = false;
    public Map<AbstractSymbolType<?>, StargateAddress> gateAddressMapClient = new HashMap();
    protected List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public StargateAbstractBaseBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        this.generateMergeHelper();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.createDeviceHolder();
        }
        this.m_6596_();
    }

    @Override
    public long getTime() {
        if (this.f_58857_ == null) {
            return 0L;
        }
        return this.f_58857_.m_46467_();
    }

    @Override
    public StargateNetwork getNetwork() {
        return StargateNetwork.INSTANCE;
    }

    @Override
    public abstract StargateAbstractStateManager<?, S> createStateManager();

    @Override
    public abstract StargateAbstractDialingManager<?> createDialingManager();

    public abstract StargateEnergyManager<?, E> createEnergyManager();

    @Override
    public abstract StargateEventHorizonManager createEventHorizonManager();

    @Override
    public StargateSoundManager<?> createSoundManager() {
        return new StargateSoundManager<StargateAbstractBaseBE>(this);
    }

    @Override
    public StargateRIGManager getRIGManager() {
        return this.rigManager;
    }

    @Override
    public StargateAbstractDialingManager<?> getDialingManager() {
        return this.stargateDialingManager;
    }

    public StargateEnergyManager<?, E> getEnergyManager() {
        return this.stargateEnergyManager;
    }

    @Override
    public StargateAbstractStateManager<?, S> getStateManager() {
        return this.stateManager;
    }

    @Override
    public StargateSoundManager<?> getSoundManager() {
        return this.soundManager;
    }

    @Override
    public StargateAutoCloseManager getAutoCloseManager() {
        if (this.autoCloseManager == null) {
            this.autoCloseManager = new StargateAutoCloseManager(this);
        }
        return this.autoCloseManager;
    }

    @Override
    public IStargateListenerHandler getListenerHandler() {
        return this.listenerHandler;
    }

    @Override
    public StargateEventHorizonManager getEventHorizonManager() {
        return this.eventHorizon;
    }

    @Override
    public Map<AbstractSymbolType<?>, StargateAddress> getAddressMap() {
        return Map.copyOf(this.gateAddressMap);
    }

    @Override
    @Nullable
    public StargateAddress getStargateAddress(AbstractSymbolType<?> symbolType) {
        if (this.gateAddressMap == null) {
            return null;
        }
        return this.gateAddressMap.get(symbolType);
    }

    @Override
    public void setGateAddress(AbstractSymbolType<?> symbolType, StargateAddress stargateAddress) {
        this.initStargatePos();
        this.gateAddressMap.put(symbolType, stargateAddress);
        this.getNetwork().putStargate(stargateAddress, this.stargatePos);
        JSG.logger.debug("Setting gate's address at {} to {} ({})", this.stargatePos.toString(), stargateAddress.toString(), symbolType.toString());
        this.m_6596_();
    }

    @Override
    public StargatePos getStargatePos() {
        if (this.stargatePos == null) {
            this.initStargatePos();
        }
        return this.stargatePos;
    }

    @Override
    public void renameStargatePos(String newName) {
        this.initStargatePos();
        this.getNetwork().renameStargate(this.stargatePos, newName);
        this.stargatePos.setName(newName);
        this.m_6596_();
    }

    @Override
    public void initStargatePos() {
        StargatePos oldPos = this.stargatePos;
        if (this.m_58904_() == null) {
            return;
        }
        StargatePos gatePos = new StargatePos((ResourceKey<Level>)this.m_58904_().m_46472_(), this.m_58899_(), this.getSymbolType(), this.getStargateType());
        if (oldPos != null) {
            gatePos.setName(oldPos.getName());
        }
        this.stargatePos = gatePos;
        this.m_6596_();
    }

    @Override
    public void refresh() {
        this.initStargatePos();
        if (this.stargatePos != null) {
            this.getNetwork().removeStargate(this.stargatePos);
        }
        for (AbstractSymbolType<?> s : AbstractSymbolType.values(SymbolUsage.STARGATES)) {
            StargateAddress address = this.getStargateAddress(s);
            if (address == null) {
                this.generateAddresses(true);
                break;
            }
            this.setGateAddress(s, address);
        }
        this.updateFacing();
        this.m_6596_();
    }

    @Override
    public boolean shouldAutoclose() {
        if (!JSGConfig.Stargate.autocloseEnabled.get()) {
            return false;
        }
        if (!this.rigManager.isActive()) {
            return ((StargateAbstractDialingManager)this.getDialingManager()).getConnection().callIfInitiating((conn, sg) -> this.getAutoCloseManager().shouldClose(sg.getStargatePos()), () -> false);
        }
        return !this.rigManager.isActive();
    }

    @Override
    public final boolean isMerged() {
        return this.isMerged;
    }

    @Override
    public void setMerged(boolean merged) {
        this.isMerged = merged;
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        if (this.mergeHelper == null) {
            this.generateMergeHelper();
        }
        return this.mergeHelper;
    }

    @Override
    public void updateFacing() {
        this.generateMergeHelper();
        this.getEventHorizonManager().onFacingUpdated();
    }

    @Override
    public boolean prepareBE() {
        ILinkable linkable;
        this.needRegenerate = true;
        StargateAbstractBaseBE stargateAbstractBaseBE = this;
        if (stargateAbstractBaseBE instanceof ILinkable && (linkable = (ILinkable)((Object)stargateAbstractBaseBE)).isLinked()) {
            Object t = linkable.getLinkedDevice();
            if (t instanceof ILinkable) {
                ILinkable linkableTarget = (ILinkable)t;
                linkableTarget.setLinkedDevice(null);
            }
            linkable.setLinkedDevice(null);
        }
        this.m_6596_();
        return true;
    }

    @Override
    public void onGateBroken() {
        Stargate.super.onGateBroken();
        this.dropCamo();
    }

    @Override
    public void onGateUnmerged(boolean external) {
        Level level;
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (external) {
            this.getMergeHelper().updateMemberStateAndCheck(false);
            this.generateMergeHelper();
        }
        if ((level = this.m_58904_()) == null) {
            return;
        }
        this.setMerged(false);
        level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(true)));
        if (level.m_8055_(this.getGateCenterPos()).m_60734_() == Blocks.f_152480_) {
            level.m_7731_(this.getGateCenterPos(), Blocks.f_50016_.m_49966_(), 3);
        }
        ((StargateAbstractStateManager)this.getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.GATE_RENDER_CHANGED, false);
        ((StargateAbstractDialingManager)this.getDialingManager()).onGateUnmerged();
        ((StargateSoundManager)this.getSoundManager()).updateWormholeSound(false);
        this.m_6596_();
    }

    @Override
    public void onGateMerged() {
        this.setMerged(true);
        this.m_6596_();
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(false)));
        IStargateStateManager s = this.getStateManager();
        ((StargateAbstractStateManager)s).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.GATE_RENDER_CHANGED, true);
        s.getAndSendState(StateType.RENDERER_STATE);
        JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.GATE_MERGE);
        this.refresh();
    }

    @Override
    public void tryRegenerateStargateIfNeeded() {
        if (this.needRegenerate) {
            IStargateGenerator.PlacementConfig pConfig = new IStargateGenerator.PlacementConfig();
            pConfig.baseInPlace = true;
            pConfig.stargateEnergyInternal = 10000;
            this.regenerateStargate(pConfig);
            this.needRegenerate = false;
            this.m_6596_();
        }
    }

    @Override
    public boolean isBlackHoleEffected() {
        Level l = this.m_58904_();
        if (l == null) {
            return false;
        }
        StargateDimensionConfigEntry e = StargateDimensionConfig.INSTANCE.getConfigEntry((ResourceKey<Level>)l.m_46472_());
        if (e == null) {
            return false;
        }
        return e.isBlackHoleDim;
    }

    @Override
    public ItemStack getAddressPage(AbstractSymbolType<?> symbolType, ItemStack defaultStack, int[] symbolsToDisplay) {
        ItemStack stack = defaultStack;
        Map<AbstractSymbolType<?>, StargateAddress> gateAddressMap = this.getAddressMap();
        if (stack.m_41720_() == ItemRegistry.UNIVERSE_DIALER.get()) {
            UniverseDialerModes.MEMORY.addEntry(gateAddressMap.get(symbolType), symbolsToDisplay, 0, stack);
        } else {
            JSG.logger.debug("Giving Notebook page of address {}", (Object)symbolType);
            CompoundTag compound = PageNotebookItemFilled.getCompoundFromAddress((IAddress)gateAddressMap.get(symbolType), symbolsToDisplay, PageNotebookItemFilled.getBiomeKeyFromWorld(this.m_58904_(), this.m_58899_()), this.getPointOfOrigin(symbolType), NotebookPageSerialization.STARGATES);
            stack = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get(), 1);
            stack.m_41751_(compound);
        }
        return stack;
    }

    @Override
    public void playPositionedSound(IPositionedSound positionedSound, boolean play) {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        JSGSoundHelper.playPositionedSound(level, this.getGateCenterPos(), positionedSound, play);
    }

    @Override
    public void playSoundEvent(ISoundEvent soundEnum, float pitch) {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        if (level.m_5776_()) {
            JSGSoundHelper.playSoundEventClientSide(level, this.getGateCenterPos(), soundEnum, pitch);
        } else {
            JSGSoundHelper.playSoundEvent(level, this.getGateCenterPos(), soundEnum, pitch);
        }
    }

    public void createDeviceHolder() {
        this.computerDeviceHolder = new ComputerDeviceHolder(this);
    }

    @Override
    public ComputerDeviceHolder getDeviceHolder() {
        if (this.computerDeviceHolder == null) {
            this.createDeviceHolder();
        }
        return this.computerDeviceHolder;
    }

    @Override
    public String getDeviceType() {
        return "STARGATE_ABSTRACT";
    }

    @Override
    public final State getState(StateType stateType) {
        State pState = ((StargateAbstractStateManager)this.getStateManager()).getState(stateType);
        if (pState != null) {
            return pState;
        }
        return super.getState(stateType);
    }

    @Override
    public final State createState(StateType stateType) {
        State pState = ((StargateAbstractStateManager)this.getStateManager()).createState(stateType);
        if (pState != null) {
            return pState;
        }
        return super.createState(stateType);
    }

    @Override
    public final void setState(StateType stateType, State state) {
        ((StargateAbstractStateManager)this.getStateManager()).setState(stateType, state);
        super.setState(stateType, state);
    }

    @Override
    public void sendState(StateType type, State state) {
        ((StargateAbstractStateManager)this.getStateManager()).sendState(type, state);
    }

    public AABB getRenderBoundingBox() {
        return this.relative(new JSGAxisAlignedBB(-4.5, -0.5, -0.5, 4.5, 8.5, 8.0).offset(new Vec3(0.5, 0.5, 0.5)), new Vec3(0.5, 0.5, 0.5));
    }

    @Override
    public void onLoad() {
        this.onStargateLoaded();
        super.onLoad();
    }

    @Override
    public void tick(Level level) {
        Stargate.super.tick(level);
        ScheduledTask.iterate(this.scheduledTasks, this.getTime());
        if (!level.f_46443_) {
            if (!this.addedToComputerNetwork) {
                this.addedToComputerNetwork = true;
                this.getDeviceHolder().connectToWirelessNetwork();
            }
            if (this.getTime() % 100L == 0L) {
                StargateComputerEvents.PING.get().sendVia(this);
            }
        }
    }

    public void onChunkUnloaded() {
        this.getRIGManager().onUnload();
        this.getDeviceHolder().disconnectFromWirelessNetwork();
        super.onChunkUnloaded();
    }

    public void invalidateCaps() {
        this.getDeviceHolder().disconnectFromWirelessNetwork();
        super.invalidateCaps();
    }

    @Override
    public final <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return this.getStargateCapability(capability, facing);
    }

    @Override
    public <T> LazyOptional<T> getStargateCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> computerCaps = this.getDeviceHolder().getOrCreateDeviceBasedOnCap(capability);
        if (computerCaps.isPresent()) {
            return computerCaps;
        }
        if (capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.getEnergyManager().getStorage()).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public PointOfOrigin getPointOfOrigin(IPointOfOriginType pointOfOriginType) {
        return pointOfOriginType.getDefaultPoO();
    }

    @Override
    @Nullable
    public PointOfOrigin getPointOfOrigin(AbstractSymbolType<?> symbolType) {
        return this.getPointOfOrigin(symbolType.getPointOfOriginType());
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("soundManager", (Tag)((StargateSoundManager)this.getSoundManager()).serializeNBT());
        compound.m_128365_("stargateEnergyManager", (Tag)((StargateEnergyManager)this.getEnergyManager()).serializeNBT());
        compound.m_128365_("stargateDialingManager", (Tag)((StargateAbstractDialingManager)this.getDialingManager()).serializeNBT());
        compound.m_128365_("stateManager", (Tag)((StargateAbstractStateManager)this.getStateManager()).serializeNBT());
        compound.m_128365_("eventHorizon", (Tag)this.getEventHorizonManager().serializeNBT());
        compound.m_128365_("autoCloseManager", (Tag)this.getAutoCloseManager().serializeNBT());
        compound.m_128379_("isMerged", this.isMerged());
        compound.m_128365_("listenerHandler", this.getListenerHandler().serializeNBT());
        compound.m_128379_("needRegenerate", this.needRegenerate);
        for (StargateAddress stargateAddress : this.gateAddressMap.values()) {
            compound.m_128365_("address_" + String.valueOf(stargateAddress.getSymbolType()), (Tag)stargateAddress.serializeNBT());
        }
        compound.m_128365_("scheduledTasks", (Tag)ScheduledTask.serializeList(this.scheduledTasks));
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("soundManager")) {
            ((StargateSoundManager)this.getSoundManager()).deserializeNBT(compound.m_128469_("soundManager"));
            ((StargateEnergyManager)this.getEnergyManager()).deserializeNBT(compound.m_128469_("stargateEnergyManager"));
            ((StargateAbstractDialingManager)this.getDialingManager()).deserializeNBT(compound.m_128469_("stargateDialingManager"));
            ((StargateAbstractStateManager)this.getStateManager()).deserializeNBT(compound.m_128469_("stateManager"));
            this.getEventHorizonManager().deserializeNBT(compound.m_128469_("eventHorizon"));
        }
        this.getAutoCloseManager().deserializeNBT(compound.m_128469_("autoCloseManager"));
        this.setMerged(compound.m_128471_("isMerged"));
        this.getListenerHandler().deserializeNBT((Tag)compound.m_128469_("listenerHandler"));
        this.needRegenerate = compound.m_128471_("needRegenerate");
        for (AbstractSymbolType<?> symbolType : AbstractSymbolType.values(SymbolUsage.STARGATES)) {
            if (!compound.m_128441_("address_" + String.valueOf(symbolType))) continue;
            this.gateAddressMap.put(symbolType, new StargateAddress(compound.m_128469_("address_" + String.valueOf(symbolType))));
        }
        try {
            ScheduledTask.deserializeList(compound.m_128469_("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.logger.warn("Exception at reading NBT");
            JSG.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it", e);
        }
        super.m_142466_(compound);
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.getTime());
        if (scheduledTask.getWaitTime() <= 0) {
            scheduledTask.execute();
            return;
        }
        this.scheduledTasks.add(scheduledTask);
        this.m_6596_();
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (this.f_58857_ == null) {
            return;
        }
        if (scheduledTask == ScheduledTaskType.STARGATE_HORIZON_LIGHT_BLOCK) {
            if (this.f_58857_.m_8055_(this.getGateCenterPos()).m_60795_()) {
                this.f_58857_.m_46597_(this.getGateCenterPos(), (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(15)));
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_LIGHTING_UPDATE_CLIENT) {
            this.f_58857_.m_151543_(this.getGateCenterPos());
        }
    }
}

