/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.Constants;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.block.stargate.IStargateBlock;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.IConfigurable;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.NearbyGate;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.StargateSizeEnum;
import dev.tauri.jsg.api.stargate.StargateUpgrade;
import dev.tauri.jsg.api.stargate.StargateWithIris;
import dev.tauri.jsg.api.stargate.dialhomedevice.StargateDHD;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.stargate.iris.codesender.CodeSender;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.result.StargateAddressCheckResult;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.IStargateGenerator;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.JSGItemStackHandler;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.blockentity.IUpgradable;
import dev.tauri.jsg.block.stargate.redstone.AbstractStargateRedstoneIO;
import dev.tauri.jsg.blockentity.IAddressProvider;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.capability.JSGCapabilities;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfigEntry;
import dev.tauri.jsg.helpers.FluidHelper;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.helpers.StargateTemperatureHelper;
import dev.tauri.jsg.item.energy.CapacitorItemBlock;
import dev.tauri.jsg.jub.JUBDevice;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.manager.StargateIrisManager;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.worldgen.generator.StargateGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class StargateClassicBaseBE<S extends StargateClassicRendererState>
extends StargateAbstractBaseBE<S, LargeEnergyStorage>
implements StargateWithIris<LargeEnergyStorage>,
ILinkable<DHDAbstractBE>,
IUpgradable,
IConfigurable,
IAddressProvider {
    protected final StargateIrisManager irisManager = new StargateIrisManager(this);
    protected BlockPos linkedDHD = null;
    protected double lastIrisHeat = -2.0;
    protected double lastGateHeat = -2.0;
    public double irisHeat;
    public double gateHeat;
    public static final double IRIS_MAX_HEAT_TITANIUM = JSGConfig.Stargate.irisTitaniumMaxHeat.get();
    public static final double IRIS_MAX_HEAT_TRINIUM = JSGConfig.Stargate.irisTriniumMaxHeat.get();
    public static final double GATE_MAX_HEAT = JSGConfig.Stargate.gateMaxHeat.get();
    protected StargateSizeEnum stargateSize = JSGConfig.Stargate.stargateSize.get();
    protected BlockPos lastPos = BlockPos.f_121853_;
    protected final BEConfig config;
    private short pageProgress;
    private int pageSlotId;
    private boolean doPageProgress;
    private ScheduledTask givePageTask;
    private boolean lockPage;
    public static final int BIOME_OVERRIDE_SLOT = 10;
    private final JSGItemStackHandler itemStackHandler;
    private static final List<Integer> UPGRADE_SLOTS_IDS = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 11));
    protected final LargeEnergyStorage energyStorage;
    public int currentPowerTier;
    protected ResourceKey<Level> lastFakeWorld;
    protected BlockPos lastFakePos;
    protected final List<BlockPos> REDSTONE_IO_BLOCKS;
    public JUBDevice jubDevice;

    public StargateClassicBaseBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        this.config = new BEConfig(() -> ((StargateClassicBaseBE)this).m_6596_(), this.getStargateType().configOptionsHolder.get());
        this.pageProgress = 0;
        this.itemStackHandler = new JSGItemStackHandler(12){

            public boolean isItemValid(int slot, ItemStack stack) {
                Item item = stack.m_41720_();
                boolean isItemCapacitor = item instanceof CapacitorItemBlock;
                switch (slot) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return StargateUpgrade.contains(item) && !StargateClassicBaseBE.this.hasUpgrade(item);
                    }
                    case 4: {
                        return isItemCapacitor && StargateClassicBaseBE.this.getSupportedCapacitors() >= 1;
                    }
                    case 5: {
                        return isItemCapacitor && StargateClassicBaseBE.this.getSupportedCapacitors() >= 2;
                    }
                    case 6: {
                        return isItemCapacitor && StargateClassicBaseBE.this.getSupportedCapacitors() >= 3;
                    }
                    case 7: 
                    case 8: {
                        return item == ItemRegistry.NOTEBOOK_PAGE_EMPTY.get() || item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get();
                    }
                    case 9: {
                        return item == ItemRegistry.NOTEBOOK_PAGE_EMPTY.get() || item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get() || item == ItemRegistry.UNIVERSE_DIALER.get();
                    }
                    case 10: {
                        BiomeOverlayRegistry.BiomeOverlayInstance override = BiomeOverlayRegistry.getBiomeOverlayByItem(stack, true);
                        return override != null && StargateClassicBaseBE.this.getSupportedOverlays().contains(override);
                    }
                    case 11: {
                        return StargateClassicBaseBE.this.getIrisManager().canInsertItemAsIris(item);
                    }
                }
                return true;
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (StargateClassicBaseBE.this.m_58904_() == null || StargateClassicBaseBE.this.m_58904_().m_5776_()) {
                    return;
                }
                switch (slot) {
                    case 4: 
                    case 5: 
                    case 6: {
                        StargateClassicBaseBE.this.updatePowerTier();
                        break;
                    }
                    case 10: {
                        StargateClassicBaseBE.this.sendState(StateType.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(StargateClassicBaseBE.this.determineBiomeOverride()));
                        break;
                    }
                    case 11: {
                        StargateClassicBaseBE.this.getIrisManager().updateIrisType();
                        break;
                    }
                }
                StargateClassicBaseBE.this.m_6596_();
            }
        };
        this.energyStorage = new LargeEnergyStorage(){

            @Override
            protected void onEnergyChanged() {
                StargateClassicBaseBE.this.m_6596_();
            }
        };
        this.currentPowerTier = 1;
        this.lastFakeWorld = null;
        this.lastFakePos = this.getFakePos();
        this.REDSTONE_IO_BLOCKS = new ArrayList<BlockPos>();
        this.jubDevice = new JUBDevice(this){

            @Override
            @Nullable
            public IEnergyStorage getEnergyStorage() {
                return StargateClassicBaseBE.this.getEnergyManager().getStorage();
            }

            @Override
            public void onChanged() {
                StargateClassicBaseBE.this.m_6596_();
            }

            @Override
            protected void packetReceived(String name, Object data, JUBDevice sender) {
                JSG.logger.info("Got packet {}!", (Object)name);
            }
        };
    }

    @Override
    public StargateIrisManager getIrisManager() {
        return this.irisManager;
    }

    @Override
    public StargateEventHorizonManager createEventHorizonManager() {
        return new StargateEventHorizonManager(this){

            @Override
            public JSGAxisAlignedBB getTeleportBox() {
                return StargateClassicBaseBE.this.getStargateSize().teleportBox;
            }

            @Override
            public boolean getForceUnstable() {
                return StargateClassicBaseBE.this.getConfig().getValueOrDefault(StargateConfigOptions.Classic.FORCE_UNSTABLE) != false || ((StargateAbstractDialingManager)StargateClassicBaseBE.this.getDialingManager()).getConnection().callConnected((conn, sg) -> {
                    if (sg instanceof StargateClassicBaseBE) {
                        StargateClassicBaseBE classicBaseBE = (StargateClassicBaseBE)sg;
                        return classicBaseBE.getConfig().getValueOrDefault(StargateConfigOptions.Classic.FORCE_UNSTABLE);
                    }
                    return false;
                }, () -> false) != false;
            }

            @Override
            public int getKawooshSegmentsCount() {
                return StargateClassicBaseBE.this.getStargateSize().horizonSegmentCount;
            }

            @Override
            public List<JSGAxisAlignedBB> getGateVaporizingBoxes() {
                return StargateClassicBaseBE.this.getStargateSize().gateVaporizingBoxes;
            }

            @Override
            protected JSGAxisAlignedBB getHorizonKillingBox() {
                return StargateClassicBaseBE.this.getStargateSize().killingBox;
            }

            @Override
            protected void kawooshDestruction() {
                if (!StargateClassicBaseBE.this.getIrisManager().isIrisClosed() || StargateClassicBaseBE.this.getIrisManager().getIrisType() == EnumIrisType.NULL) {
                    super.kawooshDestruction();
                }
            }
        };
    }

    protected abstract TagKey<Block> getLinkableTag();

    public void updateLinkStatus() {
        BlockEntity blockEntity;
        BlockPos closestDhd;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isLinked()) {
            Objects.requireNonNull(this.getLinkedDevice()).setLinkedDevice(null);
            this.setLinkedDevice(null);
        }
        if ((closestDhd = LinkingHelper.findClosestUnlinked(this.f_58857_, this.m_58899_(), LinkingHelper.getDhdRange(), this.getLinkableTag())) != null && (blockEntity = this.f_58857_.m_7702_(closestDhd)) instanceof DHDAbstractBE) {
            DHDAbstractBE dhd = (DHDAbstractBE)blockEntity;
            dhd.setLinkedDevice(this.m_58899_());
            this.setLinkedDevice(closestDhd);
            this.m_6596_();
        }
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDAbstractBE dhdTile = this.getLinkedDevice();
        if (dhdTile == null) {
            return false;
        }
        return dhdTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDevice(@Nullable BlockPos dhdPos) {
        this.linkedDHD = dhdPos;
        this.m_6596_();
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.sendLinkedDeviceToClients(this.m_58899_(), ((StargateAbstractStateManager)this.getStateManager()).getTargetPoint());
        }
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    @Nullable
    public DHDAbstractBE getLinkedDevice() {
        if (this.linkedDHD == null) {
            return null;
        }
        if (this.m_58904_() == null) {
            return null;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.linkedDHD);
        if (blockEntity instanceof DHDAbstractBE) {
            DHDAbstractBE dhd = (DHDAbstractBE)blockEntity;
            return dhd;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos getLinkedPos() {
        return this.linkedDHD;
    }

    @Override
    public int getMaxChevrons() {
        if (((StargateAbstractDialingManager)this.getDialingManager()).getStargateState().dialingComputer()) {
            return 9;
        }
        if (this.isLinkedAndDHDOperational()) {
            return this.getLinkedDevice() != null && !this.getLinkedDevice().hasUpgrade(StargateDHD.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
        }
        return 9;
    }

    @Override
    @Nullable
    public PointOfOrigin getPointOfOrigin(IPointOfOriginType pointOfOriginType) {
        ResourceLocation originRL = this.getConfig().wasValueChanged(StargateConfigOptions.Classic.POINT_OF_ORIGIN) ? this.getConfig().getValueOrDefault(StargateConfigOptions.Classic.POINT_OF_ORIGIN) : new ResourceLocation("empty");
        return Constants.JSG_POO_LOADER.getOriginByIdOrElse(pointOfOriginType, originRL, () -> Optional.ofNullable(this.m_58904_() == null ? null : Stargate.getOriginFor(pointOfOriginType, (ResourceKey<Level>)this.m_58904_().m_46472_(), this.getBiomeOverlayWithOverride(true))).orElse(super.getPointOfOrigin(pointOfOriginType)));
    }

    @Override
    public void initStargatePos() {
        StargatePos oldPos = this.stargatePos;
        if (this.m_58904_() == null) {
            return;
        }
        StargatePos gatePos = new StargatePos((ResourceKey<Level>)this.m_58904_().m_46472_(), Optional.ofNullable(this.getFakeWorld()).orElse((ResourceKey<Level>)this.m_58904_().m_46472_()), this.m_58899_(), this.getFakePos(), this.getSymbolType(), this.getStargateType());
        if (oldPos != null) {
            gatePos.setName(oldPos.getName());
        }
        this.stargatePos = gatePos;
        this.m_6596_();
    }

    public void tryHeatUp(boolean byIrisHit, double irisHeatUpCoefficient) {
        this.tryHeatUp(byIrisHit, false, 1.0, irisHeatUpCoefficient, 1.0, -1.0, -1.0);
    }

    public void tryHeatUp(double gateHeatUpCoefficient) {
        this.tryHeatUp(false, true, gateHeatUpCoefficient, 1.0, 1.0, -1.0, -1.0);
    }

    public double getMaxIrisHeat() {
        if (this.getIrisManager().hasShield() || this.getIrisManager().hasCreativeIris()) {
            return Double.MAX_VALUE;
        }
        return this.getIrisManager().getIrisType() == EnumIrisType.IRIS_TRINIUM ? IRIS_MAX_HEAT_TRINIUM : IRIS_MAX_HEAT_TITANIUM;
    }

    public double getMaxGateHeat() {
        return GATE_MAX_HEAT;
    }

    public void tryHeatUp(boolean heatUpIris, boolean heatUpGate, double gateHeatUpCoefficient, double irisHeatUpCoefficient, double coolDownCoefficient, double maxHeatByAround, double minHeatByAround) {
        double heatUpCoefficientConst = 0.7;
        double coolDownCoefficientConst = 0.3;
        if ((heatUpGate || Math.abs(this.gateHeat - this.irisHeat) >= 50.0) && (maxHeatByAround == -1.0 || this.gateHeat + 0.7 * gateHeatUpCoefficient <= maxHeatByAround)) {
            this.gateHeat += 0.7 * gateHeatUpCoefficient;
        }
        if (minHeatByAround == -1.0 || this.gateHeat - 0.3 * coolDownCoefficient > minHeatByAround) {
            this.gateHeat -= 0.3 * coolDownCoefficient;
        }
        if ((heatUpIris || Math.abs(this.gateHeat - this.irisHeat) >= 25.0) && (maxHeatByAround == -1.0 || this.irisHeat + 0.7 * irisHeatUpCoefficient <= maxHeatByAround)) {
            this.irisHeat += 0.7 * irisHeatUpCoefficient;
        }
        if (minHeatByAround == -1.0 || this.irisHeat - 0.3 * coolDownCoefficient > minHeatByAround) {
            this.irisHeat -= 0.3 * coolDownCoefficient;
        }
        ItemStack irisItem = this.getIrisManager().getIrisItem();
        double maxHeat = this.getMaxIrisHeat();
        if (this.irisHeat >= maxHeat) {
            int heatCoefficient = (int)Math.round(Math.abs(this.irisHeat - maxHeat));
            if (JSGConfig.Stargate.enableIrisOverHeatCollapse.get() && this.getTime() % (long)((int)(Math.random() * 70.0) + 1) == 0L && this.getIrisManager().hasPhysicalIris() && irisItem.m_41763_()) {
                irisItem.m_41720_().setDamage(irisItem, irisItem.m_41720_().getDamage(irisItem) + (new Random().nextInt(heatCoefficient) + 1));
                if (irisItem.m_41613_() == 0) {
                    this.getIrisManager().updateIrisType();
                }
                JSGSoundHelper.playSoundEvent(this.f_58857_, this.getGateCenterPos(), SoundEvent.IRIS_HIT);
            }
        }
        if (this.gateHeat >= GATE_MAX_HEAT) {
            if (this.f_58857_ == null) {
                return;
            }
            if (JSGConfig.Stargate.enableGateOverHeatExplosion.get()) {
                this.f_58857_.m_255391_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 60.0f, false, Level.ExplosionInteraction.BLOCK);
            }
        }
        if (this.getTime() % 20L == 0L && (this.lastIrisHeat != this.irisHeat || this.lastGateHeat != this.gateHeat)) {
            this.lastIrisHeat = this.irisHeat;
            this.lastGateHeat = this.gateHeat;
            this.m_6596_();
            this.sendState(StateType.RENDERER_UPDATE, new StargateRendererActionState(this.irisHeat, this.gateHeat));
        }
        this.m_6596_();
    }

    public double getTemperatureAroundGate() {
        return StargateTemperatureHelper.getTemperatureAroundGate(this);
    }

    public void setStargateSize(StargateSizeEnum size) {
        this.stargateSize = size;
    }

    public StargateSizeEnum getStargateSize() {
        return this.stargateSize;
    }

    @Override
    public boolean receiveIrisCode(CodeSender sender, String code) {
        return this.getIrisManager().receiveIrisCode(sender, code);
    }

    @Override
    public boolean isGateBurried() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.getConfig().getValueOrDefault(StargateConfigOptions.Classic.ENABLE_BURY_STATE).booleanValue()) {
            return false;
        }
        for (BlockPos targetPos : Objects.requireNonNull(StargateSizeEnum.getIrisBlocksPattern(this.getStargateSize()))) {
            BlockPos newPos = this.relative(targetPos);
            BlockState state = this.f_58857_.m_8055_(newPos);
            if (state.m_60734_() instanceof IStargateBlock) continue;
            if (state.m_60734_() instanceof LiquidBlock || FluidHelper.isLiquidBlock(state)) {
                return false;
            }
            if (state.m_60734_() instanceof AirBlock || state.m_60734_() == Blocks.f_152480_ || state.m_60734_() == BlockRegistry.IRIS_BLOCK.get() || state.m_60734_() == BlockRegistry.INVISIBLE_BLOCK.get()) {
                return false;
            }
            if (!state.m_247087_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        this.getIrisManager().onUnmerged();
        ((StargateSoundManager)this.getSoundManager()).updateRingRollSound(false);
        if (this.isLinked() && this.getLinkedDevice() != null) {
            this.getLinkedDevice().clearSymbols();
            this.getLinkedDevice().setLinkedDevice(null);
            this.setLinkedDevice(null);
        }
    }

    @Override
    public void onGateMerged() {
        double heat;
        super.onGateMerged();
        this.getIrisManager().updateIrisType();
        this.gateHeat = heat = this.getTemperatureAroundGate();
        this.irisHeat = heat;
        this.m_6596_();
        this.sendState(StateType.GUI_STATE, this.getState(StateType.GUI_STATE));
        this.updateLinkStatus();
    }

    @Override
    @Nullable
    public IAddress getAddress(AbstractSymbolType<?> symbolType) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return (IAddress)this.gateAddressMapClient.get(symbolType);
        }
        return this.getStargateAddress(symbolType);
    }

    @Override
    public void regenerateStargate(IStargateGenerator.PlacementConfig pConfig) {
        if (this.m_58904_() == null) {
            return;
        }
        Level world = this.m_58904_();
        if (world.f_46443_) {
            return;
        }
        JSG.logger.info("Regenerating stargate at {} in {}", (Object)this.m_58899_(), (Object)world.m_46472_().m_135782_());
        this.updateLinkStatus();
        pConfig.world = world;
        pConfig.gateBasePos = this.m_58899_();
        pConfig.stargateConfig = c -> this.getConfig();
        pConfig.gateFacing = this.mergeHelper.horizontalFacing;
        pConfig.gateVerticalFacing = this.mergeHelper.verticalFacing;
        pConfig.gateType = this.getStargateType();
        pConfig.overlay = this.getBiomeOverlayWithOverride(true);
        if (world.f_46441_.m_188501_() < 0.3f) {
            pConfig.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_TYPE);
        }
        if (this.isLinked()) {
            pConfig.dhdPos = this.getLinkedPos();
            if (world.f_46441_.m_188501_() < 0.3f) {
                pConfig.upgrades.add(IStargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_DHD);
            }
            pConfig.dhdFluid = (int)(((float)JSGConfig.DialHomeDevice.fluidCapacity.get() - (float)JSGConfig.DialHomeDevice.fluidCapacity.get() * 0.1f) * world.f_46441_.m_188501_() + (float)JSGConfig.DialHomeDevice.fluidCapacity.get() * 0.1f);
        }
        StargateGenerator generator = new StargateGenerator();
        generator.setStargateEnergyInternalSmart(pConfig, (int)((float)JSGConfig.Stargate.stargateEnergyStorage.get() * world.f_46441_.m_188501_()));
        generator.generateStargate(pConfig, false);
        this.generateAddresses(true);
        this.updateLinkStatus();
        this.m_6596_();
    }

    @Override
    public void onStargateLoaded() {
        if (this.m_58904_() == null) {
            return;
        }
        Level world = this.m_58904_();
        if (world.f_46443_) {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateType.GUI_STATE));
            this.requestLinkedDeviceFromServer(this.m_58899_());
        }
        super.onStargateLoaded();
        if (!world.f_46443_) {
            this.updatePowerTier();
            this.getIrisManager().onLoad();
            this.lastFakeWorld = this.getFakeWorld();
            this.lastFakePos = this.getFakePos();
            this.m_6596_();
        }
    }

    @Override
    public boolean isRIGAllowed() {
        return this.getConfig().getValueOrDefault(StargateConfigOptions.Classic.ALLOW_RIG);
    }

    @Override
    public void tick(Level level) {
        block22: {
            block23: {
                BlockPos topBlock;
                super.tick(level);
                this.updateDevices();
                if (this.lastFakeWorld == null) {
                    this.lastFakeWorld = this.getFakeWorld();
                }
                if (this.lastFakePos == null) {
                    this.lastFakePos = this.getFakePos();
                }
                if (level.f_46443_ && this.getConfig().getOptions().isEmpty()) {
                    JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateType.GUI_STATE));
                }
                this.getIrisManager().tick(level);
                if (!(level.f_46443_ || this.lastFakePos == this.getFakePos() && this.lastFakeWorld == this.getFakeWorld())) {
                    if (!((StargateAbstractDialingManager)this.getDialingManager()).getConnection().getStatus().none() && !((StargateAbstractDialingManager)this.getDialingManager()).getConnection().getStatus().full()) {
                        ((StargateAbstractDialingManager)this.getDialingManager()).abortDialingSequence();
                        this.lastFakePos = this.getFakePos();
                        this.lastFakeWorld = this.getFakeWorld();
                        this.m_6596_();
                    } else if (((StargateAbstractDialingManager)this.getDialingManager()).getConnection().getStatus().full()) {
                        JSG.logger.warn("A stargateState indicates the Gate at {} should be open, but gate was warped! Closing gate...", (Object)this.blockPosition().toString());
                        ((StargateAbstractDialingManager)this.getDialingManager()).attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                        this.lastFakePos = this.getFakePos();
                        this.lastFakeWorld = this.getFakeWorld();
                        this.m_6596_();
                    } else {
                        this.lastFakePos = this.getFakePos();
                        this.lastFakeWorld = this.getFakeWorld();
                        this.m_6596_();
                    }
                }
                if (!level.f_46443_ && this.isMerged() && (topBlock = this.getMergeHelper().getTopBlock()) != null && level.m_46470_() && level.m_46471_() && level.m_46758_(topBlock.m_7494_())) {
                    Random rand = new Random();
                    float chance = rand.nextFloat();
                    StargateDimensionConfigEntry entry = StargateDimensionConfig.INSTANCE.getConfigEntry((ResourceKey<Level>)level.m_46472_());
                    if (entry != null && (double)chance < entry.lightingBoltChance && BlockHelper.isBlockDirectlyUnderSky(level, topBlock)) {
                        int max = JSGConfig.Stargate.stargateEnergyStorage.get() / 17;
                        int min = max / 6;
                        int energy = (int)(rand.nextFloat() * (float)(max - min) + (float)min);
                        ((LargeEnergyStorage)((Object)this.getEnergyManager().getStorage())).receiveEnergy(energy, false);
                        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                        if (lightningbolt != null) {
                            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)topBlock));
                            level.m_7967_((Entity)lightningbolt);
                        }
                    }
                }
                if (!level.f_46443_ && this.isMerged() && level.m_46467_() % 20L == 0L) {
                    double middleTemperature = this.getTemperatureAroundGate();
                    double c = Math.min(1.0, Math.abs(this.gateHeat - middleTemperature) / 20.0);
                    this.tryHeatUp(false, true, c, c, c, middleTemperature, middleTemperature);
                    if (!this.getIrisManager().hasIris()) {
                        this.irisHeat = -1.0;
                        this.m_6596_();
                    }
                }
                if (level.f_46443_) break block22;
                if (!this.lastPos.equals((Object)this.m_58899_())) {
                    this.lastPos = this.m_58899_();
                    if (this.isMerged()) {
                        this.getMergeHelper().updateMemberStateAndCheck(null);
                    }
                }
                if (this.givePageTask != null && this.givePageTask.update(this.getTime())) {
                    this.givePageTask = null;
                }
                if (!this.doPageProgress) break block23;
                if (this.getTime() % 2L == 0L) {
                    this.pageProgress = (short)(this.pageProgress + 1);
                    if (this.pageProgress > 18) {
                        this.pageProgress = 0;
                        this.doPageProgress = false;
                    }
                }
                if (!this.itemStackHandler.getStackInSlot(this.pageSlotId).m_41619_()) break block22;
                this.lockPage = false;
                this.doPageProgress = false;
                this.pageProgress = 0;
                this.givePageTask = null;
                break block22;
            }
            if (this.lockPage && this.itemStackHandler.getStackInSlot(this.pageSlotId).m_41619_()) {
                this.lockPage = false;
            }
            if (!this.lockPage) {
                for (int i = 7; i < 10; ++i) {
                    if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
                    this.doPageProgress = true;
                    this.lockPage = true;
                    this.pageSlotId = i;
                    this.givePageTask = new ScheduledTask(ScheduledTaskType.STARGATE_GIVE_PAGE, 36);
                    this.givePageTask.setTaskCreated(this.getTime());
                    this.givePageTask.setExecutor(this);
                    break;
                }
            }
        }
        if (!this.lastPos.equals((Object)this.m_58899_())) {
            this.lastPos = this.m_58899_();
            this.updateLinkStatus();
            this.m_6596_();
        }
    }

    @Nullable
    private BiomeOverlayRegistry.BiomeOverlayInstance determineBiomeOverride() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(10);
        if (stack.m_41619_()) {
            return null;
        }
        BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay = BiomeOverlayRegistry.getBiomeOverlayByItem(stack);
        if (this.getSupportedOverlays().contains(biomeOverlay)) {
            return biomeOverlay;
        }
        return null;
    }

    @Override
    public BiomeOverlayRegistry.BiomeOverlayInstance getBiomeOverlayWithOverride(boolean override) {
        BiomeOverlayRegistry.BiomeOverlayInstance overlay = null;
        if (override) {
            overlay = this.determineBiomeOverride();
        }
        if (overlay == null) {
            return super.getBiomeOverlayWithOverride(override);
        }
        return overlay;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("irisManager", (Tag)this.irisManager.serializeNBT());
        if (this.isLinked(true)) {
            compound.m_128356_("linkedDHD", this.linkedDHD.m_121878_());
        }
        compound.m_128405_("stargateSize", this.stargateSize.id);
        compound.m_128365_("itemHandler", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128365_("config", (Tag)this.getConfig().serializeNBT());
        compound.m_128347_("irisHeat", this.irisHeat);
        compound.m_128347_("lastIrisHeat", this.lastIrisHeat);
        compound.m_128347_("gateHeat", this.gateHeat);
        compound.m_128347_("lastGateHeat", this.lastGateHeat);
        if (this.lastFakePos != null) {
            compound.m_128356_("lastFakePos", this.lastFakePos.m_121878_());
        }
        if (this.lastFakeWorld != null) {
            compound.m_128359_("lastFakeWorld", this.lastFakeWorld.m_135782_().toString());
        }
        compound.m_128405_("redstoneIODevice_size", this.REDSTONE_IO_BLOCKS.size());
        for (int i = 0; i < this.REDSTONE_IO_BLOCKS.size(); ++i) {
            compound.m_128356_("redstoneIODevice_pos" + i, this.REDSTONE_IO_BLOCKS.get(i).m_121878_());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.irisManager.deserializeNBT(compound.m_128469_("irisManager"));
        if (compound.m_128441_("linkedDHD")) {
            this.linkedDHD = BlockPos.m_122022_((long)compound.m_128454_("linkedDHD"));
        }
        if (compound.m_128441_("stargateSize")) {
            this.setStargateSize(StargateSizeEnum.fromId(compound.m_128451_("stargateSize")));
        } else {
            this.setStargateSize(JSGConfig.Stargate.stargateSize.get());
        }
        this.itemStackHandler.deserializeNBT(compound.m_128469_("itemHandler"));
        this.getConfig().deserializeNBT(compound.m_128469_("config"));
        this.irisHeat = compound.m_128459_("irisHeat");
        this.lastIrisHeat = compound.m_128459_("lastIrisHeat");
        this.gateHeat = compound.m_128459_("gateHeat");
        this.lastGateHeat = compound.m_128459_("lastGateHeat");
        if (compound.m_128441_("lastFakePos")) {
            this.lastFakePos = BlockPos.m_122022_((long)compound.m_128454_("lastFakePos"));
        }
        if (compound.m_128441_("lastFakeWorld")) {
            this.lastFakeWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("lastFakeWorld")));
        }
        int size = compound.m_128451_("redstoneIODevice_size");
        this.REDSTONE_IO_BLOCKS.clear();
        for (int i = 0; i < size; ++i) {
            this.REDSTONE_IO_BLOCKS.add(BlockPos.m_122022_((long)compound.m_128454_("redstoneIODevice_pos" + i)));
        }
        this.updatePowerTier();
    }

    @Override
    public BEConfig getConfig() {
        return this.config;
    }

    @Override
    public void onConfigUpdated() {
        this.m_6596_();
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.sendState(StateType.GUI_STATE, this.getState(StateType.GUI_STATE));
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.STARGATE_HORIZON_LIGHT_BLOCK) {
            StargateIrisManager iris = this.getIrisManager();
            if (iris.getIrisType() == EnumIrisType.NULL || iris.getIrisType() == EnumIrisType.SHIELD || !iris.isIrisClosed()) {
                super.executeTask(scheduledTask, customData);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_GIVE_PAGE) {
            int[] nArray;
            if (this.pageSlotId < 7) {
                return;
            }
            AbstractSymbolType<?> symbolType = AbstractSymbolType.byId(this.pageSlotId - 7);
            ItemStack stack = this.itemStackHandler.getStackInSlot(this.pageSlotId);
            if (this.hasUpgrade(StargateUpgrade.CHEVRON_UPGRADE)) {
                int[] nArray2 = new int[9];
                nArray2[0] = 1;
                nArray2[1] = 2;
                nArray2[2] = 3;
                nArray2[3] = 4;
                nArray2[4] = 5;
                nArray2[5] = 6;
                nArray2[6] = 7;
                nArray2[7] = 8;
                nArray = nArray2;
                nArray2[8] = 9;
            } else {
                int[] nArray3 = new int[7];
                nArray3[0] = 1;
                nArray3[1] = 2;
                nArray3[2] = 3;
                nArray3[3] = 4;
                nArray3[4] = 5;
                nArray3[5] = 6;
                nArray = nArray3;
                nArray3[6] = 9;
            }
            stack = this.getAddressPage(symbolType, stack, nArray);
            this.itemStackHandler.setStackInSlot(this.pageSlotId, stack);
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }

    public float getSpeedFactor() {
        return (float)this.getConfig().getValueOrDefault(StargateConfigOptions.Classic.SPIN_SPEED).intValue() / 100.0f;
    }

    @Override
    public int getPageProgress() {
        return this.pageProgress;
    }

    public void setPageProgress(int pageProgress) {
        this.pageProgress = (short)pageProgress;
    }

    @Override
    public void updateContainerItemsByItemStack(ItemStack stack) {
        super.updateContainerItemsByItemStack(stack);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("config")) {
            this.getConfig().deserializeNBT(tag.m_128469_("config"));
        }
        if (!tag.m_128441_("itemHandler")) {
            return;
        }
        this.itemStackHandler.deserializeNBT(tag.m_128469_("itemHandler"));
        this.updatePowerTier();
        this.getIrisManager().updateIrisType();
        this.sendState(StateType.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(this.determineBiomeOverride()));
        this.m_6596_();
    }

    @Override
    public ItemStack getDropBaseBlock(ServerPlayer player) {
        ItemStack stack = super.getDropBaseBlock(player);
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("itemHandler", (Tag)this.itemStackHandler.serializeNBT());
        tag.m_128365_("config", (Tag)this.getConfig().serializeNBT());
        stack.m_41751_(tag);
        return stack;
    }

    public int getSupportedCapacitors() {
        return this.getConfig().getValueOrDefault(StargateConfigOptions.Classic.MAX_CAPACITORS);
    }

    @Override
    public Iterator<Integer> getUpgradeSlotsIterator() {
        return UPGRADE_SLOTS_IDS.iterator();
    }

    @Override
    public StargateEnergyManager<?, LargeEnergyStorage> createEnergyManager() {
        return new StargateEnergyManager<StargateClassicBaseBE<S>, LargeEnergyStorage>(this){

            @Override
            public LargeEnergyStorage getStorage() {
                return StargateClassicBaseBE.this.energyStorage;
            }
        };
    }

    public int getPowerTier() {
        return this.currentPowerTier;
    }

    public void updatePowerTier() {
        int i;
        int powerTier = 1;
        for (i = 4; i < 7; ++i) {
            if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
            ++powerTier;
        }
        if (powerTier != this.currentPowerTier) {
            this.currentPowerTier = powerTier;
            this.energyStorage.clearStorages();
            for (i = 4; i < 7; ++i) {
                LazyOptional capCapability;
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.m_41619_() || !(capCapability = stack.getCapability(ForgeCapabilities.ENERGY, null)).isPresent() || !capCapability.resolve().isPresent()) continue;
                this.energyStorage.addStorage((IEnergyStorage)capCapability.resolve().get());
            }
            if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
                JSG.logger.debug("Updated to power tier: {}", (Object)powerTier);
            }
        }
    }

    @Override
    public <T> LazyOptional<T> getStargateCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemStackHandler).cast();
        }
        if (capability == JSGCapabilities.JUST_UNIVERSAL_BUS) {
            return LazyOptional.of(() -> this.jubDevice).cast();
        }
        return super.getStargateCapability(capability, facing);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.lastFakeWorld = this.getFakeWorld();
        this.lastFakePos = this.getFakePos();
        this.m_6596_();
    }

    @Nullable
    public ResourceKey<Level> getFakeWorld() {
        if (this.m_58904_() == null) {
            return null;
        }
        return this.m_58904_().m_46472_();
    }

    public void setFakeWorld(Level world) {
    }

    public BlockPos getFakePos() {
        return this.m_58899_();
    }

    public void setFakePos(@Nullable BlockPos pos) {
    }

    public ArrayList<NearbyGate> getNearbyGates() {
        return this.getNearbyGates(null, true, true);
    }

    public ArrayList<NearbyGate> getNearbyGates(@Nullable StargateType gateType, boolean checkStargateType, boolean checkAddressAndEnergy) {
        if (gateType == null) {
            gateType = this.getStargateType();
        }
        double squaredGate = (double)JSGConfig.Stargate.universeGateNearbyReach.get() * (double)JSGConfig.Stargate.universeGateNearbyReach.get();
        ArrayList<NearbyGate> addresses = new ArrayList<NearbyGate>();
        Level level = this.m_58904_();
        if (level == null) {
            return addresses;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return addresses;
        }
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> entry : StargateNetwork.INSTANCE.getAll().entrySet()) {
            StargatePos stargatePos = entry.getKey();
            StargateType type = stargatePos.getStargateType();
            if (!type.isClassic || checkStargateType && gateType != type) continue;
            ResourceKey<Level> targetDim = stargatePos.fakeGateDimension;
            BlockPos targetFoundPos = stargatePos.fakeGatePos;
            if (targetDim != this.getFakeWorld() || targetFoundPos.m_123331_((Vec3i)this.getFakePos()) > squaredGate || stargatePos.gatePos.equals((Object)this.m_58899_()) && stargatePos.dimension == level.m_46472_()) continue;
            int symbolsNeeded = ((StargateAbstractDialingManager)this.getDialingManager()).getMinimalSymbolsToDial(stargatePos.getGateSymbolType(), stargatePos);
            if (checkAddressAndEnergy) {
                StargateAddressDynamic checkingAddress = new StargateAddressDynamic(this.getSymbolType());
                checkingAddress.addAll(entry.getValue().get(this.getSymbolType()).subList(0, symbolsNeeded - 1));
                checkingAddress.addSymbol((SymbolInterface)stargatePos.getGateSymbolType().getOrigin());
                if (((StargateAbstractDialingManager)this.getDialingManager()).checkAddressAndEnergyRequirements(checkingAddress, false) != StargateAddressCheckResult.OK) continue;
                addresses.add(new NearbyGate(entry.getValue().get(this.getSymbolType()), symbolsNeeded, stargatePos.getStargateType()));
                continue;
            }
            addresses.add(new NearbyGate(entry.getValue().get(this.getSymbolType()), symbolsNeeded, stargatePos.getStargateType()));
        }
        return addresses;
    }

    public void addRedstoneDevice(BlockPos pos) {
        this.REDSTONE_IO_BLOCKS.add(pos);
        this.m_6596_();
    }

    public void removeRedstoneDevice(BlockPos pos) {
        this.REDSTONE_IO_BLOCKS.remove(pos);
        this.m_6596_();
    }

    public void updateDevices() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        for (BlockPos pos : this.REDSTONE_IO_BLOCKS) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof AbstractStargateRedstoneIO)) continue;
            AbstractStargateRedstoneIO ioBlock = (AbstractStargateRedstoneIO)block;
            ioBlock.tickFromStargate(state, level, pos, this);
        }
    }

    @Override
    public String getDeviceType() {
        return "STARGATE_CLASSIC";
    }
}

