/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.multistructure.mergehelper.StargateMilkyWayMergeHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRendererState;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateMilkyWayDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.manager.state.StargateMilkyWayStateManager;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StargateMilkyWayBaseBE
extends StargateClassicBaseBE<StargateMilkyWayRendererState>
implements ILinkable<DHDAbstractBE> {
    public static final List<BiomeOverlayRegistry.BiomeOverlayInstance> SUPPORTED_OVERLAYS = List.of(BiomeOverlayRegistry.NORMAL, BiomeOverlayRegistry.FROST, BiomeOverlayRegistry.MOSSY, BiomeOverlayRegistry.AGED, BiomeOverlayRegistry.SOOTY);

    public StargateMilkyWayBaseBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public StargateMilkyWayBaseBE(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.STARGATE_MILKYWAY_BASE_BE.get(), pos, state);
    }

    @Override
    public StargateAbstractStateManager<StargateMilkyWayBaseBE, StargateMilkyWayRendererState> createStateManager() {
        return new StargateMilkyWayStateManager(this);
    }

    @Override
    public StargateAbstractDialingManager<?> createDialingManager() {
        return new StargateMilkyWayDialingManager(this);
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateMilkyWayMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.m_58900_().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.m_58900_().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    protected TagKey<Block> getLinkableTag() {
        return JSGBlockTags.STARGATE_MILKYWAY_LINKABLE_BLOCKS;
    }

    @Override
    public AbstractSymbolType<?> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public StargateType getStargateType() {
        return StargateTypes.MILKYWAY;
    }

    @Override
    public PositionedSound getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> PositionedSound.MILKYWAY_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> PositionedSound.MILKYWAY_RING_ROLL_START;
        };
    }

    @Override
    @Nullable
    public SoundEvent getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEvent.GATE_MILKYWAY_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEvent.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEvent.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> {
                if (((StargateAbstractDialingManager)this.getDialingManager()).getStargateState().dialingComputer()) {
                    yield SoundEvent.GATE_MILKYWAY_DIAL_FAILED_COMPUTER;
                }
                yield SoundEvent.GATE_MILKYWAY_DIAL_FAILED;
            }
            case StargateSoundEventEnum.INCOMING -> SoundEvent.GATE_MILKYWAY_INCOMING;
            case StargateSoundEventEnum.CHEVRON_OPEN -> SoundEvent.GATE_MILKYWAY_CHEVRON_OPEN;
            case StargateSoundEventEnum.CHEVRON_SHUT, StargateSoundEventEnum.RING_STOP -> SoundEvent.GATE_MILKYWAY_CHEVRON_SHUT;
            default -> null;
        };
    }

    @Override
    public float getSoundEventPitch(StargateSoundEventEnum soundEvent) {
        if (soundEvent == StargateSoundEventEnum.CHEVRON_OPEN) {
            return 0.95f + 0.05f * (this.m_58904_() != null ? this.m_58904_().f_46441_.m_188501_() : 0.0f);
        }
        return super.getSoundEventPitch(soundEvent);
    }

    @Override
    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }
}

