/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ILinkable;
import dev.tauri.jsg.multistructure.mergehelper.StargatePegasusMergeHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.renderer.stargate.StargatePegasusRendererState;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargatePegasusDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.manager.state.StargatePegasusStateManager;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StargatePegasusBaseBE
extends StargateClassicBaseBE<StargatePegasusRendererState>
implements ILinkable<DHDAbstractBE> {
    public static final List<BiomeOverlayRegistry.BiomeOverlayInstance> SUPPORTED_OVERLAYS = List.of(BiomeOverlayRegistry.NORMAL, BiomeOverlayRegistry.FROST, BiomeOverlayRegistry.MOSSY, BiomeOverlayRegistry.AGED, BiomeOverlayRegistry.SOOTY);

    public StargatePegasusBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_PEGASUS_BASE_BE.get(), pos, state);
    }

    @Override
    public StargateAbstractStateManager<StargatePegasusBaseBE, StargatePegasusRendererState> createStateManager() {
        return new StargatePegasusStateManager(this);
    }

    @Override
    public StargateAbstractDialingManager<StargatePegasusBaseBE> createDialingManager() {
        return new StargatePegasusDialingManager(this);
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargatePegasusMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.m_58900_().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.m_58900_().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    public AbstractSymbolType<?> getSymbolType() {
        return SymbolTypeRegistry.PEGASUS;
    }

    @Override
    public StargateType getStargateType() {
        return StargateTypes.PEGASUS;
    }

    @Override
    public PositionedSound getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> PositionedSound.PEGASUS_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> PositionedSound.PEGASUS_RING_ROLL_START;
        };
    }

    @Override
    @Nullable
    public SoundEvent getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEvent.GATE_PEGASUS_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEvent.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEvent.GATE_MILKYWAY_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> SoundEvent.GATE_PEGASUS_DIAL_FAILED;
            case StargateSoundEventEnum.INCOMING -> SoundEvent.GATE_PEGASUS_INCOMING;
            case StargateSoundEventEnum.RING_STOP, StargateSoundEventEnum.CHEVRON_OPEN, StargateSoundEventEnum.CHEVRON_SHUT -> SoundEvent.GATE_PEGASUS_CHEVRON_OPEN;
            default -> null;
        };
    }

    @Override
    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected TagKey<Block> getLinkableTag() {
        return JSGBlockTags.STARGATE_PEGASUS_LINKABLE_BLOCKS;
    }
}

