/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.helper.DimensionsHelper;
import dev.tauri.jsg.api.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.NearbyGate;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolUniverseEnum;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.multistructure.mergehelper.StargateUniverseMergeHelper;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.renderer.stargate.StargateUniverseRendererState;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateUniverseDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.manager.state.StargateUniverseStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StargateUniverseBaseBE
extends StargateClassicBaseBE<StargateUniverseRendererState> {
    protected ResourceKey<Level> fakeWorld;
    protected BlockPos fakePos;
    private static final List<BiomeOverlayRegistry.BiomeOverlayInstance> SUPPORTED_OVERLAYS = List.of(BiomeOverlayRegistry.NORMAL, BiomeOverlayRegistry.FROST, BiomeOverlayRegistry.MOSSY, BiomeOverlayRegistry.AGED);

    public StargateUniverseBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_UNIVERSE_BASE_BE.get(), pos, state);
    }

    @Override
    public StargateEnergyManager<?, LargeEnergyStorage> createEnergyManager() {
        return new StargateEnergyManager<StargateUniverseBaseBE, LargeEnergyStorage>(this){

            @Override
            public LargeEnergyStorage getStorage() {
                return StargateUniverseBaseBE.this.energyStorage;
            }

            @Override
            public EnergyRequiredToOperate getEnergyRequiredToDial(@Nullable StargatePos targetGatePos, StargateAddressDynamic address) {
                return super.getEnergyRequiredToDial(targetGatePos, address).mul(JSGConfig.Stargate.stargateUniverseEnergyMul.get());
            }

            @Override
            protected Level getLevel() {
                return (Level)Optional.ofNullable(DimensionsHelper.getLevel(((StargateUniverseBaseBE)this.stargate).getFakeWorld())).orElse((ServerLevel)super.getLevel());
            }

            @Override
            protected BlockPos getBlockPos() {
                return ((StargateUniverseBaseBE)this.stargate).getFakePos();
            }
        };
    }

    @Override
    public StargateAbstractStateManager<?, StargateUniverseRendererState> createStateManager() {
        return new StargateUniverseStateManager(this);
    }

    @Override
    public StargateAbstractDialingManager<?> createDialingManager() {
        return new StargateUniverseDialingManager(this);
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateUniverseMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.m_58900_().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.m_58900_().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    protected TagKey<Block> getLinkableTag() {
        return JSGBlockTags.STARGATE_UNIVERSE_LINKABLE_BLOCKS;
    }

    @Override
    @Nullable
    public ResourceKey<Level> getFakeWorld() {
        if (this.fakeWorld == null) {
            if (this.f_58857_ == null) {
                return null;
            }
            return this.f_58857_.m_46472_();
        }
        return this.fakeWorld;
    }

    @Override
    public void setFakeWorld(Level world) {
        this.fakeWorld = world.m_46472_();
        this.m_6596_();
    }

    @Override
    public BlockPos getFakePos() {
        if (this.fakePos == null) {
            return this.m_58899_();
        }
        return this.fakePos;
    }

    @Override
    public void setFakePos(@Nullable BlockPos pos) {
        this.fakePos = pos;
        this.m_6596_();
    }

    public void resetFakePos() {
        this.fakePos = this.m_58899_();
        this.fakeWorld = this.f_58857_ == null ? null : this.f_58857_.m_46472_();
        this.m_6596_();
    }

    @Override
    public AbstractSymbolType<?> getSymbolType() {
        return SymbolTypeRegistry.UNIVERSE;
    }

    @Override
    public StargateType getStargateType() {
        return StargateTypes.UNIVERSE;
    }

    @Override
    public int getOpenSoundDelay() {
        return super.getOpenSoundDelay() + 10;
    }

    @Override
    public int getSupportedCapacitors() {
        return this.getConfig().getValueOrDefault(StargateConfigOptions.Universe.MAX_CAPACITORS);
    }

    @Override
    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    @Nullable
    public PositionedSound getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> PositionedSound.UNIVERSE_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> PositionedSound.UNIVERSE_RING_ROLL_START;
        };
    }

    @Override
    public void playSoundEvent(StargateSoundEventEnum soundEnum) {
        if (soundEnum == StargateSoundEventEnum.CHEVRON_OPEN) {
            return;
        }
        super.playSoundEvent(soundEnum);
    }

    @Override
    @Nullable
    public SoundEvent getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEvent.GATE_UNIVERSE_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEvent.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEvent.GATE_UNIVERSE_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> SoundEvent.GATE_UNIVERSE_DIAL_FAILED;
            case StargateSoundEventEnum.INCOMING -> SoundEvent.GATE_UNIVERSE_DIAL_START;
            case StargateSoundEventEnum.RING_STOP -> {
                if (((StargateAbstractDialingManager)this.getDialingManager()).getSpinHelper().getCurrentTopSymbol() == SymbolUniverseEnum.TOP_CHEVRON) {
                    yield SoundEvent.GATE_UNIVERSE_CHEVRON_TOP_LOCK;
                }
                yield SoundEvent.GATE_UNIVERSE_CHEVRON_LOCK;
            }
            case StargateSoundEventEnum.CHEVRON_SHUT -> SoundEvent.GATE_UNIVERSE_CHEVRON_LOCK;
            default -> null;
        };
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        if (this.fakePos != null) {
            compound.m_128405_("fakeX", this.fakePos.m_123341_());
            compound.m_128405_("fakeY", this.fakePos.m_123342_());
            compound.m_128405_("fakeZ", this.fakePos.m_123342_());
        }
        if (this.fakeWorld != null) {
            compound.m_128359_("fakeWorld", this.fakeWorld.m_135782_().toString());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("fakeX")) {
            this.fakePos = new BlockPos(compound.m_128451_("fakeX"), compound.m_128451_("fakeY"), compound.m_128451_("fakeZ"));
        }
        if (compound.m_128441_("fakeWorld") && this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.fakeWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("fakeWorld")));
        }
    }

    public NearbyGate getRandomNearbyGate() {
        ArrayList<NearbyGate> addresses = this.getNearbyGates();
        if (addresses.isEmpty()) {
            return null;
        }
        int i = (int)Math.min(Math.floor(Math.random() * (double)addresses.size()), (double)(addresses.size() - 1));
        if (i < 0) {
            i = 0;
        }
        return addresses.get(i);
    }
}

