/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.stargate;

import com.google.common.reflect.TypeToken;
import dev.tauri.jsg.Constants;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.config.AbstractJSONConfig;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginsLoader;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.config.stargate.StargateDimensionConfigEntry;
import dev.tauri.jsg.registry.DimensionRegistry;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class StargateDimensionConfig
extends AbstractJSONConfig<StargateDimensionConfigEntry> {
    private static final Map<String, StargateDimensionConfigEntry> DEFAULTS_MAP = new HashMap<String, StargateDimensionConfigEntry>();
    public static final StargateDimensionConfig INSTANCE;

    public StargateDimensionConfig() {
        super("jsgDimensions_3.0", DEFAULTS_MAP.values());
    }

    @Override
    public Type getJSONType() {
        return new TypeToken<Map<String, StargateDimensionConfigEntry>>(){}.getType();
    }

    protected Pair<StargateDimensionConfigEntry, StargateDimensionConfigEntry> getPairedEntries(ResourceLocation fromDimId, ResourceLocation toDimId) {
        StargateDimensionConfigEntry eFrom = (StargateDimensionConfigEntry)this.configEntries.get(fromDimId.toString());
        StargateDimensionConfigEntry eTo = (StargateDimensionConfigEntry)this.configEntries.get(toDimId.toString());
        if (eFrom == null || eTo == null) {
            JSG.logger.error("Tried to get non-existing dimension. This is a bug.");
            JSG.logger.error("FromId: {}, ToId: {}, FromEntryNull: {}, ToEntryNull: {}", fromDimId, toDimId, eFrom == null, eTo == null);
            JSG.logger.error("JSG dimension entries:{}{}", (Object)System.lineSeparator(), (Object)this.configEntries.entrySet().stream().map(en -> (String)en.getKey() + " | " + ((StargateDimensionConfigEntry)en.getValue()).toString()).collect(Collectors.joining(System.lineSeparator())));
            JSG.logger.error("Stack trace:", new IllegalArgumentException());
            return null;
        }
        return Pair.of((Object)eFrom, (Object)eTo);
    }

    public EnergyRequiredToOperate getCost(@Nullable ResourceKey<Level> fromDimId, @Nullable ResourceKey<Level> toDimId) {
        if (toDimId == null || fromDimId == null) {
            return EnergyRequiredToOperate.free();
        }
        Pair<StargateDimensionConfigEntry, StargateDimensionConfigEntry> fromTo = this.getPairedEntries(fromDimId.m_135782_(), toDimId.m_135782_());
        if (fromTo == null) {
            return EnergyRequiredToOperate.free();
        }
        EnergyRequiredToOperate energyRequired = EnergyRequiredToOperate.stargate();
        double dist = Math.abs(((StargateDimensionConfigEntry)fromTo.first()).distance - ((StargateDimensionConfigEntry)fromTo.second()).distance);
        return energyRequired.mul(dist);
    }

    public boolean isGroupEqual(ResourceKey<Level> fromDim, ResourceKey<Level> toDim) {
        return this.isGroupEqual(fromDim.m_135782_(), toDim.m_135782_());
    }

    public boolean isGroupEqual(ResourceLocation fromDimId, ResourceLocation toDimId) {
        Pair<StargateDimensionConfigEntry, StargateDimensionConfigEntry> fromTo = this.getPairedEntries(fromDimId, toDimId);
        if (fromTo == null) {
            return false;
        }
        return ((StargateDimensionConfigEntry)fromTo.first()).isGroupEqual((StargateDimensionConfigEntry)fromTo.second());
    }

    @Nullable
    public StargateDimensionConfigEntry getConfigEntry(ResourceKey<Level> dim) {
        if (dim == null) {
            return null;
        }
        if (this.configEntries.isEmpty()) {
            try {
                this.reload(null);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.configEntries.isEmpty()) {
            return null;
        }
        return (StargateDimensionConfigEntry)this.getConfigEntry(dim.m_135782_().toString());
    }

    public Optional<StargateDimensionConfigEntry> getConfigEntrySafe(ResourceKey<Level> dim) {
        return Optional.ofNullable(this.getConfigEntry(dim));
    }

    @Nullable
    public PointOfOrigin getOrigin(IPointOfOriginType type, ResourceKey<Level> dim, @Nullable BiomeOverlayRegistry.BiomeOverlayInstance overlay) {
        StargateDimensionConfigEntry entry;
        if (overlay == null) {
            overlay = BiomeOverlayRegistry.NORMAL;
        }
        if ((entry = this.getConfigEntry(dim)) == null) {
            return null;
        }
        if (!entry.origins.containsKey(type.getPoONamespaceIdentifier())) {
            return null;
        }
        Map<String, String> typeMap = entry.origins.get(type.getPoONamespaceIdentifier());
        if (!typeMap.containsKey(overlay.id.toString())) {
            return null;
        }
        return Constants.JSG_POO_LOADER.getOriginByIdOrElse(type, new ResourceLocation(typeMap.get(overlay.id.toString())), () -> null);
    }

    @Override
    protected void update(@Nullable MinecraftServer server) throws IOException {
        if (server != null) {
            for (ResourceKey location : server.m_129784_()) {
                if (this.configEntries.containsKey(location.m_135782_().toString())) continue;
                this.shouldWriteToFile = true;
                String name = location.m_135782_().toString();
                if (DEFAULTS_MAP.containsKey(name)) {
                    this.configEntries.put(location.m_135782_().toString(), DEFAULTS_MAP.get(name));
                    continue;
                }
                this.configEntries.put(location.m_135782_().toString(), new StargateDimensionConfigEntry(name, true, (int)(5.0 + 10.0 * Math.random()), null));
            }
        }
        super.update(server);
    }

    static {
        DEFAULTS_MAP.put("minecraft:overworld", new StargateDimensionConfigEntry("minecraft:overworld", true, 0, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, (Map)Util.m_137469_(new HashMap(), map -> map.put(StargateTypes.MILKYWAY.getPoONamespaceIdentifier(), (Map)Util.m_137469_(new HashMap(), mwMap -> {
            mwMap.put(BiomeOverlayRegistry.NORMAL.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.TAURI.toString());
            mwMap.put(BiomeOverlayRegistry.FROST.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.ANTARCTICA.toString());
        })))));
        DEFAULTS_MAP.put("minecraft:the_nether", new StargateDimensionConfigEntry("minecraft:the_nether", true, 5, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, (Map)Util.m_137469_(new HashMap(), map -> map.put(StargateTypes.MILKYWAY.getPoONamespaceIdentifier(), (Map)Util.m_137469_(new HashMap(), mwMap -> {
            mwMap.put(BiomeOverlayRegistry.SOOTY.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.NETHER.toString());
            mwMap.put(BiomeOverlayRegistry.NORMAL.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.NETHER.toString());
            mwMap.put(BiomeOverlayRegistry.AGED.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.NETHER.toString());
        }))), 0.0, false));
        DEFAULTS_MAP.put("minecraft:the_end", new StargateDimensionConfigEntry("minecraft:the_end", true, 10, new ArrayList<String>(), (Map)Util.m_137469_(new HashMap(), map -> map.put(StargateTypes.MILKYWAY.getPoONamespaceIdentifier(), (Map)Util.m_137469_(new HashMap(), mwMap -> mwMap.put(BiomeOverlayRegistry.NORMAL.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.P7J_989.toString())))), 0.0, false));
        DEFAULTS_MAP.put(DimensionRegistry.ABYDOS.m_135782_().toString(), new StargateDimensionConfigEntry(DimensionRegistry.ABYDOS.m_135782_().toString(), true, 13, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, (Map)Util.m_137469_(new HashMap(), map -> map.put(StargateTypes.MILKYWAY.getPoONamespaceIdentifier(), (Map)Util.m_137469_(new HashMap(), mwMap -> {
            mwMap.put(BiomeOverlayRegistry.NORMAL.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.ABYDOS.toString());
            mwMap.put(BiomeOverlayRegistry.AGED.id.toString(), IPointOfOriginsLoader.Defaults.MilkyWay.ABYDOS.toString());
        }))), 2.0E-4f, false));
        DEFAULTS_MAP.put("ad_astra:moon", new StargateDimensionConfigEntry("ad_astra:moon", false, 3, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, 0.0, false));
        INSTANCE = new StargateDimensionConfig();
    }
}

