/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.datagen;

import dev.tauri.jsg.datagen.JSGBlockStateProvider;
import dev.tauri.jsg.datagen.JSGItemModelProvider;
import dev.tauri.jsg.datagen.JSGRecipeProvider;
import dev.tauri.jsg.datagen.loot.JSGLootTableProvider;
import dev.tauri.jsg.datagen.tag.JSGBiomeTagGenerator;
import dev.tauri.jsg.datagen.tag.JSGBlockTagGenerator;
import dev.tauri.jsg.datagen.tag.JSGFluidTagGenerator;
import dev.tauri.jsg.datagen.tag.JSGItemTagGenerator;
import dev.tauri.jsg.datagen.tag.JSGStructureTagGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class JSGDataGenerators {
    @SubscribeEvent
    public static void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new JSGRecipeProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)JSGLootTableProvider.create(output));
        generator.addProvider(event.includeClient(), (DataProvider)new JSGBlockStateProvider(output, exFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new JSGItemModelProvider(output, exFileHelper));
        JSGBlockTagGenerator blockTagGenerator = (JSGBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new JSGBlockTagGenerator(output, lookupProvider, exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new JSGItemTagGenerator(output, lookupProvider, blockTagGenerator.m_274426_(), exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new JSGBiomeTagGenerator(output, lookupProvider, exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new JSGFluidTagGenerator(output, lookupProvider, exFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new JSGStructureTagGenerator(output, lookupProvider, exFileHelper));
    }
}

