/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.datagen;

import dev.tauri.jsg.datagen.JSGBlockStateProvider;
import dev.tauri.jsg.model.JSGOBJModelLoaderBuilder;
import dev.tauri.jsg.registry.BlockRegistry;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class JSGItemModelProvider
extends ItemModelProvider {
    public static final ItemDisplayContext[] DEFAULT_RENDER_TYPES = new ItemDisplayContext[]{ItemDisplayContext.THIRD_PERSON_LEFT_HAND, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, ItemDisplayContext.HEAD, ItemDisplayContext.GROUND, ItemDisplayContext.FIXED, ItemDisplayContext.GUI};

    public JSGItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "jsg", existingFileHelper);
    }

    protected void registerModels() {
        BlockRegistry.CARTOUCHES.forEach((block, types) -> types.forEach((type, blockRegObj) -> this.blockOBJModel((RegistryObject<Block>)blockRegObj, DEFAULT_RENDER_TYPES)));
        ResourceLocation sandstoneRL = JSGBlockStateProvider.getRL((Block)BlockRegistry.STATIC_SMOOTH_SANDSTONE.get());
        ((ItemModelBuilder)this.getBuilder(sandstoneRL.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(new ResourceLocation("block/" + JSGBlockStateProvider.getRL(Blocks.f_50471_).m_135815_()), this.existingFileHelper));
    }

    private void blockOBJModel(RegistryObject<Block> block, ItemDisplayContext ... renderTypes) {
        this.itemOBJModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get()))), renderTypes);
    }

    private void itemOBJModel(RegistryObject<Item> item, ItemDisplayContext ... renderTypes) {
        this.itemOBJModel(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)item.get()))), renderTypes);
    }

    private void itemOBJModel(ResourceLocation item, ItemDisplayContext ... renderTypes) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation("jsg", "block/wip"))).customLoader((parent, existingFileHelper) -> new JSGOBJModelLoaderBuilder<ItemModelBuilder>((ItemModelBuilder)parent, (ExistingFileHelper)existingFileHelper).renderTypes(renderTypes));
    }
}

