/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.effect;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.helper.JSGMinecraftHelper;
import dev.tauri.jsg.api.sound.client.JSGSoundHelperClient;
import dev.tauri.jsg.effect.StargateWormholeType;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.sound.PositionedSound;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class StargateWormholeEffect {
    public static long playingStarted = -1L;
    public static long playingWhiteStarted = -1L;
    public static boolean isPlaying = false;
    public static boolean isStopping = false;
    public static boolean isPlayingWhite = false;
    public static float lastSpeed = -1.0f;
    public static boolean isFlying = false;
    public static StargateWormholeType type = StargateWormholeType.MILKYWAY;
    public static int length;
    private static BlockPos travelSoundPos;

    public static void play(StargateWormholeType type, int length) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        StargateWormholeEffect.type = type;
        StargateWormholeEffect.length = length;
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        isFlying = p.m_150110_().f_35935_;
        lastSpeed = p.m_150110_().m_35942_();
        p.m_150110_().m_35943_(0.0f);
        playingStarted = JSGMinecraftHelper.getPlayerTickClientSide();
        Vec3 v = p.m_20182_();
        travelSoundPos = new BlockPos((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_);
        JSGSoundHelperClient.playPositionedSoundClientSide(travelSoundPos, PositionedSound.WORMHOLE_TRAVEL, true);
        isPlaying = true;
        isPlayingWhite = true;
        isStopping = false;
        playingWhiteStarted = playingStarted;
    }

    public static void stop() {
        isStopping = true;
        playingStarted = -1L;
        playingWhiteStarted = JSGMinecraftHelper.getPlayerTickClientSide();
        isPlaying = false;
        isPlayingWhite = true;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (lastSpeed > -1.0f) {
            p.m_150110_().m_35943_(lastSpeed);
        }
        p.m_150110_().f_35935_ = isFlying;
        p.m_6885_();
        Vec3 v = p.m_20182_();
        JSGSoundHelperClient.playPositionedSoundClientSide(travelSoundPos, PositionedSound.WORMHOLE_TRAVEL, false);
        JSGSoundHelperClient.playSoundEventClientSide(new BlockPos((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_), dev.tauri.jsg.sound.SoundEvent.WORMHOLE_GO, 1.0f, 1.0f);
    }

    public static int getCurrentAnimationState() {
        int startFrameOffset;
        if (playingStarted == -1L) {
            return 0;
        }
        int tick = (int)(JSGMinecraftHelper.getPlayerTickClientSide() - playingStarted);
        int l = length * 20;
        int framesCount = StargateWormholeEffect.type.endFrame - StargateWormholeEffect.type.startFrame;
        for (startFrameOffset = framesCount - l; startFrameOffset < 0; startFrameOffset += framesCount) {
        }
        int frameOffset = (startFrameOffset + tick) % framesCount;
        int frame = StargateWormholeEffect.type.startFrame + frameOffset;
        if (tick > l) {
            StargateWormholeEffect.stop();
        }
        return Math.min(frame, StargateWormholeEffect.type.endFrame);
    }

    @SubscribeEvent
    public static void onMouseWheel(InputEvent.MouseScrollingEvent event) {
        if (isPlaying) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (isPlaying) {
            InputConstants.Key key = InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode());
            KeyMapping.m_90837_((InputConstants.Key)key, (boolean)false);
        }
    }

    @SubscribeEvent
    public static void onSoundPlay(PlaySoundEvent event) {
        if (!isPlaying) {
            return;
        }
        if (event.getOriginalSound().m_7904_() == ((SoundEvent)PositionedSound.WORMHOLE_TRAVEL.event.get()).m_11660_()) {
            return;
        }
        event.setSound(null);
    }

    public static void render(ForgeGui forgeGui, GuiGraphics graphics, float partialTicks, int packedLight, int packedOverlay) {
        if (!isPlayingWhite && !isPlaying) {
            return;
        }
        PoseStack stack = graphics.m_280168_();
        GuiHelper.currentStack = graphics.m_280168_();
        RenderSystem.enableBlend();
        stack.m_85836_();
        stack.m_252880_(0.0f, 0.0f, 100.0f);
        float whiteCoef = StargateWormholeEffect.getWhiteCoef();
        if (isPlaying && (!isPlayingWhite || whiteCoef >= 0.29289f)) {
            StargateWormholeEffect.renderWormholeFrame(graphics, StargateWormholeEffect.getCurrentAnimationState());
        }
        if (isStopping && isPlayingWhite && whiteCoef <= 0.29289f) {
            StargateWormholeEffect.renderWormholeFrame(graphics, StargateWormholeEffect.type.endFrame);
        }
        if (isPlayingWhite) {
            StargateWormholeEffect.renderWhiteFlash(graphics, StargateWormholeEffect.getWhiteAlpha(whiteCoef));
        }
        stack.m_85849_();
    }

    private static void renderWormholeFrame(GuiGraphics graphics, int frame) {
        String introFrame = frame < 10 ? "00" + frame : (frame < 100 ? "0" + frame : "" + frame);
        Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/wormhole/" + type.name().toLowerCase() + "/ezgif-frame-" + introFrame + ".jpg"));
        GuiHelper.drawScaledCustomSizeModalRect(0, 0, 0.0f, 0.0f, 1920, 1080, graphics.m_280182_(), graphics.m_280206_(), 1920.0f, 1080.0f);
    }

    private static float getWhiteCoef() {
        if (!isPlayingWhite) {
            return 0.0f;
        }
        float alphaCoef = (float)(JSGMinecraftHelper.getPlayerTickClientSide() - playingWhiteStarted) / 20.0f;
        if (alphaCoef > 1.0f) {
            alphaCoef = 1.0f;
            isPlayingWhite = false;
        }
        return alphaCoef;
    }

    private static float getWhiteAlpha(float alphaCoef) {
        return (float)Math.sin((double)((1.0f - alphaCoef) * (1.0f - alphaCoef)) * Math.PI);
    }

    private static void renderWhiteFlash(GuiGraphics graphics, float alpha) {
        GuiHelper.currentStack = graphics.m_280168_();
        GuiHelper.drawRect(0, 0, graphics.m_280182_(), graphics.m_280206_(), 0xFFFFFF | (int)(alpha * 255.0f) << 24);
    }

    static {
        travelSoundPos = null;
    }
}

