/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.entity;

import dev.tauri.jsg.registry.VillagerRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraftforge.event.village.VillagerTradesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerTradesBuilder {
    private ItemStack input1;
    @Nullable
    private ItemStack input2;
    private ItemStack output;
    private int maxUses = 10;
    private int xpPerTrade = 1;
    private float priceMultiplier = 0.2f;
    private int[] forLevels = new int[]{1, 2, 3, 4, 5};
    private List<VillagerProfession> forProfessions = null;
    private boolean priestOnly = false;
    @NotNull
    private final VillagerTradesEvent event;

    private VillagerTradesBuilder(@NotNull VillagerTradesEvent event) {
        this.event = event;
    }

    public VillagerTradesBuilder setInput1(ItemStack stack) {
        this.input1 = stack;
        return this;
    }

    public VillagerTradesBuilder setInput2(ItemStack stack) {
        this.input2 = stack;
        return this;
    }

    public VillagerTradesBuilder setOutput(ItemStack stack) {
        this.output = stack;
        return this;
    }

    public VillagerTradesBuilder setMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public VillagerTradesBuilder setXpPerTrade(int xpPerTrade) {
        this.xpPerTrade = xpPerTrade;
        return this;
    }

    public VillagerTradesBuilder setPriceMul(float priceMultiplier) {
        this.priceMultiplier = priceMultiplier;
        return this;
    }

    public VillagerTradesBuilder setForLevels(int ... levels) {
        this.forLevels = levels;
        return this;
    }

    public VillagerTradesBuilder setForProfessions(VillagerProfession ... professions) {
        this.forProfessions = List.of(professions);
        return this;
    }

    public VillagerTradesBuilder setPriestOnly() {
        this.priestOnly = true;
        return this;
    }

    public VillagerTradesBuilder register(VillagerTrades.ItemListing offer) {
        if (this.priestOnly && !VillagerRegistry.isPriest(this.event.getType())) {
            return VillagerTradesBuilder.create(this.event);
        }
        if (this.forProfessions != null && !this.forProfessions.isEmpty() && !this.forProfessions.contains(this.event.getType())) {
            return VillagerTradesBuilder.create(this.event);
        }
        Int2ObjectMap trades = this.event.getTrades();
        for (int level : this.forLevels) {
            ((List)trades.get(level)).add(offer);
        }
        return VillagerTradesBuilder.create(this.event);
    }

    public VillagerTradesBuilder register() {
        if (this.input1 == null || this.output == null) {
            throw new NullPointerException("Tried to register villager trade with null input/output!");
        }
        if (this.priestOnly && !VillagerRegistry.isPriest(this.event.getType())) {
            return VillagerTradesBuilder.create(this.event);
        }
        if (this.forProfessions != null && !this.forProfessions.isEmpty() && !this.forProfessions.contains(this.event.getType())) {
            return VillagerTradesBuilder.create(this.event);
        }
        Int2ObjectMap trades = this.event.getTrades();
        for (int level : this.forLevels) {
            VillagerTrades.ItemListing lambda = this.input2 != null ? (trader, random) -> new MerchantOffer(this.input1, this.input2, this.output, this.maxUses, this.xpPerTrade, this.priceMultiplier) : (trader, random) -> new MerchantOffer(this.input1, this.output, this.maxUses, this.xpPerTrade, this.priceMultiplier);
            ((List)trades.get(level)).add(lambda);
        }
        return VillagerTradesBuilder.create(this.event);
    }

    public static VillagerTradesBuilder create(@NotNull VillagerTradesEvent event) {
        return new VillagerTradesBuilder(event);
    }
}

