/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.entity.behaviour;

import com.google.common.collect.ImmutableMap;
import dev.tauri.jsg.api.stargate.dialhomedevice.StargateDHD;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargatePegasusBaseBE;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;

public class DialGateBehaviour
extends Behavior<Villager> {
    protected DHDAbstractBE dhd;
    protected Pair<BlockPos, DHDAbstractBE> lastFoundDHDForPos;
    protected Vec3 targetPos;
    protected StargateAbstractBaseBE<?, ?> gate;
    protected StargateAddressDynamic address;
    protected int addressPosition = 0;
    protected long canStartAt = -1L;
    protected boolean gateShouldBeOpened = false;

    public DialGateBehaviour() {
        super((Map)ImmutableMap.of());
    }

    @Nullable
    protected DHDAbstractBE findDHD(Villager owner) {
        if (this.lastFoundDHDForPos != null && owner.m_20183_().m_123314_((Vec3i)this.lastFoundDHDForPos.first(), 20.0)) {
            return (DHDAbstractBE)this.lastFoundDHDForPos.second();
        }
        DHDAbstractBE dhd = LinkingHelper.findClosestTile(owner.m_9236_(), owner.m_20183_(), JSGBlockTags.DHD_ANY, DHDAbstractBE.class, 50, 50);
        this.lastFoundDHDForPos = Pair.of((Object)owner.m_20183_(), (Object)dhd);
        return (DHDAbstractBE)this.lastFoundDHDForPos.second();
    }

    @Nullable
    protected StargateAddressDynamic getRandomVillageAddress(Villager owner) {
        StargateType stargateType;
        if (this.dhd == null || this.gate == null) {
            return null;
        }
        AbstractSymbolType symbolType = this.dhd.getSymbolType();
        boolean hasUpgrade = this.dhd.hasUpgrade(StargateDHD.DHDUpgradeEnum.CHEVRON_UPGRADE) && owner.m_7141_().m_35576_() > 1;
        StargateType stargateType2 = stargateType = hasUpgrade ? StargateType.getRandomClassic(owner.m_217043_()) : this.gate.getStargateType();
        if (stargateType == null) {
            return null;
        }
        Pair<StargatePos, StargateAddress> randomGate = StargateNetwork.INSTANCE.getRandomAddress(owner.m_217043_(), symbolType, stargateType, null);
        if (randomGate == null) {
            return null;
        }
        int neededSymbols = ((StargateAbstractDialingManager)this.gate.getDialingManager()).getMinimalSymbolsToDial(((StargatePos)randomGate.first()).getGateSymbolType(), (StargatePos)randomGate.first());
        StargateAddressDynamic address = new StargateAddressDynamic(symbolType, ((StargateAddress)randomGate.second()).subList(0, neededSymbols - 1));
        address.addSymbol((SymbolInterface)symbolType.getOrigin());
        return address;
    }

    @ParametersAreNonnullByDefault
    public boolean checkExtraStartConditions(ServerLevel pLevel, Villager owner) {
        if (this.canStartAt == -1L) {
            this.canStartAt = pLevel.m_46467_() + 2400L;
        }
        if (pLevel.m_46467_() < this.canStartAt) {
            return false;
        }
        if (owner.m_217043_().m_188501_() > 0.3f) {
            return false;
        }
        this.dhd = this.findDHD(owner);
        if (this.dhd == null) {
            return false;
        }
        this.gate = this.dhd.getLinkedDevice();
        if (this.gate == null) {
            return false;
        }
        if (!this.gate.isMerged()) {
            return false;
        }
        if (!((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().idle()) {
            return false;
        }
        if (((StargateAbstractDialingManager)this.gate.getDialingManager()).getDialedAddressSize() != 0) {
            return false;
        }
        this.address = this.getRandomVillageAddress(owner);
        if (this.address == null) {
            return false;
        }
        return ((StargateAbstractDialingManager)this.gate.getDialingManager()).canDialAddress(this.address);
    }

    @ParametersAreNonnullByDefault
    public boolean canStillUse(ServerLevel pLevel, Villager owner, long pGameTime) {
        return this.dhd != null && this.dhd.isLinked() && this.gate != null && !owner.m_6274_().m_21954_(Activity.f_37984_);
    }

    @ParametersAreNonnullByDefault
    protected void start(ServerLevel pLevel, Villager owner, long pGameTime) {
        super.m_6735_(pLevel, (LivingEntity)owner, pGameTime);
        this.targetPos = this.dhd.getBlockPosInFront();
        this.addressPosition = 0;
        this.canStartAt = pLevel.m_46467_() + 2400L;
    }

    @ParametersAreNonnullByDefault
    protected void stop(ServerLevel pLevel, Villager owner, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)owner, pGameTime);
        if (this.targetPos != null && owner.m_21573_().m_26570_() != null && !owner.m_21573_().m_26570_().m_77406_().equals((Object)BlockPos.m_274446_((Position)this.targetPos))) {
            owner.m_21573_().m_26573_();
        }
        this.gate = null;
        this.dhd = null;
        this.address = null;
        this.gateShouldBeOpened = false;
        this.addressPosition = 0;
    }

    @ParametersAreNonnullByDefault
    protected void tick(ServerLevel pLevel, Villager owner, long pGameTime) {
        if (this.m_22536_() != Behavior.Status.RUNNING) {
            return;
        }
        if (this.targetPos == null || this.dhd == null || this.gate == null || this.address == null || this.dhd.m_58904_() == null || !(this.dhd.m_58904_().m_7702_(this.dhd.m_58899_()) instanceof DHDAbstractBE) || !this.dhd.isLinked()) {
            this.m_22562_(pLevel, (LivingEntity)owner, pGameTime);
            return;
        }
        if (owner.m_21573_().m_26570_() != null && !owner.m_21573_().m_26570_().m_77406_().equals((Object)BlockPos.m_274446_((Position)this.targetPos))) {
            owner.m_21573_().m_26573_();
        }
        if (!this.gateShouldBeOpened && (((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().engaged() || ((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().unstable()) || ((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().failing()) {
            this.m_22562_(pLevel, (LivingEntity)owner, pGameTime);
            return;
        }
        if (this.gateShouldBeOpened && ((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().idle()) {
            this.m_22562_(pLevel, (LivingEntity)owner, pGameTime);
            return;
        }
        if (!this.gateShouldBeOpened && ((StargateAbstractDialingManager)this.gate.getDialingManager()).getDialedAddress().size() > this.addressPosition) {
            this.m_22562_(pLevel, (LivingEntity)owner, pGameTime);
            return;
        }
        if (this.gateShouldBeOpened && ((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().initiating()) {
            this.targetPos = this.gate.getGateCenterPos().m_252807_();
        }
        if (this.targetPos.m_82554_(owner.m_20182_()) > 50.0) {
            this.m_22562_(pLevel, (LivingEntity)owner, pGameTime);
            return;
        }
        double speed = owner.m_21133_(Attributes.f_22279_) * (double)(this.gateShouldBeOpened ? 1.3f : 1.0f);
        Vec3 tempPos = new Vec3(this.targetPos.m_7096_(), owner.m_20186_(), this.targetPos.m_7094_());
        double d = tempPos.m_82554_(owner.m_20182_());
        double d2 = this.gateShouldBeOpened ? 1.0 : 0.5;
        if (d <= d2) {
            StargatePegasusBaseBE pegasusBaseBE;
            StargateAbstractBaseBE<?, ?> stargateAbstractBaseBE;
            if (this.gateShouldBeOpened) {
                if (((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().initiating() || ((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().idle()) {
                    this.m_22562_(pLevel, (LivingEntity)owner, pGameTime);
                }
                return;
            }
            owner.m_21563_().m_24964_(this.dhd.m_58899_().m_252807_());
            if (!(((StargateAbstractDialingManager)this.gate.getDialingManager()).getStargateState().idle() || (stargateAbstractBaseBE = this.gate) instanceof StargatePegasusBaseBE && ((StargateAbstractDialingManager)(pegasusBaseBE = (StargatePegasusBaseBE)stargateAbstractBaseBE).getDialingManager()).getStargateState().dialingDHD())) {
                return;
            }
            if (pLevel.m_46467_() % 20L != 0L) {
                return;
            }
            if (((StargateAbstractDialingManager)this.gate.getDialingManager()).getDialedAddress().getLast() == this.gate.getSymbolType().getOrigin()) {
                this.dhd.pushSymbolButton((SymbolInterface)this.dhd.getSymbolType().getBRB(), null, false);
                owner.m_21563_().m_24964_(this.dhd.m_58899_().m_252807_().m_82520_(0.0, 1.0, 0.0));
                this.gateShouldBeOpened = true;
                return;
            }
            if (this.addressPosition > ((StargateAbstractDialingManager)this.gate.getDialingManager()).getDialedAddressSize()) {
                --this.addressPosition;
            }
            SymbolInterface symbol = this.address.get(this.addressPosition);
            if (((StargateAbstractDialingManager)this.gate.getDialingManager()).canAddSymbol(symbol, false) != StargateChevronEngageResult.OK) {
                return;
            }
            this.dhd.pushSymbolButton(symbol, null, false);
            owner.m_21563_().m_24964_(this.dhd.m_58899_().m_252807_().m_82520_(0.0, -0.5, 0.0));
            ++this.addressPosition;
            return;
        }
        if (this.targetPos.m_82554_(owner.m_20182_()) <= 2.5) {
            owner.m_21566_().m_6849_(this.targetPos.m_7096_(), this.targetPos.m_7098_(), this.targetPos.m_7094_(), speed);
            return;
        }
        owner.m_21573_().m_26536_(owner.m_21573_().m_26524_(this.targetPos.m_7096_(), this.targetPos.m_7098_(), this.targetPos.m_7094_(), 1), speed);
    }

    protected boolean m_7773_(long pGameTime) {
        return false;
    }
}

