/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class BlockPosHelper {
    public static double dist(Vec3i vec1, int vec2X, int vec2Y, int vec2Z) {
        return BlockPosHelper.dist(vec1, new Vec3i(vec2X, vec2Y, vec2Z));
    }

    public static double dist(Vec3i vec1, Vec3i vec2) {
        double d0 = vec1.m_123341_() - vec2.m_123341_();
        double d1 = vec1.m_123342_() - vec2.m_123342_();
        double d2 = vec1.m_123343_() - vec2.m_123343_();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public static int getIntRotation(Direction facing, boolean inverted) {
        return switch (facing) {
            case Direction.EAST, Direction.DOWN -> {
                if (inverted) {
                    yield 90;
                }
                yield 270;
            }
            case Direction.SOUTH -> {
                if (!inverted) {
                    yield 180;
                }
                yield 0;
            }
            case Direction.WEST, Direction.UP -> {
                if (!inverted) {
                    yield 90;
                }
                yield 270;
            }
            default -> inverted ? 180 : 0;
        };
    }

    public static int getIntDHDRotationFromFacing(Direction facing, boolean inverted) {
        return (int)Math.floor((float)BlockPosHelper.getIntRotation(facing, inverted) / 360.0f * 16.0f);
    }

    public static Direction rotateDir(Direction dir, Rotation rot) {
        int count = 0;
        if (rot == Rotation.CLOCKWISE_90) {
            count = 1;
        }
        if (rot == Rotation.CLOCKWISE_180) {
            count = 2;
        }
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            count = 3;
        }
        for (int i = 0; i < count; ++i) {
            dir = dir.m_122427_();
        }
        return dir;
    }

    public static int rotateDHDDir(int dir, Rotation rot) {
        int count = 0;
        if (rot == Rotation.CLOCKWISE_90) {
            count = 1;
        }
        if (rot == Rotation.CLOCKWISE_180) {
            count = 2;
        }
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            count = 3;
        }
        for (int i = 0; i < count; ++i) {
            dir += 4;
            dir %= 16;
        }
        return dir;
    }

    public static Direction flipDir(Direction dir, Mirror mirror) {
        if (mirror == null) {
            return dir;
        }
        if (mirror == Mirror.FRONT_BACK && dir.m_122434_() == Direction.Axis.X) {
            return dir.m_122424_();
        }
        if (mirror == Mirror.LEFT_RIGHT && dir.m_122434_() == Direction.Axis.Z) {
            return dir.m_122424_();
        }
        return dir;
    }

    public static BlockPos getPos(Vec3 vector) {
        return new BlockPos((int)vector.f_82479_, (int)vector.f_82480_, (int)vector.f_82481_);
    }

    public static Vec3 getVec3(Vec3i vector) {
        return new Vec3((double)vector.m_123341_(), (double)vector.m_123342_(), (double)vector.m_123343_());
    }
}

