/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.dialhomedevice.StargateDHD;
import dev.tauri.jsg.api.util.blockentity.ILinkableBE;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LinkingHelper {
    @Nullable
    public static BlockPos findClosestUnlinked(Level world, BlockPos startPos, BlockPos radius, TagKey<Block> allowedBlock) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos target : BlockPos.m_121940_((BlockPos)startPos.m_121996_((Vec3i)radius), (BlockPos)startPos.m_121955_((Vec3i)radius))) {
            double distanceSq;
            ILinkableBE linkedTile;
            BlockEntity blockEntity;
            BlockPos imPos = target.m_7949_();
            if (!world.m_8055_(imPos).m_204336_(allowedBlock) || !((blockEntity = world.m_7702_(imPos)) instanceof ILinkableBE) || !(linkedTile = (ILinkableBE)blockEntity).canLinkTo() || !((distanceSq = startPos.m_123331_((Vec3i)imPos)) < closestDistance)) continue;
            closestDistance = distanceSq;
            closest = imPos;
        }
        return closest;
    }

    @Nullable
    public static BlockPos findClosestPos(Level world, BlockPos startPos, BlockPos radius, TagKey<Block> allowedBlock, ArrayList<BlockPos> blacklist) {
        return LinkingHelper.findClosestPos(world, startPos, radius, allowedBlock, blacklist, pos -> true);
    }

    @Nullable
    public static BlockPos findClosestPos(Level world, BlockPos startPos, BlockPos radius, TagKey<Block> allowedBlock, ArrayList<BlockPos> blacklist, Predicate<BlockPos> posPredicate) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos target : BlockPos.m_121940_((BlockPos)startPos.m_121996_((Vec3i)radius), (BlockPos)startPos.m_121955_((Vec3i)radius))) {
            double distanceSq;
            if (!world.m_8055_(target).m_204336_(allowedBlock) || blacklist.contains(target) || !posPredicate.test(target) || !((distanceSq = startPos.m_123331_((Vec3i)target)) < closestDistance)) continue;
            closestDistance = distanceSq;
            closest = target.m_7949_();
        }
        return closest;
    }

    @Nullable
    public static <T> T findClosestTile(Level world, BlockPos startPos, TagKey<Block> allowedBlocks, Class<T> tileClass, int radiusXZ, int radiusY) {
        return LinkingHelper.findClosestTile(world, startPos, allowedBlocks, tileClass, radiusXZ, radiusY, pos -> true);
    }

    @Nullable
    public static <T> T findClosestTile(Level world, BlockPos startPos, TagKey<Block> allowedBlocks, Class<T> tileClass, int radiusXZ, int radiusY, Predicate<BlockPos> posPredicate) {
        AtomicReference<Object> tileEntity = new AtomicReference<Object>(null);
        LinkingHelper.findClosestPos(world, startPos, new BlockPos(radiusXZ, radiusY, radiusXZ), allowedBlocks, new ArrayList<BlockPos>(), posPredicate.and(pos -> {
            BlockEntity tile = world.m_7702_(pos);
            if (!tileClass.isInstance(tile)) {
                return false;
            }
            tileEntity.set(tile);
            return true;
        }));
        return tileEntity.get();
    }

    public static BlockPos getDhdRange() {
        int xz = JSGConfig.DialHomeDevice.rangeFlat.get();
        int y = JSGConfig.DialHomeDevice.rangeVertical.get();
        return new BlockPos(xz, y, xz);
    }

    public static void updateLinkedGate(Level world, BlockPos gatePos, BlockPos dhdPos) {
        Stargate gateTile = (Stargate)world.m_7702_(gatePos);
        BlockEntity dhdTile = world.m_7702_(dhdPos);
        if (dhdTile instanceof StargateDHD) {
            StargateDHD dhd = (StargateDHD)dhdTile;
            if (gateTile instanceof ILinkableBE) {
                dhd.setLinkedDevice(gatePos);
                ((ILinkableBE)((Object)gateTile)).setLinkedDevice(dhdPos);
            }
        }
    }
}

