/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.item.ITabbedItem;
import dev.tauri.jsg.api.item.JSGBlockItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class TabHelper {
    private final Supplier<DeferredRegister<CreativeModeTab>> register;
    private static final List<Supplier<DeferredRegister<Item>>> INDEXED_ITEM_REGISTERS = new ArrayList<Supplier<DeferredRegister<Item>>>();
    public final Map<String, List<RegistryObject<? extends ItemLike>>> TAB_ITEMS = new HashMap<String, List<RegistryObject<? extends ItemLike>>>();
    private final LinkedList<RegistryObject<CreativeModeTab>> orderedTabs = new LinkedList();

    public static void indexItemRegistry(Supplier<DeferredRegister<Item>> itemRegistrySupplier) {
        INDEXED_ITEM_REGISTERS.add(itemRegistrySupplier);
    }

    @Deprecated(forRemoval=true)
    public TabHelper(Supplier<DeferredRegister<CreativeModeTab>> register, Supplier<DeferredRegister<Item>> itemRegister) {
        this(register);
    }

    public TabHelper(Supplier<DeferredRegister<CreativeModeTab>> register) {
        this.register = register;
    }

    @Deprecated
    @ParametersAreNonnullByDefault
    public RegistryObject<CreativeModeTab> createCreativeTab(String name, Supplier<RegistryObject<? extends ItemLike>> iconObject) {
        return this.createCreativeTabWithItemStack(name, () -> new ItemStack((ItemLike)((RegistryObject)iconObject.get()).get()));
    }

    @ParametersAreNonnullByDefault
    public RegistryObject<CreativeModeTab> createCreativeTabWithItemStack(String name, Supplier<ItemStack> iconObject) {
        ArrayList<RegistryObject<CreativeModeTab>> tabsBefore = new ArrayList<RegistryObject<CreativeModeTab>>(this.orderedTabs);
        RegistryObject thisTab = this.register.get().register(name, () -> {
            CreativeModeTab.Builder tab = CreativeModeTab.builder().m_257737_(() -> TabHelper.lambda$createCreativeTabWithItemStack$1((Supplier)iconObject, name)).m_257941_((Component)Component.m_237115_((String)("itemGroup.jsg_" + name))).m_257501_((parameters, output) -> {
                List<Object> list = this.TAB_ITEMS.get(name);
                if (list == null) {
                    list = new ArrayList<RegistryObject<? extends ItemLike>>();
                    for (Supplier supplier : INDEXED_ITEM_REGISTERS) {
                        for (RegistryObject itemObject : ((DeferredRegister)supplier.get()).getEntries()) {
                            ITabbedItem jsgItem;
                            List<RegistryObject<CreativeModeTab>> tabs;
                            Item item = (Item)itemObject.get();
                            if (!(item instanceof ITabbedItem) || (tabs = (jsgItem = (ITabbedItem)item).getTabs()) == null || tabs.isEmpty() || !tabs.stream().map(t -> Objects.requireNonNull(t.getId()).m_135815_()).anyMatch(n -> n.equalsIgnoreCase(name))) continue;
                            list.add((RegistryObject<? extends ItemLike>)itemObject);
                        }
                    }
                    list = list.stream().sorted((l, r) -> {
                        String keyR;
                        String keyL = Objects.requireNonNull(l.getId()).m_135827_();
                        if (keyL.equalsIgnoreCase(keyR = Objects.requireNonNull(r.getId()).m_135827_())) {
                            return 0;
                        }
                        if (keyL.equalsIgnoreCase("jsg")) {
                            return -1;
                        }
                        return 1;
                    }).toList();
                    this.TAB_ITEMS.put(name, list);
                }
                for (RegistryObject registryObject : list) {
                    ItemLike item = (ItemLike)registryObject.get();
                    output.m_246342_(new ItemStack(item));
                    if (!(item instanceof JSGBlockItem)) continue;
                    JSGBlockItem jsgItemBlock = (JSGBlockItem)item;
                    jsgItemBlock.addAdditional(output);
                }
            });
            for (RegistryObject t : tabsBefore) {
                tab.withTabsBefore(new ResourceLocation[]{t.getId()});
            }
            return tab.m_257652_();
        });
        this.orderedTabs.addLast((RegistryObject<CreativeModeTab>)thisTab);
        return thisTab;
    }

    private static /* synthetic */ ItemStack lambda$createCreativeTabWithItemStack$1(Supplier iconObject, String name) {
        if (iconObject.get() == null) {
            JSGApi.logger.error("Tab {} has null icon!", (Object)name);
            return new ItemStack((ItemLike)Blocks.f_50016_);
        }
        return (ItemStack)iconObject.get();
    }
}

