/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class VectorHelper {
    Direction horizontalOrigin;
    Direction verticalOrigin;
    Direction horizontalTarget;
    Direction verticalTarget;

    public VectorHelper(Direction horizontalOrigin, Direction verticalOrigin, Direction horizontalTarget, Direction verticalTarget) {
        if (horizontalOrigin == null) {
            horizontalOrigin = Direction.SOUTH;
        }
        if (verticalOrigin == null) {
            verticalOrigin = Direction.SOUTH;
        }
        if (horizontalTarget == null) {
            horizontalTarget = Direction.SOUTH;
        }
        if (verticalTarget == null) {
            verticalTarget = Direction.SOUTH;
        }
        this.horizontalOrigin = horizontalOrigin;
        this.verticalOrigin = verticalOrigin;
        this.horizontalTarget = horizontalTarget;
        this.verticalTarget = verticalTarget;
    }

    @ParametersAreNullableByDefault
    public Vec3 rotate(Vec3 origin, RotationFunction function) {
        if (function == null) {
            function = southVector -> southVector;
        }
        if (origin == null) {
            return null;
        }
        Direction.Axis hAxisSource = this.horizontalOrigin.m_122434_();
        Vec3i hVectorSource = this.horizontalOrigin.m_122436_();
        Direction.Axis hAxisTarget = this.horizontalTarget.m_122434_();
        Vec3i hVectorTarget = this.horizontalTarget.m_122436_();
        Direction.Axis vAxisSource = this.verticalOrigin.m_122434_();
        Vec3i vVectorSource = this.verticalOrigin.m_122436_();
        Direction.Axis vAxisTarget = this.verticalTarget.m_122434_();
        Vec3i vVectorTarget = this.verticalTarget.m_122436_();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (vAxisSource == Direction.Axis.Y) {
            z = origin.m_7098_() * (double)vVectorSource.m_123342_() * -1.0;
            if (hAxisSource == Direction.Axis.X) {
                x = origin.m_7094_() * (double)hVectorSource.m_123341_() * (double)vVectorSource.m_123342_() * -1.0;
                y = origin.m_7096_() * (double)hVectorSource.m_123341_() * (double)vVectorSource.m_123342_() * -1.0;
            }
            if (hAxisSource == Direction.Axis.Z) {
                x = origin.m_7096_() * (double)hVectorSource.m_123343_() * (double)vVectorSource.m_123342_();
                y = origin.m_7094_() * (double)hVectorSource.m_123343_() * (double)vVectorSource.m_123342_() * -1.0;
            }
        } else {
            y = origin.m_7098_();
            if (hAxisSource == Direction.Axis.X) {
                x = origin.m_7094_() * (double)hVectorSource.m_123341_() * -1.0;
                z = origin.m_7096_() * (double)hVectorSource.m_123341_() * -1.0;
            }
            if (hAxisSource == Direction.Axis.Z) {
                x = origin.m_7096_() * (double)hVectorSource.m_123343_();
                z = origin.m_7094_() * (double)hVectorSource.m_123343_() * -1.0;
            }
        }
        Vec3 compiledVector = function.doStuff(new Vec3(x, y, z));
        x = compiledVector.m_7096_();
        y = compiledVector.m_7098_();
        z = compiledVector.m_7094_();
        Vec3 result = compiledVector;
        if (vAxisTarget == Direction.Axis.Y) {
            if (hAxisTarget == Direction.Axis.X) {
                result = new Vec3(y * (double)hVectorTarget.m_123341_() * (double)vVectorTarget.m_123342_() * -1.0, z * (double)vVectorTarget.m_123342_(), x * (double)hVectorTarget.m_123341_() * (double)vVectorTarget.m_123342_());
            }
            if (hAxisTarget == Direction.Axis.Z) {
                result = new Vec3(x * (double)hVectorTarget.m_123343_() * (double)vVectorTarget.m_123342_(), z * (double)vVectorTarget.m_123342_(), y * (double)hVectorTarget.m_123343_() * (double)vVectorTarget.m_123342_() * -1.0);
            }
        } else {
            if (hAxisTarget == Direction.Axis.X) {
                result = new Vec3(z * (double)hVectorTarget.m_123341_(), y, x * (double)hVectorTarget.m_123341_());
            }
            if (hAxisTarget == Direction.Axis.Z) {
                result = new Vec3(x * (double)hVectorTarget.m_123343_(), y, z * (double)hVectorTarget.m_123343_());
            }
        }
        return result;
    }

    public static interface RotationFunction {
        public Vec3 doStuff(Vec3 var1);
    }
}

