/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry;

import dev.tauri.jsg.helpers.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.registries.RegistryObject;

public abstract class RegistryObjectBuilder<T extends RegistryHelper<?, ?>> {
    protected final T registryHelper;
    protected final String name;
    protected List<RegistryObject<CreativeModeTab>> tabs;

    public RegistryObjectBuilder(T registryHelper, String name) {
        this.registryHelper = registryHelper;
        this.name = name;
    }

    public RegistryObjectBuilder(String name, RegistryObjectBuilder<T> other) {
        this(other.registryHelper, name);
        if (other.tabs == null) {
            return;
        }
        this.tabs = new ArrayList<RegistryObject<CreativeModeTab>>();
        this.tabs.addAll(other.tabs);
    }

    public RegistryObjectBuilder<T> setInTabs(List<RegistryObject<CreativeModeTab>> tabs) {
        this.tabs = new ArrayList<RegistryObject<CreativeModeTab>>();
        this.tabs.addAll(tabs);
        return this;
    }

    public static interface TooltipApplier<T> {
        @ParametersAreNonnullByDefault
        public void apply(T var1, ItemStack var2, @Nullable BlockGetter var3, List<Component> var4, TooltipFlag var5);
    }
}

