/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry.block;

import dev.tauri.jsg.api.block.JSGTabbedBlock;
import dev.tauri.jsg.block.core.ButtonBlockTabbed;
import dev.tauri.jsg.block.core.DoorBlockTabbed;
import dev.tauri.jsg.block.core.FenceBlockTabbed;
import dev.tauri.jsg.block.core.FenceGateBlockTabbed;
import dev.tauri.jsg.block.core.JSGTabbedFallingBlock;
import dev.tauri.jsg.block.core.LeaveBlockTabbed;
import dev.tauri.jsg.block.core.PressurePlateBlockTabbed;
import dev.tauri.jsg.block.core.RotatedPillarBlockTabbed;
import dev.tauri.jsg.block.core.SlabBlockTabbed;
import dev.tauri.jsg.block.core.StairBlockTabbed;
import dev.tauri.jsg.block.stargate.TrapdoorBlockTabbed;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.helpers.registry.RegistryHelper;
import dev.tauri.jsg.helpers.registry.RegistryObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockRegistryHelperGeneric
extends RegistryHelper<Block, GenericBlockBuilder> {
    public BlockRegistryHelperGeneric(Supplier<DeferredRegister<Block>> registry) {
        super(registry, GenericBlockBuilder::new);
    }

    public static class GenericBlockBuilder
    extends RegistryObjectBuilder<RegistryHelper<Block, ? extends GenericBlockBuilder>> {
        protected RegistryObjectBuilder.TooltipApplier<Block> tooltipApplier = (item, itemStack, blockGetter, components, tooltipFlag) -> ItemHelper.applyGenericToolTip(item.m_7705_(), components, tooltipFlag);
        protected int flammability;
        protected int fireSpreadSpeed;
        protected final Map<Predicate<ItemStack>, Function<BlockState, BlockState>> toolStateModifiers = new HashMap<Predicate<ItemStack>, Function<BlockState, BlockState>>();
        protected BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();

        public GenericBlockBuilder(RegistryHelper<Block, ? extends GenericBlockBuilder> registryHelper, String name) {
            super(registryHelper, name);
        }

        public GenericBlockBuilder(String name, GenericBlockBuilder other) {
            super(name, other);
            this.tooltipApplier = other.tooltipApplier;
            this.flammability = other.flammability;
            this.fireSpreadSpeed = other.fireSpreadSpeed;
            this.toolStateModifiers.clear();
            this.toolStateModifiers.putAll(other.toolStateModifiers);
            this.properties = other.properties;
        }

        public GenericBlockBuilder applyTooltip(@NotNull RegistryObjectBuilder.TooltipApplier<Block> tooltipApplier) {
            this.tooltipApplier = tooltipApplier;
            return this;
        }

        public GenericBlockBuilder clearTooltip() {
            this.tooltipApplier = (item, itemStack, blockGetter, components, tooltipFlag) -> {};
            return this;
        }

        public GenericBlockBuilder setFlammability(int flammability) {
            this.flammability = flammability;
            return this;
        }

        public GenericBlockBuilder setFireSpreadSpeed(int fireSpreadSpeed) {
            this.fireSpreadSpeed = fireSpreadSpeed;
            return this;
        }

        public GenericBlockBuilder addToolStateModifier(Predicate<ItemStack> toolPredicate, Function<BlockState, BlockState> resultGetter) {
            this.toolStateModifiers.put(toolPredicate, resultGetter);
            return this;
        }

        public GenericBlockBuilder addToolStateModifierPillar(Predicate<ItemStack> toolPredicate, Supplier<Block> resultGetter) {
            return this.addToolStateModifier(toolPredicate, state -> (BlockState)((Block)resultGetter.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))));
        }

        public GenericBlockBuilder setProperties(BlockBehaviour.Properties properties) {
            this.properties = properties;
            return this;
        }

        public GenericBlockBuilder setInTabs(List<RegistryObject<CreativeModeTab>> tabs) {
            return (GenericBlockBuilder)super.setInTabs(tabs);
        }

        public RegistryObject<Block> buildGeneric() {
            return this.registryHelper.registry.get().register(this.name, () -> new JSGTabbedBlock(this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildFallingGeneric() {
            return this.registryHelper.registry.get().register(this.name, () -> new JSGTabbedFallingBlock(this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildStairs(Supplier<BlockState> baseBlockState) {
            return this.registryHelper.registry.get().register(this.name, () -> new StairBlockTabbed(baseBlockState, this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildSlab() {
            return this.registryHelper.registry.get().register(this.name, () -> new SlabBlockTabbed(this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildLeaves() {
            return this.registryHelper.registry.get().register(this.name, () -> new LeaveBlockTabbed(this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildFence() {
            return this.registryHelper.registry.get().register(this.name, () -> new FenceBlockTabbed(this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildFenceGate(Supplier<SoundEvent> openSound, Supplier<SoundEvent> closeSound) {
            return this.registryHelper.registry.get().register(this.name, () -> new FenceGateBlockTabbed(this.properties, (SoundEvent)openSound.get(), (SoundEvent)closeSound.get()){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildButton(BlockSetType type, int duration, boolean arrowCanPress) {
            return this.registryHelper.registry.get().register(this.name, () -> new ButtonBlockTabbed(this.properties, type, duration, arrowCanPress){

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildPressurePlate(PressurePlateBlock.Sensitivity sensitivity, BlockSetType type) {
            return this.registryHelper.registry.get().register(this.name, () -> new PressurePlateBlockTabbed(sensitivity, this.properties, type){

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildDoor(BlockSetType type) {
            return this.registryHelper.registry.get().register(this.name, () -> new DoorBlockTabbed(this.properties, type){

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildTrapdoor(BlockSetType type) {
            return this.registryHelper.registry.get().register(this.name, () -> new TrapdoorBlockTabbed(this.properties, type){

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildPillar(MapColor pTopMapColor, MapColor pSideMapColor) {
            return this.registryHelper.registry.get().register(this.name, () -> new RotatedPillarBlockTabbed(this.properties.m_284495_(bs -> bs.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? pTopMapColor : pSideMapColor)){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry<Predicate<ItemStack>, Function<BlockState, BlockState>> e : toolStateModifiers.entrySet()) {
                            if (!e.getKey().test(context.m_43722_())) continue;
                            return e.getValue().apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply((Block)this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }
    }
}

