/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry.block;

import dev.tauri.jsg.block.core.JSGOreBlock;
import dev.tauri.jsg.block.crystal.CrystalBudBlock;
import dev.tauri.jsg.block.crystal.CrystalBudType;
import dev.tauri.jsg.block.crystal.CrystalBuddingBlock;
import dev.tauri.jsg.block.crystal.CrystalColor;
import dev.tauri.jsg.block.crystal.CrystalUnstableBuddingBlock;
import dev.tauri.jsg.helpers.registry.RegistryHelper;
import dev.tauri.jsg.helpers.registry.RegistryObjectBuilder;
import dev.tauri.jsg.helpers.registry.block.BlockRegistryHelperGeneric;
import dev.tauri.jsg.helpers.registry.block.OreBlockVariant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockRegistryHelperOre
extends RegistryHelper<Block, OreBlockBuilder> {
    public BlockRegistryHelperOre(Supplier<DeferredRegister<Block>> registry) {
        super(registry, OreBlockBuilder::new);
    }

    public static class OreBlockBuilder
    extends BlockRegistryHelperGeneric.GenericBlockBuilder {
        public OreBlockBuilder(RegistryHelper<Block, OreBlockBuilder> registryHelper, String name) {
            super(registryHelper, name);
        }

        public OreBlockBuilder(String name, OreBlockBuilder other) {
            super(name, other);
        }

        @Override
        public OreBlockBuilder applyTooltip(@NotNull RegistryObjectBuilder.TooltipApplier<Block> tooltipApplier) {
            return (OreBlockBuilder)super.applyTooltip(tooltipApplier);
        }

        @Override
        public OreBlockBuilder clearTooltip() {
            return (OreBlockBuilder)super.clearTooltip();
        }

        @Override
        public OreBlockBuilder setFlammability(int flammability) {
            return (OreBlockBuilder)super.setFlammability(flammability);
        }

        @Override
        public OreBlockBuilder setFireSpreadSpeed(int fireSpreadSpeed) {
            return (OreBlockBuilder)super.setFireSpreadSpeed(fireSpreadSpeed);
        }

        @Override
        public OreBlockBuilder addToolStateModifier(Predicate<ItemStack> toolPredicate, Function<BlockState, BlockState> resultGetter) {
            return (OreBlockBuilder)super.addToolStateModifier(toolPredicate, resultGetter);
        }

        @Override
        public OreBlockBuilder setProperties(BlockBehaviour.Properties properties) {
            return (OreBlockBuilder)super.setProperties(properties);
        }

        @Override
        public OreBlockBuilder setInTabs(List<RegistryObject<CreativeModeTab>> tabs) {
            return (OreBlockBuilder)super.setInTabs((List)tabs);
        }

        public RegistryObject<Block> buildSingle() {
            return this.registryHelper.registry.get().register(this.name, () -> new JSGOreBlock(this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry e : toolStateModifiers.entrySet()) {
                            if (!((Predicate)e.getKey()).test(context.m_43722_())) continue;
                            return (BlockState)((Function)e.getValue()).apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public Map<OreBlockVariant, RegistryObject<Block>> buildAll() {
            HashMap<OreBlockVariant, RegistryObject<Block>> result = new HashMap<OreBlockVariant, RegistryObject<Block>>();
            for (OreBlockVariant type : OreBlockVariant.values()) {
                if (type == OreBlockVariant.SELF) continue;
                String nameFinal = (String)(type.prefix != null ? type.prefix + "_" : "") + this.name;
                OreBlockBuilder variantBuilder = new OreBlockBuilder(nameFinal, this);
                RegistryObject<Block> block = variantBuilder.buildSingle();
                result.put(type, block);
            }
            return result;
        }

        public Map<CrystalColor, RegistryObject<Block>> buildCrystalBlock() {
            HashMap<CrystalColor, RegistryObject<Block>> result = new HashMap<CrystalColor, RegistryObject<Block>>();
            for (CrystalColor color : CrystalColor.values()) {
                String nameFinal = this.name.replaceAll("\\{color}", color.name().toLowerCase());
                OreBlockBuilder variantBuilder = new OreBlockBuilder(nameFinal, this);
                RegistryObject<Block> block = variantBuilder.buildGeneric();
                result.put(color, block);
            }
            return result;
        }

        public RegistryObject<Block> buildCrystalBuddingSingle(CrystalColor color) {
            return this.registryHelper.registry.get().register(this.name, () -> new CrystalBuddingBlock(color, this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry e : toolStateModifiers.entrySet()) {
                            if (!((Predicate)e.getKey()).test(context.m_43722_())) continue;
                            return (BlockState)((Function)e.getValue()).apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildCrystalUnstableBuddingSingle(CrystalColor color, Supplier<Block> stableBudding, Supplier<BlockState> originalBlockSupplier) {
            return this.registryHelper.registry.get().register(this.name, () -> new CrystalUnstableBuddingBlock(color, this.properties, stableBudding, originalBlockSupplier){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry e : toolStateModifiers.entrySet()) {
                            if (!((Predicate)e.getKey()).test(context.m_43722_())) continue;
                            return (BlockState)((Function)e.getValue()).apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<Block> buildCrystalBudSingle(CrystalBudType budType, CrystalColor color) {
            return this.registryHelper.registry.get().register(this.name, () -> new CrystalBudBlock(budType, color){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry e : toolStateModifiers.entrySet()) {
                            if (!((Predicate)e.getKey()).test(context.m_43722_())) continue;
                            return (BlockState)((Function)e.getValue()).apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }

        public Map<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> buildCrystalBuddings() {
            HashMap<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> result = new HashMap<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>>();
            for (OreBlockVariant type : OreBlockVariant.values()) {
                HashMap<CrystalColor, RegistryObject<Block>> result2 = new HashMap<CrystalColor, RegistryObject<Block>>();
                for (CrystalColor color : CrystalColor.values()) {
                    String nameFinal = (String)(type.prefix != null ? type.prefix + "_" : "") + this.name.replaceAll("\\{color}", color.name().toLowerCase());
                    OreBlockBuilder variantBuilder = new OreBlockBuilder(nameFinal, this);
                    RegistryObject<Block> block = variantBuilder.buildCrystalBuddingSingle(color);
                    result2.put(color, block);
                }
                result.put(type, result2);
            }
            return result;
        }

        public Map<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> buildCrystalUnstableBuddings(Supplier<Map<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>>> stableBuddings, Supplier<Map<CrystalColor, RegistryObject<Block>>> crystalBlocksSupplier) {
            HashMap<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>> result = new HashMap<OreBlockVariant, Map<CrystalColor, RegistryObject<Block>>>();
            for (OreBlockVariant type : OreBlockVariant.values()) {
                HashMap<CrystalColor, RegistryObject<Block>> result2 = new HashMap<CrystalColor, RegistryObject<Block>>();
                for (CrystalColor color : CrystalColor.values()) {
                    String nameFinal = (String)(type.prefix != null ? type.prefix + "_" : "") + this.name.replaceAll("\\{color}", color.name().toLowerCase());
                    OreBlockBuilder variantBuilder = new OreBlockBuilder(nameFinal, this);
                    RegistryObject<Block> block = variantBuilder.buildCrystalUnstableBuddingSingle(color, () -> (Block)((RegistryObject)((Map)((Map)stableBuddings.get()).get((Object)type)).get((Object)color)).get(), () -> type.getOriginalBlock(color, crystalBlocksSupplier));
                    result2.put(color, block);
                }
                result.put(type, result2);
            }
            return result;
        }

        public Map<CrystalColor, RegistryObject<Block>> buildCrystalBuds(CrystalBudType budType) {
            HashMap<CrystalColor, RegistryObject<Block>> result = new HashMap<CrystalColor, RegistryObject<Block>>();
            for (CrystalColor color : CrystalColor.values()) {
                String nameFinal = this.name.replaceAll("\\{color}", color.name().toLowerCase());
                OreBlockBuilder variantBuilder = new OreBlockBuilder(nameFinal, this);
                RegistryObject<Block> block = variantBuilder.buildCrystalBudSingle(budType, color);
                result.put(color, block);
            }
            return result;
        }
    }
}

