/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry.block;

import dev.tauri.jsg.block.core.SaplingBlockTabbed;
import dev.tauri.jsg.helpers.registry.RegistryHelper;
import dev.tauri.jsg.helpers.registry.RegistryObjectBuilder;
import dev.tauri.jsg.helpers.registry.block.BlockRegistryHelperGeneric;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockRegistryHelperWood
extends RegistryHelper<Block, WoodBlockBuilder> {
    public BlockRegistryHelperWood(Supplier<DeferredRegister<Block>> registry) {
        super(registry, WoodBlockBuilder::new);
    }

    public static class WoodBlockBuilder
    extends BlockRegistryHelperGeneric.GenericBlockBuilder {
        public WoodBlockBuilder(RegistryHelper<Block, WoodBlockBuilder> registryHelper, String name) {
            super(registryHelper, name);
        }

        public WoodBlockBuilder(String name, WoodBlockBuilder other) {
            super(name, other);
        }

        @Override
        public WoodBlockBuilder applyTooltip(@NotNull RegistryObjectBuilder.TooltipApplier<Block> tooltipApplier) {
            return (WoodBlockBuilder)super.applyTooltip(tooltipApplier);
        }

        @Override
        public WoodBlockBuilder clearTooltip() {
            return (WoodBlockBuilder)super.clearTooltip();
        }

        @Override
        public WoodBlockBuilder setFlammability(int flammability) {
            return (WoodBlockBuilder)super.setFlammability(flammability);
        }

        @Override
        public WoodBlockBuilder setFireSpreadSpeed(int fireSpreadSpeed) {
            return (WoodBlockBuilder)super.setFireSpreadSpeed(fireSpreadSpeed);
        }

        @Override
        public WoodBlockBuilder addToolStateModifier(Predicate<ItemStack> toolPredicate, Function<BlockState, BlockState> resultGetter) {
            return (WoodBlockBuilder)super.addToolStateModifier(toolPredicate, resultGetter);
        }

        @Override
        public WoodBlockBuilder setProperties(BlockBehaviour.Properties properties) {
            return (WoodBlockBuilder)super.setProperties(properties);
        }

        @Override
        public WoodBlockBuilder setInTabs(List<RegistryObject<CreativeModeTab>> tabs) {
            return (WoodBlockBuilder)super.setInTabs((List)tabs);
        }

        public RegistryObject<Block> buildSapling(Supplier<AbstractTreeGrower> grower) {
            return this.registryHelper.registry.get().register(this.name, () -> new SaplingBlockTabbed((AbstractTreeGrower)grower.get(), this.properties){

                public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return flammability;
                }

                public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                    return fireSpreadSpeed;
                }

                @Nullable
                public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
                    if (toolStateModifiers != null) {
                        for (Map.Entry e : toolStateModifiers.entrySet()) {
                            if (!((Predicate)e.getKey()).test(context.m_43722_())) continue;
                            return (BlockState)((Function)e.getValue()).apply(state);
                        }
                    }
                    return super.getToolModifiedState(state, context, toolAction, simulate);
                }

                @Override
                public List<RegistryObject<CreativeModeTab>> getTabs() {
                    return tabs;
                }

                @ParametersAreNonnullByDefault
                public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, itemStack, blockGetter, components, tooltipFlag);
                }
            });
        }
    }
}

