/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry.block;

import dev.tauri.jsg.block.crystal.CrystalColor;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public enum OreBlockVariant {
    SAND("sand", () -> ((Block)Blocks.f_50062_).m_49966_(), () -> Blocks.f_50062_),
    NETHER("netherrack", () -> ((Block)Blocks.f_50134_).m_49966_(), () -> Blocks.f_50134_),
    DEEPSLATE("deepslate", () -> ((Block)Blocks.f_152550_).m_49966_(), () -> Blocks.f_152551_),
    END("endstone", () -> ((Block)Blocks.f_50259_).m_49966_(), () -> Blocks.f_50259_),
    STONE(null, () -> ((Block)Blocks.f_50069_).m_49966_(), () -> Blocks.f_50652_),
    SELF("self", null, null);

    @Nullable
    public final String prefix;
    @Nullable
    public final Supplier<BlockState> variantbaseBlockStateSupplier;
    @Nullable
    public final Supplier<ItemLike> drops;

    @ParametersAreNullableByDefault
    private OreBlockVariant(String prefix, Supplier<BlockState> variantbaseBlockStateSupplier, Supplier<ItemLike> drops) {
        this.prefix = prefix;
        this.variantbaseBlockStateSupplier = variantbaseBlockStateSupplier;
        this.drops = drops;
    }

    @Nullable
    public BlockState getOriginalBlock(CrystalColor color, Supplier<Map<CrystalColor, RegistryObject<Block>>> crystalBlocksSupplier) {
        if (this != SELF && this.variantbaseBlockStateSupplier != null) {
            return this.variantbaseBlockStateSupplier.get();
        }
        if (this == SELF) {
            return ((Block)crystalBlocksSupplier.get().get((Object)color).get()).m_49966_();
        }
        return null;
    }

    @Nullable
    public ItemLike getDrop(CrystalColor color, Supplier<Map<CrystalColor, RegistryObject<Block>>> crystalBlocksSupplier) {
        if (this != SELF && this.drops != null) {
            return this.drops.get();
        }
        if (this == SELF) {
            return (ItemLike)crystalBlocksSupplier.get().get((Object)color).get();
        }
        return null;
    }

    @Nullable
    public static OreBlockVariant fromBlock(BlockState state, Supplier<Map<CrystalColor, RegistryObject<Block>>> crystalBlocksSupplier) {
        for (OreBlockVariant v : OreBlockVariant.values()) {
            if (v.variantbaseBlockStateSupplier == null) {
                for (Map.Entry<CrystalColor, RegistryObject<Block>> e : crystalBlocksSupplier.get().entrySet()) {
                    if (!state.m_60713_((Block)e.getValue().get())) continue;
                    return SELF;
                }
                continue;
            }
            if (!state.m_60713_(v.variantbaseBlockStateSupplier.get().m_60734_())) continue;
            return v;
        }
        return null;
    }
}

