/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers.registry.item;

import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.api.item.JSGUpgradeItem;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.api.util.IUpgrade;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.helpers.registry.RegistryHelper;
import dev.tauri.jsg.helpers.registry.RegistryObjectBuilder;
import dev.tauri.jsg.item.JSGSpawnEggItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ItemRegistryHelperGeneric
extends RegistryHelper<Item, GenericItemBuilder> {
    public ItemRegistryHelperGeneric(Supplier<DeferredRegister<Item>> registry) {
        super(registry, GenericItemBuilder::new);
    }

    public static class GenericItemBuilder
    extends RegistryObjectBuilder<RegistryHelper<Item, ? extends GenericItemBuilder>> {
        protected RegistryObjectBuilder.TooltipApplier<Item> tooltipApplier = (item, itemStack, blockGetter, components, tooltipFlag) -> ItemHelper.applyGenericToolTip(item.m_5524_(), components, tooltipFlag);
        protected Item.Properties properties = new Item.Properties();
        protected int maxStack = 64;

        public GenericItemBuilder(RegistryHelper<Item, ? extends GenericItemBuilder> registryHelper, String name) {
            super(registryHelper, name);
        }

        public GenericItemBuilder(String name, GenericItemBuilder other) {
            super(name, other);
            this.tooltipApplier = other.tooltipApplier;
            this.properties = other.properties;
            this.maxStack = other.maxStack;
        }

        public GenericItemBuilder applyTooltip(@NotNull RegistryObjectBuilder.TooltipApplier<Item> tooltipApplier) {
            this.tooltipApplier = tooltipApplier;
            return this;
        }

        public GenericItemBuilder applyTooltip(@Nonnull Supplier<List<Component>> tooltip, @Nullable I18n.AdvancedTooltip tooltipAdvanced) {
            return this.applyTooltip((item, itemStack, blockGetter, components, tooltipFlag) -> ItemHelper.applyToolTip((List)tooltip.get(), tooltipAdvanced, components, tooltipFlag));
        }

        public GenericItemBuilder clearTooltip() {
            this.tooltipApplier = (item, itemStack, blockGetter, components, tooltipFlag) -> {};
            return this;
        }

        public GenericItemBuilder setProperties(Item.Properties properties) {
            this.properties = properties;
            return this;
        }

        public GenericItemBuilder setMaxStack(int maxStack) {
            this.maxStack = maxStack;
            return this;
        }

        public GenericItemBuilder setInTabs(List<RegistryObject<CreativeModeTab>> tabs) {
            return (GenericItemBuilder)super.setInTabs(tabs);
        }

        public RegistryObject<JSGItem> buildGeneric() {
            return this.registryHelper.registry.get().register(this.name, () -> new JSGItem(this.properties.m_41487_(this.maxStack), this.tabs){

                @ParametersAreNonnullByDefault
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, stack, (BlockGetter)level, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<JSGItem> buildUpgrade(Supplier<IUpgrade> upgrade) {
            return this.registryHelper.registry.get().register(this.name, () -> new JSGUpgradeItem(this.properties.m_41487_(this.maxStack), this.tabs, upgrade){

                @ParametersAreNonnullByDefault
                public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
                    tooltipApplier.apply(this, stack, (BlockGetter)level, components, tooltipFlag);
                }
            });
        }

        public RegistryObject<JSGItem> buildDurability(final int durability, final boolean shouldStayInCrafting) {
            return this.registryHelper.registry.get().register(this.name, () -> {
                Item.Properties props = this.properties.m_41487_(this.maxStack);
                if (durability > 0) {
                    props.m_41503_(durability);
                }
                return new JSGItem(props, this.tabs){

                    @ParametersAreNonnullByDefault
                    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
                        return true;
                    }

                    public boolean isDamageable(ItemStack stack) {
                        return true;
                    }

                    @ParametersAreNonnullByDefault
                    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
                        tooltipApplier.apply(this, stack, (BlockGetter)level, components, tooltipFlag);
                        components.add((Component)Component.m_237119_());
                        components.add((Component)Component.m_237113_((String)(String.format("%.2f", (double)(this.getMaxDamage(stack) - this.getDamage(stack)) / (double)this.getMaxDamage(stack) * 100.0) + "%")).m_130940_(ChatFormatting.GRAY));
                    }

                    @Nonnull
                    public ItemStack m_7968_() {
                        ItemStack itemStack = new ItemStack((ItemLike)this);
                        this.setDamage(itemStack, 0);
                        return itemStack;
                    }

                    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
                        return enchantment instanceof DigDurabilityEnchantment;
                    }

                    public int m_6473_() {
                        return 3;
                    }

                    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
                        return shouldStayInCrafting;
                    }

                    public void setDamage(ItemStack stack, int damage) {
                        super.setDamage(stack, damage);
                        if (this.getMaxDamage(stack) <= damage) {
                            stack.m_41764_(0);
                        }
                    }

                    public int getMaxDamage(ItemStack stack) {
                        return durability;
                    }

                    @Nonnull
                    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
                        ItemStack it = itemStack.m_41777_();
                        it.m_41721_(itemStack.m_41773_() + 1);
                        return it;
                    }
                };
            });
        }

        public RegistryObject<JSGSpawnEggItem> buildSpawnEgg(Supplier<? extends EntityType<? extends Mob>> entityType, int color1, int color2) {
            return this.registryHelper.registry.get().register(this.name, () -> new JSGSpawnEggItem(entityType, color1, color2, this.properties));
        }
    }
}

