/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.integration.ComputerDeviceProvider;
import dev.tauri.jsg.api.integration.IComputerDeviceHolder;
import dev.tauri.jsg.integration.cctweaked.methods.ICCDevice;
import dev.tauri.jsg.integration.oc2.methods.IOCDevice;
import java.util.Optional;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ComputerDeviceHolder
implements IComputerDeviceHolder {
    private LazyOptional<ICCDevice> ccDevice = LazyOptional.empty();
    private LazyOptional<IOCDevice> ocDevice = LazyOptional.empty();
    public final ComputerDeviceProvider provider;

    public ComputerDeviceHolder(ComputerDeviceProvider provider) {
        this.provider = provider;
    }

    public <T> LazyOptional<T> getOrCreateDeviceBasedOnCap(Capability<T> cap) {
        LazyOptional<T> cc = this.getOrCreateCCDevice(cap);
        if (cc.isPresent()) {
            return cc;
        }
        LazyOptional<T> oc = this.getOrCreateOCDevice(cap);
        if (oc.isPresent()) {
            return oc;
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getOrCreateCCDevice(Capability<T> cap) {
        if (!JSG.ccWrapper.isLoaded()) {
            return LazyOptional.empty();
        }
        if (JSG.ccWrapper.checkCaps(cap)) {
            if (this.ccDevice.isPresent()) {
                return this.ccDevice.cast();
            }
            this.ccDevice = JSG.ccWrapper.createDevice(cap, this.provider, this.provider.getDeviceType());
            return this.ccDevice.cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getOrCreateOCDevice(Capability<T> cap) {
        if (!JSG.ocWrapper.isLoaded()) {
            return LazyOptional.empty();
        }
        if (JSG.ocWrapper.checkCaps(cap)) {
            if (this.ocDevice.isPresent()) {
                return this.ocDevice.cast();
            }
            this.ocDevice = JSG.ocWrapper.createDevice(cap, this.provider, this.provider.getDeviceType());
            return this.ocDevice.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void sendSignal(String eventName, Object ... objects) {
        this.sendSignalCC(eventName, objects);
        this.sendSignalOC(eventName, objects);
    }

    public void connectToWirelessNetwork() {
        this.connectToWirelessNetworkCC();
    }

    public void disconnectFromWirelessNetwork() {
        this.disconnectFromWirelessNetworkCC();
    }

    public void sendSignalCC(String eventName, Object ... objects) {
        Optional<Capability<?>> caps = JSG.ccWrapper.getCaps();
        if (caps.isEmpty()) {
            return;
        }
        LazyOptional<?> opt = this.getOrCreateCCDevice(caps.get());
        if (!opt.isPresent()) {
            return;
        }
        Object peripheral = opt.resolve().orElseThrow();
        if (!(peripheral instanceof ICCDevice)) {
            return;
        }
        ICCDevice device = (ICCDevice)peripheral;
        device.sendSignal(eventName, objects);
    }

    public void sendSignalOC(String eventName, Object ... objects) {
        Optional<Capability<?>> caps = JSG.ocWrapper.getCaps();
        if (caps.isEmpty()) {
            return;
        }
        LazyOptional<?> opt = this.getOrCreateCCDevice(caps.get());
        if (!opt.isPresent()) {
            return;
        }
        Object peripheral = opt.resolve().orElseThrow();
        if (!(peripheral instanceof IOCDevice)) {
            return;
        }
        IOCDevice device = (IOCDevice)peripheral;
        device.sendSignal(eventName, objects);
    }

    public void connectToWirelessNetworkCC() {
        Optional<Capability<?>> caps = JSG.ccWrapper.getCaps();
        if (caps.isEmpty()) {
            return;
        }
        LazyOptional<?> opt = this.getOrCreateCCDevice(caps.get());
        if (!opt.isPresent()) {
            return;
        }
        Object peripheral = opt.resolve().orElseThrow();
        if (!(peripheral instanceof ICCDevice)) {
            return;
        }
        ICCDevice device = (ICCDevice)peripheral;
        device.connectToWirelessNetwork();
    }

    public void disconnectFromWirelessNetworkCC() {
        Optional<Capability<?>> caps = JSG.ccWrapper.getCaps();
        if (caps.isEmpty()) {
            return;
        }
        LazyOptional<?> opt = this.getOrCreateCCDevice(caps.get());
        if (!opt.isPresent()) {
            return;
        }
        Object peripheral = opt.resolve().orElseThrow();
        if (!(peripheral instanceof ICCDevice)) {
            return;
        }
        ICCDevice device = (ICCDevice)peripheral;
        device.disconnectFromWirelessNetwork();
    }
}

