/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.cctweaked.methods;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dev.tauri.jsg.api.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.integration.cctweaked.CCDevice;
import dev.tauri.jsg.integration.cctweaked.CCTweakedHelper;
import dev.tauri.jsg.integration.cctweaked.methods.AbstractCCMethods;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StargateAbstractCCMethods<T extends StargateAbstractBaseBE<?, ?>>
extends AbstractCCMethods<T> {
    public StargateAbstractCCMethods(BlockEntity gateTile) {
        this((StargateAbstractBaseBE)gateTile, CCDevice.STARGATE_ABSTRACT);
    }

    public StargateAbstractCCMethods(T gateTile, CCDevice device) {
        super(gateTile, device);
    }

    @LuaFunction(mainThread=true)
    public final Object[] getOpenedTime() {
        if (((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getStargateState().engaged()) {
            float openedSeconds = ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getConnection().getSecondsOpen();
            int minutes = (int)Math.floor(openedSeconds / 60.0f);
            int seconds = (int)(openedSeconds - (float)(60 * minutes));
            if (openedSeconds > 0.0f) {
                return new Object[]{true, "stargate_time", minutes, seconds};
            }
            return new Object[]{false, "stargate_not_connected"};
        }
        return new Object[]{false, "stargate_not_connected"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getStargateAddress() {
        HashMap<String, List<String>> a = new HashMap<String, List<String>>();
        for (AbstractSymbolType<?> symbolType : AbstractSymbolType.values(SymbolUsage.STARGATES)) {
            StargateAddress address = ((StargateAbstractBaseBE)this.deviceTile).getStargateAddress(symbolType);
            if (address == null) continue;
            a.put(symbolType.getId(), address.getNameList());
        }
        return new Object[]{a};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getDialedAddress() {
        return new Object[]{((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getDialedAddress().getNameList()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getEnergyStored() {
        return new Object[]{((StargateAbstractBaseBE)this.deviceTile).getEnergyManager().getStorage().getEnergyStored()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getMaxEnergyStored() {
        return new Object[]{((StargateAbstractBaseBE)this.deviceTile).getEnergyManager().getStorage().getMaxEnergyStored()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getGateType() {
        return new Object[]{((StargateAbstractBaseBE)this.deviceTile).isMerged() ? ((StargateAbstractBaseBE)this.deviceTile).getStargateType().toString() : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSymbolType() {
        return new Object[]{((StargateAbstractBaseBE)this.deviceTile).isMerged() ? ((StargateAbstractBaseBE)this.deviceTile).getSymbolType().getId() : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSymbolsMap() {
        return new Object[]{((StargateAbstractBaseBE)this.deviceTile).isMerged() ? Arrays.stream(((StargateAbstractBaseBE)this.deviceTile).getSymbolType().getValues()).map(SymbolInterface::getEnglishName).toList() : null};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getGateStatus() {
        if (!((StargateAbstractBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "not_merged"};
        }
        if (((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getStargateState().engaged()) {
            return new Object[]{true, "open", ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getStargateState().initiating()};
        }
        return new Object[]{true, ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getStargateState().toString().toLowerCase()};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSymbolsNeeded(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateAbstractBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(((StargateAbstractBaseBE)this.deviceTile).getSymbolType());
        List<Object> symbols = CCTweakedHelper.getCorrectlyOrderedTableValues(args.getTable(0));
        for (Object symbolObj : symbols) {
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = ((StargateAbstractBaseBE)this.deviceTile).getSymbolFromNameIndex(symbolObj);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{false, "address_malformed"};
        }
        if (!((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).canDialAddress(stargateAddress)) {
            return new Object[]{false, "address_malformed"};
        }
        StargatePos pos = StargateNetwork.INSTANCE.getStargate(stargateAddress);
        if (pos == null) {
            return new Object[]{false, "gate_not_found"};
        }
        int symbolsCount = ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).getMinimalSymbolsToDial(pos.getGateSymbolType(), pos);
        return new Object[]{true, "symbols_needed", symbolsCount};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getEnergyRequiredToDial(ILuaContext ctx, IArguments args) throws LuaException {
        if (!((StargateAbstractBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(((StargateAbstractBaseBE)this.deviceTile).getSymbolType());
        List<Object> symbols = CCTweakedHelper.getCorrectlyOrderedTableValues(args.getTable(0));
        for (Object symbolObj : symbols) {
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = ((StargateAbstractBaseBE)this.deviceTile).getSymbolFromNameIndex(symbolObj);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{false, "address_malformed"};
        }
        if (!((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.deviceTile).getDialingManager()).canDialAddress(stargateAddress)) {
            return new Object[]{false, "address_malformed"};
        }
        EnergyRequiredToOperate energyRequired = ((StargateEnergyManager)((StargateAbstractBaseBE)this.deviceTile).getEnergyManager()).getEnergyRequiredToDial(Objects.requireNonNull(StargateNetwork.INSTANCE.getStargate(stargateAddress)), stargateAddress);
        HashMap<String, Constable> energyMap = new HashMap<String, Constable>();
        energyMap.put("open", Integer.valueOf(energyRequired.energyToOpen));
        energyMap.put("keepAlive", Integer.valueOf(energyRequired.keepAlive));
        energyMap.put("canOpen", Boolean.valueOf(((StargateAbstractBaseBE)this.deviceTile).getEnergyManager().getStorage().getEnergyStored() >= energyRequired.energyToOpen));
        return new Object[]{true, "energy_map", energyMap};
    }
}

