/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.oc2.methods;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.integration.ComputerDeviceProvider;
import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.NearbyGate;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.animation.EnumSpinDirection;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.stargate.iris.codesender.ComputerCodeSender;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.integration.oc2.OCDevice;
import dev.tauri.jsg.integration.oc2.methods.AbstractOCMethods;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import li.cil.oc2.api.bus.device.object.Callback;
import net.minecraft.network.chat.Component;

public class StargateClassicOCMethods
extends AbstractOCMethods<StargateClassicBaseBE<?>> {
    public StargateClassicOCMethods(ComputerDeviceProvider deviceTile) {
        super((StargateClassicBaseBE)deviceTile, OCDevice.STARGATE_CLASSIC);
    }

    @Callback(name="toggleIris")
    public final Object[] toggleIris() {
        if (((StargateClassicBaseBE)this.deviceTile).getIrisManager().getIrisType() == EnumIrisType.NULL) {
            return new Object[]{false, "stargate_iris_missing", "Iris is not installed!"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getIrisManager().getIrisMode() != EnumIrisMode.OC) {
            return new Object[]{false, "stargate_iris_error_mode", "Iris mode must be set to OC"};
        }
        boolean result = ((StargateClassicBaseBE)this.deviceTile).getIrisManager().toggleIris();
        ((StargateClassicBaseBE)this.deviceTile).m_6596_();
        if (!result && ((StargateClassicBaseBE)this.deviceTile).getIrisManager().hasShield() && ((StargateClassicBaseBE)this.deviceTile).getIrisManager().isIrisOpened() && ((LargeEnergyStorage)((Object)((StargateClassicBaseBE)this.deviceTile).getEnergyManager().getStorage())).getEnergyStored() < JSGConfig.Stargate.irisShieldPowerDraw.get() * 3) {
            return new Object[]{false, "stargate_iris_not_power", "Not enough power to close shield"};
        }
        if (!result) {
            return new Object[]{false, "stargate_iris_busy", "Iris is busy"};
        }
        return new Object[]{true};
    }

    @Callback(name="getIrisState")
    public final Object[] getIrisState() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getIrisManager().getIrisState().toString()};
    }

    @Callback(name="getIrisType")
    public final Object[] getIrisType() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).getIrisManager().getIrisType().toString()};
    }

    @Callback(name="getIrisDurability")
    public final Object[] getIrisDurability() {
        int damage = ((StargateClassicBaseBE)this.deviceTile).getIrisManager().getIrisItem().m_41773_();
        int irisDurability = ((StargateClassicBaseBE)this.deviceTile).getIrisManager().getIrisItem().m_41776_();
        return new Object[]{irisDurability - damage + "/" + irisDurability, irisDurability - damage, irisDurability};
    }

    @Callback(name="sendMessageToIncoming")
    public final Object[] sendMessageToIncoming(String message) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().engaged()) {
            return new Object[]{false, "stargate_failure_not_engaged", "Stargate is not engaged"};
        }
        if (((StargateClassicBaseBE)this.deviceTile).getIrisManager().getCodeSender() != null && ((StargateClassicBaseBE)this.deviceTile).getIrisManager().getCodeSender().canReceiveMessage()) {
            ((StargateClassicBaseBE)this.deviceTile).getIrisManager().getCodeSender().sendMessage((Component)Component.m_237113_((String)message));
            return new Object[]{true, "success"};
        }
        return new Object[]{false, "no_listener_available"};
    }

    @Callback(name="sendIrisCode")
    public final Object[] sendIrisCode(String code) {
        if (code == null) {
            return new Object[]{false, "invalid_method_format", "You must enter code!"};
        }
        StargatePos destinationPos = StargateNetwork.INSTANCE.getStargate(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getDialedAddress());
        if (destinationPos == null) {
            return new Object[]{false, "stargate_not_engaged"};
        }
        Stargate<?> te = destinationPos.getStargate();
        if (!(te instanceof StargateClassicBaseBE)) {
            return new Object[]{false, "invalid_target_gate"};
        }
        StargateClassicBaseBE classicTile = (StargateClassicBaseBE)te;
        classicTile.receiveIrisCode(new ComputerCodeSender(StargateNetwork.INSTANCE.getStargate(((StargateClassicBaseBE)this.deviceTile).getStargateAddress(SymbolTypeRegistry.MILKYWAY))), code);
        return new Object[]{true, "success"};
    }

    @Callback(name="abortDialing")
    public final Object[] abortDialing() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).abortDialingSequence()) {
            ((StargateClassicBaseBE)this.deviceTile).m_6596_();
            return new Object[]{true, "stargate_aborting", "Aborting dialing"};
        }
        return new Object[]{false, "stargate_aborting_failed", "Aborting dialing failed"};
    }

    @Callback(name="engageGate")
    public final Object[] engageGate() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().idle()) {
            StargateOpenResult gateState = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).attemptOpenDialed();
            if (gateState.ok()) {
                return new Object[]{true, "stargate_engage"};
            }
            return new Object[]{false, "stargate_failure_opening", "Stargate failed to open", gateState.toString()};
        }
        return new Object[]{false, "stargate_failure_busy", "Stargate is busy", ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().toString()};
    }

    @Callback(name="disengageGate")
    public final Object[] disengageGate() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().engaged()) {
            if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().initiating()) {
                ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).attemptClose(StargateClosedReasonEnum.REQUESTED);
                return new Object[]{true, "stargate_disengage", "Stargate closed!"};
            }
            return new Object[]{false, "stargate_failure_wrong_end", "Unable to close the gate on this end"};
        }
        return new Object[]{false, "stargate_failure_not_open", "The gate is closed"};
    }

    @Callback(name="engageSymbol")
    public final Object[] engageSymbol(Object symbol) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().idle()) {
            return new Object[]{false, "stargate_failure_busy", "Stargate is busy", ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().name().toLowerCase()};
        }
        if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getDialedAddress().size() == 9) {
            return new Object[]{false, "stargate_failure_full", "Already dialed 9 chevrons"};
        }
        if (symbol == null) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        SymbolInterface targetSymbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbol);
        if (!targetSymbol.isValidForAddress() && !targetSymbol.origin()) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).engageSymbolBySpin(targetSymbol, false, false);
        ((StargateClassicBaseBE)this.deviceTile).m_6596_();
        return new Object[]{true, "stargate_spin"};
    }

    @Callback(name="dialAddress")
    public final Object[] dialAddress(Object ... symbols) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState().idle()) {
            return new Object[]{false, "stargate_failure_busy", "Stargate is busy, state: " + String.valueOf((Object)((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState())};
        }
        if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getDialedAddress().size() > 0) {
            return new Object[]{false, "stargate_failure_not_empty", "Dialed address is not empty"};
        }
        if (symbols.length < 7) {
            return new Object[]{false, "input_address_malformed", "Input address is malformed"};
        }
        int maxSymbols = Math.min(symbols.length, 9);
        StargateAddressDynamic address = new StargateAddressDynamic(((StargateClassicBaseBE)this.deviceTile).getSymbolType());
        for (int i = 0; i < maxSymbols; ++i) {
            SymbolInterface symbol = ((StargateClassicBaseBE)this.deviceTile).getSymbolFromNameIndex(symbols[i]);
            if (!symbol.isValidForAddress() && !symbol.origin()) {
                throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
            }
            address.addSymbol(symbol);
        }
        ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).dialAddress(address, false, false, EnumDialingType.NORMAL);
        return new Object[]{true, "dial_begun", address.toString()};
    }

    @Callback(name="spinRing")
    public final Object[] spinRing(boolean counterClockwise) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle to spin its ring"};
        }
        if (((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState().isOpenedAny()) {
            return new Object[]{false, "stargate_locked", "Some chevrons are opened, so you cannot spin gate!"};
        }
        EnumSpinDirection direction = counterClockwise ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
        boolean result = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().rotateFreely(direction);
        if (!result) {
            return new Object[]{false, "stargate_ring_already_spinning", "Stargate ring is already spinning!"};
        }
        return new Object[]{true, "stargate_ring_spin", "Ring is now spinning..."};
    }

    @Callback(name="stopRingSpin")
    public final Object[] stopRingSpin() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle to spin its ring"};
        }
        boolean result = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().stopSpinning(true);
        if (!result) {
            return new Object[]{false, "stargate_ring_not_spinning", "Stargate ring is not spinning!"};
        }
        return new Object[]{true, "stargate_ring_spin_stop", "Ring is now stopping..."};
    }

    @Callback(name="isSpinning")
    public final Object[] isSpinning() {
        return new Object[]{((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().isSpinning(), Float.valueOf(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getRingVelocity())};
    }

    @Callback(name="getTopSymbol")
    public final Object[] getTopSymbol() {
        SymbolInterface s = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getCurrentTopSymbol();
        if (s == null) {
            return new Object[]{false};
        }
        return new Object[]{true, s.getId(), s.getEnglishName(), Float.valueOf(s.getAngle()), s.origin(), Float.valueOf(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getRingAngle())};
    }

    @Callback(name="getRingAngle")
    public final Object[] getRingAngle() {
        float angle = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getRingAngle();
        if (angle < 0.0f) {
            return new Object[]{false};
        }
        return new Object[]{true, Float.valueOf(angle)};
    }

    @Callback(name="engageTopSymbol")
    public final Object[] engageTopSymbol() {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle!"};
        }
        StargateChevronEngageResult result = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).engageCurrentSymbol();
        if (result.ok()) {
            return new Object[]{true, "chevron_engaged", "Chevron engaged"};
        }
        return new Object[]{false, "chevron_engage_error", result.name()};
    }

    @Callback(name="openChevron")
    public final Object[] openChevron(Optional<Integer> chevronIndex) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle!"};
        }
        ChevronEnum chevron = chevronIndex.map(ChevronEnum::valueOf).orElse(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getNextChevron(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getCurrentTopSymbol(), false, false));
        StargateChevronsState chevronStates = ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState();
        StargateChevronsState.ChevronState chevronState = chevronStates.get(chevron);
        if (chevronState.isOpen()) {
            return new Object[]{false, "chevron_already_open", "Target chevron is already open!"};
        }
        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState().scheduleChevronOpen(0, chevron, false);
        return new Object[]{true, "chevron_open", "Chevron is opening..."};
    }

    @Callback(name="getChevronStatus")
    public final Object[] getChevronStatus(int chevronIndex) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged"};
        }
        Optional<ChevronEnum> chevron = Optional.ofNullable(ChevronEnum.valueOf(chevronIndex));
        if (chevron.isEmpty()) {
            return new Object[]{false, "chevron_not_found"};
        }
        StargateChevronsState chevronStates = ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState();
        StargateChevronsState.ChevronState chevronState = chevronStates.get(chevron.get());
        return new Object[]{true, "chevron_status", chevronState.isOpen(), chevronState.isLocked()};
    }

    @Callback(name="closeChevron")
    public final Object[] closeChevron(Optional<Integer> chevronIndex) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle!"};
        }
        ChevronEnum chevron = chevronIndex.map(ChevronEnum::valueOf).orElse(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getNextChevron(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getCurrentTopSymbol(), false, false));
        StargateChevronsState chevronStates = ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState();
        StargateChevronsState.ChevronState chevronState = chevronStates.get(chevron);
        if (!chevronState.isOpen()) {
            return new Object[]{false, "chevron_already_closed", "Target chevron is already closed!"};
        }
        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState().scheduleChevronClose(0, chevron, false);
        return new Object[]{true, "chevron_close", "Chevron is closing..."};
    }

    @Callback(name="activateChevron")
    public final Object[] activateChevron(Optional<Integer> chevronIndex) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle!"};
        }
        ChevronEnum chevron = chevronIndex.map(ChevronEnum::valueOf).orElse(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getNextChevron(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getCurrentTopSymbol(), false, false));
        StargateChevronsState chevronStates = ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState();
        StargateChevronsState.ChevronState chevronState = chevronStates.get(chevron);
        if (chevronState.isLocked()) {
            return new Object[]{false, "chevron_already_activated", "Target chevron is already activated!"};
        }
        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState().scheduleChevronActivate(0, chevron, null, false);
        return new Object[]{true, "chevron_activate", "Chevron is activating..."};
    }

    @Callback(name="deactivateChevron")
    public final Object[] deactivateChevron(Optional<Integer> chevronIndex) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "stargate_not_merged", "Stargate must be merged!"};
        }
        EnumStargateState state = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getStargateState();
        if (!state.idle()) {
            return new Object[]{false, "stargate_busy", "Stargate must be idle!"};
        }
        ChevronEnum chevron = chevronIndex.map(ChevronEnum::valueOf).orElse(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getNextChevron(((StargateAbstractDialingManager)((StargateClassicBaseBE)this.deviceTile).getDialingManager()).getSpinHelper().getCurrentTopSymbol(), false, false));
        StargateChevronsState chevronStates = ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState();
        StargateChevronsState.ChevronState chevronState = chevronStates.get(chevron);
        if (!chevronState.isLocked()) {
            return new Object[]{false, "chevron_already_deactivated", "Target chevron is already deactivated!"};
        }
        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.deviceTile).getStateManager()).getChevronsState().scheduleChevronDim(0, chevron, false);
        return new Object[]{true, "chevron_deactivate", "Chevron is deactivating..."};
    }

    @Callback(name="getCapacitorsInstalled")
    public final Object[] getCapacitorsInstalled() {
        return new Object[]{((StargateClassicBaseBE)this.deviceTile).isMerged() ? Integer.valueOf(((StargateClassicBaseBE)this.deviceTile).currentPowerTier - 1) : null};
    }

    @Callback(name="getNearbyGates")
    public final Object[] getNearbyGates(String gateTypeString, boolean ignoreGateType, boolean checkAddressAndEnergy) {
        if (!((StargateClassicBaseBE)this.deviceTile).isMerged()) {
            return new Object[]{false, "gate_not_merged", new HashMap()};
        }
        HashMap<String, Map> map = new HashMap<String, Map>();
        StargateType gateType = StargateType.valueOf(gateTypeString);
        for (NearbyGate g : ((StargateClassicBaseBE)this.deviceTile).getNearbyGates(gateType, !ignoreGateType, checkAddressAndEnergy)) {
            Map map2 = map.computeIfAbsent(g.gateType.toString(), k -> new HashMap());
            map2.put(g.address.getNameList(), g.symbolsNeeded);
            map.put(g.gateType.toString(), map2);
        }
        return new Object[]{true, "success", map};
    }
}

