/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.core;

import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.entity.vehicle.JSGBoat;
import dev.tauri.jsg.entity.vehicle.JSGBoatTypeWrapper;
import dev.tauri.jsg.entity.vehicle.JSGChestBoat;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BoatItem<T extends Enum<T>>
extends JSGItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final T type;
    private final boolean hasChest;
    public final JSGBoatTypeWrapper<T> boatTypeWrapper;
    public final Supplier<? extends EntityType<? extends JSGBoat<?>>> boatEntityTypeSupplier;
    public final Supplier<? extends EntityType<? extends JSGChestBoat<?>>> chestBoatEntityTypeSupplier;

    public static <T extends Enum<T>> BoatItem<T> createNormal(Supplier<? extends EntityType<? extends JSGBoat<?>>> boatEntityTypeSupplier, JSGBoatTypeWrapper<T> boatTypeWrapper, T pType, Item.Properties pProperties, List<RegistryObject<CreativeModeTab>> tabs) {
        return new BoatItem<T>(boatEntityTypeSupplier, () -> null, boatTypeWrapper, false, pType, pProperties, tabs);
    }

    public static <T extends Enum<T>> BoatItem<T> createChest(Supplier<? extends EntityType<? extends JSGChestBoat<?>>> chestBoatEntityTypeSupplier, JSGBoatTypeWrapper<T> boatTypeWrapper, T pType, Item.Properties pProperties, List<RegistryObject<CreativeModeTab>> tabs) {
        return new BoatItem<T>(() -> null, chestBoatEntityTypeSupplier, boatTypeWrapper, true, pType, pProperties, tabs);
    }

    private BoatItem(Supplier<? extends EntityType<? extends JSGBoat<?>>> boatEntityTypeSupplier, Supplier<? extends EntityType<? extends JSGChestBoat<?>>> chestBoatEntityTypeSupplier, JSGBoatTypeWrapper<T> boatTypeWrapper, boolean pHasChest, T pType, Item.Properties pProperties, List<RegistryObject<CreativeModeTab>> tabs) {
        super(pProperties, tabs);
        this.hasChest = pHasChest;
        this.type = pType;
        this.boatTypeWrapper = boatTypeWrapper;
        this.boatEntityTypeSupplier = boatEntityTypeSupplier;
        this.chestBoatEntityTypeSupplier = chestBoatEntityTypeSupplier;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult hitresult = BoatItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f);
        List list = pLevel.m_6249_((Entity)pPlayer, pPlayer.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = pPlayer.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(pLevel, (HitResult)hitresult);
            boat.m_146922_(pPlayer.m_146908_());
            if (!pLevel.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!pLevel.f_46443_) {
                pLevel.m_7967_((Entity)boat);
                pLevel.m_220400_((Entity)pPlayer, GameEvent.f_157810_, hitresult.m_82450_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private Boat getBoat(Level level, HitResult hit) {
        if (this.hasChest) {
            JSGChestBoat<T> boat = new JSGChestBoat<T>(this.boatTypeWrapper, this.chestBoatEntityTypeSupplier.get(), level, hit.m_82450_().f_82479_, hit.m_82450_().f_82480_, hit.m_82450_().f_82481_);
            boat.setVariant(this.type);
            return boat;
        }
        JSGBoat<T> boat = new JSGBoat<T>(this.boatTypeWrapper, this.boatEntityTypeSupplier.get(), level, hit.m_82450_().f_82479_, hit.m_82450_().f_82480_, hit.m_82450_().f_82481_);
        boat.setVariant(this.type);
        return boat;
    }
}

