/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer.modes;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.stargate.NearbyGate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.item.linkable.HandHeldDeviceUtils;
import dev.tauri.jsg.item.linkable.dialer.IUniverseDialerScreen;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerClientActionEnum;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.item.linkable.dialer.modes.screen.UDEntriesScreen;
import dev.tauri.jsg.packet.packets.linkable.UniverseDialerActionPacketToServer;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class UDNearbyMode
extends UniverseDialerMode {
    public static final String C_SELECTED = "selected";
    public static final String C_ENTRIES = "entries";
    public static final String C_STATUS = "gateStatus";
    public static final String C_DIALED = "dialedAddress";
    public static final String C_TO_DIAL = "toDialAddress";
    public static final String C_E_NAME = "name";
    public static final String C_E_SYMBOLS = "symbolsToDisplay";
    private final UDEntriesScreen screen = new UDEntriesScreen();

    public UDNearbyMode() {
        super(JSG.rl("nearby"), "item.jsg.universe_dialer.mode_scan", JSGBlockTags.DIALER_NEARBY_LINKABLE, (level, pos) -> {
            StargateUniverseBaseBE uniBE;
            BlockEntity patt2994$temp = level.m_7702_(pos);
            return patt2994$temp instanceof StargateUniverseBaseBE && (uniBE = (StargateUniverseBaseBE)patt2994$temp).isMerged();
        });
    }

    public UDNearbyMode(ResourceLocation id, String title, @Nullable TagKey<Block> matchBlocks, BiPredicate<Level, BlockPos> linkMatchTest) {
        super(id, title, matchBlocks, linkMatchTest);
    }

    @Override
    @NotNull
    public IUniverseDialerScreen getScreen() {
        return this.screen;
    }

    @Override
    public void inventoryTick(ItemStack stack, CompoundTag compound, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, compound, world, entity, itemSlot, isSelected);
        if (!compound.m_128441_(C_SELECTED) || compound.m_128445_(C_SELECTED) < 0) {
            compound.m_128344_(C_SELECTED, (byte)0);
        }
        if (compound.m_128445_(C_SELECTED) > 0 && compound.m_128445_(C_SELECTED) >= compound.m_128437_(C_ENTRIES, 10).size()) {
            compound.m_128344_(C_SELECTED, (byte)(compound.m_128437_(C_ENTRIES, 10).size() - 1));
        }
        if (!compound.m_128441_("linkedPos")) {
            return;
        }
        BlockPos linkedPos = BlockPos.m_122022_((long)compound.m_128454_("linkedPos"));
        StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)world.m_7702_(linkedPos);
        if (gateTile == null) {
            return;
        }
        HandHeldDeviceUtils.addrToBytes(((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddress(), compound, C_DIALED);
        ((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialingSequence().ifPresentOrElse(s -> HandHeldDeviceUtils.addrToBytes((StargateAddressDynamic)s.getOriginalAddress(), compound, C_TO_DIAL), () -> {
            if (((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddressSize() > 0) {
                HandHeldDeviceUtils.addrToBytes(((StargateAbstractDialingManager)gateTile.getDialingManager()).getDialedAddress(), compound, C_TO_DIAL);
            } else {
                HandHeldDeviceUtils.addrToBytes(new StargateAddressDynamic(gateTile.getSymbolType()), compound, C_TO_DIAL);
            }
        });
        compound.m_128405_(C_STATUS, ((StargateAbstractDialingManager)gateTile.getDialingManager()).getStargateState().ordinal());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onLinkUpdated(boolean isLinked, BlockPos linkedPos, CompoundTag compound, ItemStack stack, ServerLevel world, Entity entity) {
        super.onLinkUpdated(isLinked, linkedPos, compound, stack, world, entity);
        ListTag nearbyList = new ListTag();
        if (!isLinked) {
            compound.m_128365_(C_ENTRIES, (Tag)nearbyList);
            return;
        }
        StargateClassicBaseBE gateTile = (StargateClassicBaseBE)world.m_7702_(linkedPos);
        if (gateTile == null) {
            return;
        }
        ArrayList<NearbyGate> nearbyGates = gateTile.getNearbyGates(StargateTypes.UNIVERSE, true, false);
        for (NearbyGate gate : nearbyGates) {
            CompoundTag entryCompound = gate.address.serializeNBT();
            entryCompound.m_128385_(C_E_SYMBOLS, gate.getSymbolsToDisplay());
            nearbyList.add((Object)entryCompound);
        }
        compound.m_128365_(C_ENTRIES, (Tag)nearbyList);
    }

    @Override
    public void handlePacketToServer(UniverseDialerClientActionEnum action, CompoundTag compound, UniverseDialerActionPacketToServer packet, NetworkEvent.Context ctx) {
        if (action != UniverseDialerClientActionEnum.ADDRESS_CHANGE) {
            return;
        }
        byte selected = compound.m_128445_(C_SELECTED);
        int addressCount = compound.m_128437_(C_ENTRIES, 10).size();
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        if (packet.next && selected < addressCount - 1) {
            compound.m_128344_(C_SELECTED, (byte)(selected + 1));
            JSGSoundHelper.playSoundToPlayer(player, SoundEvent.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
            return;
        }
        if (!packet.next && selected > 0) {
            compound.m_128344_(C_SELECTED, (byte)(selected - 1));
            JSGSoundHelper.playSoundToPlayer(player, SoundEvent.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean onUse(CompoundTag compound, ItemStack stack, Level world, Player player, InteractionHand hand, boolean shift) {
        StargateUniverseBaseBE gateTile;
        if (world.f_46443_) {
            return false;
        }
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        byte selectedEntry = compound.m_128445_(C_SELECTED);
        BlockPos linkedPos = BlockPos.m_122022_((long)compound.m_128454_("linkedPos"));
        ListTag entries = compound.m_128437_(C_ENTRIES, 10);
        BlockEntity linkedTe = world.m_7702_(linkedPos);
        if (!(linkedTe instanceof StargateUniverseBaseBE) || !(gateTile = (StargateUniverseBaseBE)linkedTe).isMerged()) {
            return false;
        }
        if (shift && gateTile.getIrisManager().hasIris() && gateTile.getIrisManager().getIrisMode() == EnumIrisMode.DIALER) {
            gateTile.getIrisManager().toggleIris();
            return true;
        }
        if (selectedEntry >= entries.size()) {
            return false;
        }
        CompoundTag selectedCompound = entries.m_128728_((int)selectedEntry);
        switch (((StargateAbstractDialingManager)gateTile.getDialingManager()).getStargateState()) {
            case IDLE: {
                if (((StargateAbstractDialingManager)gateTile.getDialingManager()).canAbortDialing() && ((StargateAbstractDialingManager)gateTile.getDialingManager()).abortDialingSequence()) {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                    JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                    break;
                }
                int[] symbolsToDisplay = selectedCompound.m_128465_(C_E_SYMBOLS);
                StargateAddress address = new StargateAddress(selectedCompound);
                ArrayList<SymbolInterface> symbolsToDial = new ArrayList<SymbolInterface>();
                for (int s : symbolsToDisplay) {
                    if (s == 9) continue;
                    symbolsToDial.add(address.get(s - 1));
                }
                StargateAddressDynamic addressToDial = new StargateAddressDynamic(address.getSymbolType());
                addressToDial.addAll(symbolsToDial);
                addressToDial = addressToDial.addOriginIfMissingAndImmutable();
                Boolean fastDial = gateTile.getConfig().getValueOrDefault(StargateConfigOptions.Universe.FAST_DIALING);
                ((StargateAbstractDialingManager)gateTile.getDialingManager()).dialAddress(addressToDial, false, false, fastDial != false ? EnumDialingType.FAST : EnumDialingType.REMOTE);
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.dial_start"), true);
                JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                break;
            }
            case ENGAGED_INITIATING: {
                ((StargateAbstractDialingManager)gateTile.getDialingManager()).attemptClose(StargateClosedReasonEnum.REQUESTED);
                JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                break;
            }
            case ENGAGED: {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"tile.jsg.dhd_block.incoming_wormhole_warn"), true);
                JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
                break;
            }
            default: {
                if (((StargateAbstractDialingManager)gateTile.getDialingManager()).abortDialingSequence()) {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                    JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
                    break;
                }
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.gate_busy"), true);
                JSGSoundHelper.playSoundToPlayer(serverPlayer, SoundEvent.UNIVERSE_DIALER_ERROR, player.m_20183_());
            }
        }
        return true;
    }
}

