/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.gdo;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.api.stargate.iris.codesender.CodeSender;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.helpers.LinkingHelper;
import dev.tauri.jsg.item.linkable.gdo.GarageDoorOpenerBEWLR;
import dev.tauri.jsg.registry.TabRegistry;
import dev.tauri.jsg.registry.tags.JSGBlockTags;
import dev.tauri.jsg.screen.gui.GDOVirtualGui;
import dev.tauri.jsg.screen.provider.GDOVirtualGuiProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class GDOItem
extends JSGItem {
    public GDOItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON), TabRegistry.TAB_TOOLS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final GarageDoorOpenerBEWLR instance = new GarageDoorOpenerBEWLR();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return instance;
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean sendCode(ItemStack stack, CodeSender sender) {
        BlockEntity blockEntity;
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128441_("linked_gate_pos")) {
            return false;
        }
        double signal = compound.m_128459_("signal_strength");
        if (signal <= 0.0) {
            return false;
        }
        if (compound.m_128459_("battery_percentage") <= 0.0) {
            return false;
        }
        BlockPos tilePos = BlockPos.m_122022_((long)compound.m_128454_("linked_gate_pos"));
        if (sender.getWorld() == null || !((blockEntity = sender.getWorld().m_7702_(tilePos)) instanceof StargateAbstractBaseBE)) {
            return false;
        }
        StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)blockEntity;
        return gateTile.sendIrisCode(sender, stack.m_41784_().m_128461_("entered_code"));
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_) {
            if (Minecraft.m_91087_().f_91080_ instanceof GDOVirtualGui && entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                player.m_5661_((Component)Component.m_237115_((String)"item.jsg.gdo.in_menu.alert"), true);
            }
            return;
        }
        if (world.m_46467_() % 20L == 0L) {
            BlockPos pos = entity.m_20183_();
            int reachSquared = JSGConfig.DialHomeDevice.universeDialerReach.get() * JSGConfig.DialHomeDevice.universeDialerReach.get() * 2;
            CompoundTag compound = stack.m_41784_();
            if (compound.m_128441_("linked_gate_pos")) {
                BlockPos tilePos = BlockPos.m_122022_((long)compound.m_128454_("linked_gate_pos"));
                double signal = Math.max(0.0, 1.0 - tilePos.m_123331_((Vec3i)pos) / (double)reachSquared);
                compound.m_128347_("signal_strength", signal);
                if (!world.m_8055_(tilePos).m_204336_(JSGBlockTags.ALL_STARGATE_BASES) || signal <= 0.0) {
                    compound.m_128473_("linked_gate_pos");
                }
            }
            if (!compound.m_128441_("battery_percentage")) {
                compound.m_128347_("battery_percentage", 1.0);
            }
            boolean found = false;
            ArrayList<BlockPos> blacklist = new ArrayList<BlockPos>();
            int loop = 0;
            do {
                ++loop;
                BlockPos targetPos = this.getNearest(world, pos, blacklist);
                if (targetPos == null) break;
                StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)world.m_7702_(targetPos);
                if (gateTile != null && gateTile.isMerged()) {
                    compound.m_128356_("linked_gate_pos", targetPos.m_121878_());
                    break;
                }
                blacklist.add(targetPos);
            } while (!found && loop < 100);
            stack.m_41751_(compound);
        }
    }

    public BlockPos getNearest(Level world, BlockPos pos, ArrayList<BlockPos> blacklist) {
        return LinkingHelper.findClosestPos(world, pos, new BlockPos(JSGConfig.DialHomeDevice.universeDialerReach.get(), 40, JSGConfig.DialHomeDevice.universeDialerReach.get()), JSGBlockTags.ALL_STARGATE_BASES, blacklist);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        ItemHelper.applyGenericToolTip(this.m_5524_(), components, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (world.f_46443_) {
            GDOVirtualGuiProvider.open();
        }
        return super.m_7203_(world, player, hand);
    }
}

