/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.notebook;

import com.mojang.blaze3d.platform.InputConstants;
import dev.tauri.jsg.api.item.JSGItem;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.item.notebook.PageNotebookBEWLR;
import dev.tauri.jsg.registry.tags.JSGBiomeTags;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class PageNotebookItemFilled
extends JSGItem {
    private static final String UNNAMED = "item.jsg.notebook.unnamed";

    public PageNotebookItemFilled() {
        super(new Item.Properties().m_41497_(Rarity.COMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final PageNotebookBEWLR instance = new PageNotebookBEWLR();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return instance;
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (stack.m_41782_()) {
            int key = 340;
            boolean displayIds = tooltipFlag.m_7050_() || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
            String text = I18n.format("item.jsg.page_notebook_filled.hold_shift");
            text = text.replaceAll("%key%", InputConstants.Type.KEYSYM.m_84895_(key).m_84875_().getString());
            components.add((Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            try {
                CompoundTag compound = stack.m_41783_();
                if (compound == null) {
                    return;
                }
                IAddress stargateAddress = NotebookPageSerialization.getDeserializedAddress(compound);
                if (stargateAddress == null) {
                    return;
                }
                int[] symbolsToDisplay = compound.m_128465_("symbolsToDisplay");
                HashMap<Integer, Boolean> hashedSymbols = new HashMap<Integer, Boolean>();
                for (int symbolId : symbolsToDisplay) {
                    hashedSymbols.put(symbolId, true);
                }
                for (int i = 0; i < 8; ++i) {
                    if (hashedSymbols.get(i + 1) == null || !((Boolean)hashedSymbols.get(i + 1)).booleanValue()) continue;
                    components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.ITALIC) + String.valueOf(i < 6 ? ChatFormatting.AQUA : ChatFormatting.DARK_PURPLE) + stargateAddress.get(i).localize() + (String)(displayIds ? String.valueOf(ChatFormatting.GRAY) + " (" + stargateAddress.get(i).getId() + ")" : ""))));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getColorForBiome(RegistryAccess level, ResourceKey<Biome> biome) {
        int color = 0x303000;
        if (level == null) {
            return color;
        }
        Optional getter = level.m_255325_().m_255095_(Registries.f_256952_);
        if (getter.isEmpty()) {
            return color;
        }
        Optional holderOpt = ((HolderGetter)getter.get()).m_254902_(biome);
        if (holderOpt.isEmpty()) {
            return color;
        }
        Holder.Reference holder = (Holder.Reference)holderOpt.get();
        if (holder.m_203656_(JSGBiomeTags.IS_OCEAN) || holder.m_203656_(BiomeTags.f_207605_)) {
            color = 2175392;
        } else if (holder.m_203656_(BiomeTags.f_207608_)) {
            color = 7561552;
        } else if (holder.m_203656_(BiomeTags.f_207611_)) {
            color = 5272385;
        } else if (holder.m_203656_(JSGBiomeTags.HAS_PODZOL)) {
            color = 8104361;
        } else if (holder.m_203656_(JSGBiomeTags.IS_SWAMP)) {
            color = 7041847;
        } else if (holder.m_203656_(JSGBiomeTags.IS_NETHER)) {
            color = 9841163;
        } else if (holder.m_203656_(JSGBiomeTags.IS_COLD)) {
            color = 6785402;
        } else if (holder.m_203656_(JSGBiomeTags.IS_FUNGI)) {
            color = 5524301;
        } else if (holder.m_203656_(JSGBiomeTags.IS_MOSSY)) {
            color = 0x104004;
        } else if (holder.m_203656_(BiomeTags.f_215816_)) {
            color = 0x104004;
        } else if (holder.m_203656_(JSGBiomeTags.IS_BADLANDS)) {
            color = 0x104004;
        } else if (holder.m_203656_(JSGBiomeTags.IS_SANDY)) {
            color = 10461777;
        } else if (holder.m_203656_(JSGBiomeTags.IS_TEMPERATE)) {
            color = 4747325;
        }
        return color;
    }

    public static ResourceKey<Biome> getBiomeKeyFromWorld(@Nullable Level world, BlockPos pos) {
        if (world == null) {
            return Biomes.f_48205_;
        }
        return world.m_204166_(pos).m_203543_().orElse(Biomes.f_48205_);
    }

    @Nullable
    public static AbstractSymbolType<?> getSymbolType(@NotNull CompoundTag compound) {
        if (compound.m_128425_("symbolType", 8)) {
            return AbstractSymbolType.byId(compound.m_128461_("symbolType"));
        }
        return AbstractSymbolType.byId(compound.m_128451_("symbolType"));
    }

    @Nullable
    public static NotebookPageSerialization.AddressDeserializer getDeserializer(@NotNull CompoundTag tag) {
        return NotebookPageSerialization.byId(PageNotebookItemFilled.getPageAddressType(tag));
    }

    public static ResourceLocation getPageAddressType(@NotNull CompoundTag tag) {
        return new ResourceLocation(tag.m_128461_("addressType"));
    }

    public static CompoundTag getCompoundFromAddress(IAddress address, List<Integer> symbolsToDisplay, ResourceKey<Biome> biome, @Nullable PointOfOrigin origin, ResourceLocation addressTypeId) {
        int[] symbolsToDisplayArray = new int[symbolsToDisplay.size()];
        for (int i = 0; i < symbolsToDisplay.size(); ++i) {
            symbolsToDisplayArray[i] = symbolsToDisplay.get(i);
        }
        return PageNotebookItemFilled.getCompoundFromAddress(address, symbolsToDisplayArray, biome, origin, addressTypeId);
    }

    public static CompoundTag getCompoundFromAddress(IAddress address, int[] symbolsToDisplay, ResourceKey<Biome> biome, @Nullable PointOfOrigin origin, ResourceLocation addressTypeId) {
        CompoundTag compound = new CompoundTag();
        if (address != null) {
            compound.m_128359_("addressType", addressTypeId.toString());
            if (address.getSymbolType() != null) {
                compound.m_128359_("symbolType", address.getSymbolType().getId());
            }
            if (address.serializeNBT() != null) {
                compound.m_128365_("address", address.serializeNBT());
            }
        }
        compound.m_128385_("symbolsToDisplay", symbolsToDisplay);
        compound.m_128359_("biome", biome.m_135782_().toString());
        if (origin != null) {
            compound.m_128365_("origin", (Tag)origin.serializeNBT());
        }
        return compound;
    }

    public static String getUnnamedLocalized() {
        return I18n.format(UNNAMED);
    }

    public static void setName(CompoundTag page, String name) {
        CompoundTag display = new CompoundTag();
        display.m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)name)));
        page.m_128365_("display", (Tag)display);
    }

    public static String getNameFromCompound(@Nullable CompoundTag compound) {
        CompoundTag display;
        if (compound != null && compound.m_128441_("display") && (display = compound.m_128469_("display")).m_128441_("Name")) {
            return Objects.requireNonNull(Component.Serializer.m_130701_((String)display.m_128461_("Name"))).getString();
        }
        return PageNotebookItemFilled.getUnnamedLocalized();
    }
}

