/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.notebook;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.item.linkable.HandHeldDeviceRenderer;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PageRenderer {
    public static final ResourceLocation NOTEBOOK_PAGE_TEXTURE = new ResourceLocation("jsg", "textures/gui/notebook/page_single.png");
    public static PoseStack currentStack;
    public static MultiBufferSource source;
    public static int light;
    @Nullable
    public static Pair<Float, Boolean> renderPercentages;

    public static void renderSymbol(float x, float y, SymbolInterface symbol, @Nullable PointOfOrigin origin) {
        if (symbol.getSymbolType() == SymbolTypeRegistry.UNIVERSE) {
            PageRenderer.renderSymbol(x += 0.04f, y, 0.095f, 0.2f, symbol, origin);
        } else {
            PageRenderer.renderSymbol(x, y, 0.2f, 0.2f, symbol, origin);
        }
    }

    public static void renderSymbol(float x, float y, SymbolInterface symbol, @Nullable PointOfOrigin origin, Color color, float alpha) {
        if (symbol.getSymbolType() == SymbolTypeRegistry.UNIVERSE) {
            PageRenderer.renderSymbol(x += 0.04f, y, 0.095f, 0.2f, symbol, origin, color, alpha);
        } else {
            PageRenderer.renderSymbol(x, y, 0.2f, 0.2f, symbol, origin, color, alpha);
        }
    }

    public static void renderSymbol(float x, float y, float w, float h, SymbolInterface symbol, @Nullable PointOfOrigin origin) {
        PageRenderer.renderSymbol(x, y, w, h, symbol, origin, Color.BLACK, (float)JSGConfig.General.visualGlyphTransparency.get());
    }

    public static void renderSymbol(float x, float y, float w, float h, SymbolInterface symbol, @Nullable PointOfOrigin origin, Color color, float alpha) {
        if (currentStack == null) {
            return;
        }
        currentStack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        float z = 0.011f;
        RenderSystem.setShader(GameRenderer::m_172835_);
        symbol.bindIconTexture(origin);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        bufferbuilder.m_252986_(matrix, 0.04f + x, 0.79f - y, z).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.04f + x + w, 0.79f - y, z).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.04f + x + w, 0.79f - y + h, z).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.04f + x, 0.79f - y + h, z).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        currentStack.m_85849_();
    }

    public static void renderRect(float x, float y, float w, float h, Color color, float alpha) {
        if (currentStack == null) {
            return;
        }
        currentStack.m_85836_();
        float z = 0.011f;
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        Matrix4f matrix = currentStack.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix, 0.04f + x, 0.79f - y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.04f + x + w, 0.79f - y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.04f + x + w, 0.79f - y + h, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.04f + x, 0.79f - y + h, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        currentStack.m_85849_();
    }

    public static void renderByCompound(ItemDisplayContext lastTransform, CompoundTag compound) {
        PageRenderer.renderByCompound(lastTransform, compound, () -> {}, null);
    }

    public static void renderByCompound(ItemDisplayContext lastTransform, CompoundTag compound, Runnable renderTextLayer, @Nullable List<ResourceLocation> layers) {
        if (currentStack == null) {
            return;
        }
        if (source == null) {
            return;
        }
        if (layers == null) {
            layers = List.of(NOTEBOOK_PAGE_TEXTURE);
        }
        RenderSystem.enableDepthTest();
        currentStack.m_85836_();
        HandHeldDeviceRenderer.currentStack = currentStack;
        HandHeldDeviceRenderer.source = source;
        HandHeldDeviceRenderer.light = light;
        if (lastTransform == ItemDisplayContext.FIXED) {
            currentStack.m_85837_(0.15, 0.0, 0.5);
        } else if (lastTransform == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            currentStack.m_252781_(Axis.f_252436_.m_252977_(60.0f));
            currentStack.m_85837_(-0.55, 0.2, 0.0);
            currentStack.m_85841_(1.5f, 1.5f, 1.5f);
            currentStack.m_252781_(Axis.f_252529_.m_252977_(28.0f));
            currentStack.m_252781_(Axis.f_252436_.m_252977_(26.0f));
            currentStack.m_252781_(Axis.f_252403_.m_252977_(-13.5f));
            currentStack.m_85837_(-0.1, 0.2, 0.0);
            currentStack.m_85841_(0.7f, 0.7f, 0.7f);
            currentStack.m_85836_();
            currentStack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
            currentStack.m_85837_(0.2, 0.0, -1.3);
            HandHeldDeviceRenderer.renderArms(HumanoidArm.RIGHT, Minecraft.m_91087_().getPartialTick());
            currentStack.m_85849_();
        } else if (lastTransform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            currentStack.m_252781_(Axis.f_252436_.m_252977_(-50.0f));
            currentStack.m_85837_(0.5, 0.3, 0.0);
            currentStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            currentStack.m_252781_(Axis.f_252436_.m_252977_(-36.0f));
            currentStack.m_252781_(Axis.f_252403_.m_252977_(19.0f));
            currentStack.m_85837_(0.3, 0.21, 0.0);
            currentStack.m_85841_(0.491f, 0.491f, 0.491f);
            currentStack.m_85836_();
            currentStack.m_252781_(Axis.f_252529_.m_252977_(260.0f));
            currentStack.m_252781_(Axis.f_252436_.m_252977_(-10.0f));
            currentStack.m_252781_(Axis.f_252403_.m_252977_(-10.0f));
            currentStack.m_252880_(-0.5f, 0.2f, -1.52f);
            HandHeldDeviceRenderer.renderArms(HumanoidArm.LEFT, Minecraft.m_91087_().getPartialTick());
            currentStack.m_85849_();
        } else {
            currentStack.m_85849_();
            RenderSystem.disableDepthTest();
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float z = (float)(-(layers.size() - 1)) * 1.0E-4f;
        float topOffset = 0.0f;
        float bottomOffset = 0.0f;
        if (renderPercentages != null) {
            Float percentages = (Float)renderPercentages.first();
            if (((Boolean)renderPercentages.second()).booleanValue()) {
                topOffset = 1.0f - percentages.floatValue();
            } else {
                bottomOffset = 1.0f - percentages.floatValue();
            }
        }
        for (ResourceLocation tex : layers) {
            currentStack.m_85836_();
            currentStack.m_85841_(1.13f, 1.13f, 1.13f);
            currentStack.m_252880_(-0.117f, -0.0577f, 0.0f);
            float finalBottomOffset = bottomOffset;
            float finalZ = z;
            float finalTopOffset = topOffset;
            EmissiveRenderer.renderWithLightOverlay(currentStack, light, false, () -> Texture.bindTextureWithMc(tex), () -> {
                Matrix4f matrix = currentStack.m_85850_().m_252922_();
                Matrix3f normal = currentStack.m_85850_().m_252943_();
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
                bufferbuilder.m_252986_(matrix, 0.0f, finalBottomOffset, finalZ).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_7421_(0.0f, 0.8046875f * (1.0f - finalBottomOffset)).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix, 0.817f, finalBottomOffset, finalZ).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_7421_(0.65625f, 0.8046875f * (1.0f - finalBottomOffset)).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix, 0.817f, 1.0f - finalTopOffset, finalZ).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_7421_(0.65625f, 0.8046875f * finalTopOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix, 0.0f, 1.0f - finalTopOffset, finalZ).m_85950_(1.0f, 1.0f, 1.0f, 0.99f).m_7421_(0.0f, 0.8046875f * finalTopOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            });
            currentStack.m_85849_();
            z += 1.0E-4f;
        }
        if (compound != null) {
            if (compound.m_128441_("symbolType")) {
                AbstractSymbolType<?> symbolType = compound.m_128425_("symbolType", 8) ? AbstractSymbolType.byId(compound.m_128461_("symbolType")) : AbstractSymbolType.byId(compound.m_128451_("symbolType"));
                IAddress stargateAddress = NotebookPageSerialization.getDeserializedAddress(compound);
                if (stargateAddress != null) {
                    int[] symbolsToDisplay = compound.m_128465_("symbolsToDisplay");
                    PointOfOrigin origin = null;
                    if (compound.m_128441_("origin")) {
                        origin = PointOfOrigin.fromNBT(compound.m_128469_("origin"), null);
                    }
                    currentStack.m_85836_();
                    currentStack.m_85837_(0.0, (double)-0.03f, -0.01);
                    for (int symbolId : symbolsToDisplay) {
                        float y;
                        float x;
                        if (symbolId <= 3 && topOffset >= 0.25f || symbolId <= 6 && topOffset >= 0.4f || symbolId <= 8 && topOffset >= 0.65f || symbolId <= 9 && topOffset >= 0.85f || symbolId >= 9 && bottomOffset >= 0.07f || symbolId >= 7 && bottomOffset >= 0.2f || symbolId >= 4 && bottomOffset >= 0.4f || bottomOffset >= 0.6f || symbolId <= 0 || symbolId > 9) continue;
                        int i = symbolId - 1;
                        if (symbolId == 9) {
                            x = 0.21f;
                            y = 0.2f * (float)((int)Math.floor(3.3333332538604736)) + 0.14f;
                            float w = 0.2f;
                            if (symbolType == SymbolTypeRegistry.UNIVERSE) {
                                w = 0.095f;
                                x += 0.04f;
                            }
                            PageRenderer.renderSymbol(x, y, w, 0.2f, (SymbolInterface)Objects.requireNonNull(symbolType.getOrigin()), origin);
                            continue;
                        }
                        x = 0.21f * (float)(i % 3);
                        y = 0.2f * (float)((int)Math.floor((float)i / 3.0f)) + 0.14f;
                        PageRenderer.renderSymbol(x, y, stargateAddress.get(i), origin);
                    }
                    currentStack.m_85849_();
                }
            }
            String name = PageNotebookItemFilled.getNameFromCompound(compound);
            float scale = 0.009f;
            float width = (float)Minecraft.m_91087_().f_91062_.m_92895_(name) * scale;
            currentStack.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.m_167982_().f_112253_;
            currentStack.m_252880_(0.35500002f, 0.935f, 0.011f);
            currentStack.m_85841_(scale, -scale, scale);
            currentStack.m_85837_(0.0, 0.0, -1.2);
            if (topOffset < 0.1f && (double)bottomOffset < 0.8) {
                currentStack.m_85836_();
                currentStack.m_85841_(1.0f / scale, 1.0f / -scale, 1.0f / scale);
                currentStack.m_252880_(-width / 2.0f, 0.0f, 0.0f);
                currentStack.m_85841_(scale, -scale, scale);
                font.m_271703_(name, 0.0f, 0.0f, 0x383228, false, currentStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, light);
                currentStack.m_85849_();
            }
            if (compound.m_128441_("customText")) {
                PageRenderer.renderCustomTextPage(compound.m_128469_("customText"));
            }
            currentStack.m_85836_();
            renderTextLayer.run();
            currentStack.m_85849_();
            currentStack.m_85849_();
        }
        currentStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    protected static void renderCustomTextPage(@Nullable CompoundTag textTag) {
        if (textTag == null) {
            return;
        }
        currentStack.m_85836_();
        ListTag lines = textTag.m_128437_("lines", 10);
        int lineIndex = 0;
        currentStack.m_85841_(0.5f, 0.5f, 0.5f);
        currentStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        currentStack.m_252880_(-60.0f, -30.0f, 0.0f);
        for (Tag line : lines) {
            MutableComponent lineComponent = Component.Serializer.m_130701_((String)((CompoundTag)line).m_128461_("component"));
            currentStack.m_85836_();
            currentStack.m_85841_(0.75f, 0.75f, 0.75f);
            currentStack.m_252880_(0.0f, (float)(-8 * lineIndex), 0.0f);
            PageRenderer.renderText((Component)lineComponent, 0xFFFFFF, false);
            currentStack.m_85849_();
            ++lineIndex;
        }
        currentStack.m_85849_();
    }

    public static void renderText(String text, int color, boolean shadow) {
        currentStack.m_85836_();
        currentStack.m_85841_(1.0f, -1.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.m_167982_().f_112253_;
        font.m_271703_(text, 0.0f, 0.0f, color, shadow, currentStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, light);
        currentStack.m_85849_();
    }

    public static void renderText(Component text, int color, boolean shadow) {
        currentStack.m_85836_();
        currentStack.m_85841_(1.0f, -1.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.m_167982_().f_112253_;
        font.m_272077_(text, 0.0f, 0.0f, color, shadow, currentStack.m_85850_().m_252922_(), source, Font.DisplayMode.NORMAL, 0, light);
        currentStack.m_85849_();
    }

    static {
        light = 1;
        renderPercentages = null;
    }
}

