/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.jub;

import dev.tauri.jsg.jub.JUBDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUB {
    private final List<JUBDevice> devices = new ArrayList<JUBDevice>();
    public final UUID uuid = UUID.randomUUID();

    public boolean equals(Object other) {
        if (!(other instanceof JUB)) {
            return false;
        }
        JUB otherJub = (JUB)other;
        return this.uuid.equals(otherJub.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public List<JUBDevice> getConnectedDevices() {
        return new ArrayList<JUBDevice>(this.devices);
    }

    public void invalidate() {
        this.getConnectedDevices().forEach(d -> d.disconnectFromBus(true));
    }

    public void deviceConnected(JUBDevice device, boolean silent) {
        if (this.devices.contains(device)) {
            return;
        }
        this.devices.add(device);
        this.getConnectedDevices().forEach(JUBDevice::onChanged);
        this.sendPacket("connected", device, null, device);
    }

    public void deviceDisconnected(JUBDevice device, boolean silent) {
        if (!this.devices.contains(device)) {
            return;
        }
        this.devices.remove(device);
        device.onChanged();
        this.getConnectedDevices().forEach(JUBDevice::onChanged);
        this.sendPacket("disconnected", device, null, device);
    }

    @NotNull
    public JUB merge(@NotNull JUB bus) {
        if (bus == this) {
            return this;
        }
        ArrayList<JUBDevice> copy = new ArrayList<JUBDevice>(this.devices);
        copy.forEach(d -> {
            if (d.getBus() != bus) {
                d.connectToBus(bus);
            }
        });
        return bus;
    }

    public void sendPacket(String name, Object data, @Nullable JUBDevice target, JUBDevice sender) {
        if (target == null) {
            this.devices.forEach(d -> d.packetReceived(name, data, sender));
            return;
        }
        if (!this.devices.contains(target)) {
            return;
        }
        target.packetReceived(name, data, sender);
    }
}

