/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.listener;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.effect.StargateWormholeEffect;
import dev.tauri.jsg.entity.client.JSGEntityModelLayer;
import dev.tauri.jsg.entity.client.MastadgeModel;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.item.tooltips.ClientStargateInventoryTooltip;
import dev.tauri.jsg.item.tooltips.ServerStargateInventoryTooltip;
import dev.tauri.jsg.listener.InputHandlerClient;
import dev.tauri.jsg.registry.ItemRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModListener {
    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        for (KeyMapping m : InputHandlerClient.KEY_BINDINGS) {
            event.register(m);
        }
    }

    @SubscribeEvent
    public static void registerItemStackRenderableTooltips(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(ServerStargateInventoryTooltip.class, ClientStargateInventoryTooltip::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(JSGEntityModelLayer.MASTADGE_LAYER, MastadgeModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("wormhole_overlay", StargateWormholeEffect::render);
    }

    @SubscribeEvent
    public static void onResourcesReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((pPreparationBarrier, pResourceManager, pPreparationsProfiler, pReloadProfiler, pBackgroundExecutor, pGameExecutor) -> pPreparationBarrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
            LoadersHolder.load(pReloadProfiler);
            try {
                Minecraft.m_91087_().m_91106_().m_120405_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, pBackgroundExecutor));
    }

    @SubscribeEvent
    public static void registerColoredBlocks(RegisterColorHandlersEvent.Block event) {
    }

    @SubscribeEvent
    public static void registerColoredItems(RegisterColorHandlersEvent.Item event) {
        event.register((stack, layerIndex) -> {
            if (JSGApi.currentServer == null) {
                return -1;
            }
            if (layerIndex != 1) {
                return -1;
            }
            if (!stack.m_41782_()) {
                return -1;
            }
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("biome")) {
                return -1;
            }
            ResourceLocation biomeLocation = new ResourceLocation(tag.m_128461_("biome"));
            return PageNotebookItemFilled.getColorForBiome((RegistryAccess)JSGApi.currentServer.m_206579_(), (ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeLocation));
        }, new ItemLike[]{(ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get()});
    }
}

