/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader.model;

import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.client.model.IOBJModelRenderer;
import dev.tauri.jsg.renderer.obj.GUIOBJModelRenderer;
import dev.tauri.jsg.renderer.obj.InGameOBJModelRenderer;
import dev.tauri.jsg.renderer.obj.LegacyOBJModelRenderer;
import java.util.HashMap;
import java.util.Map;

public class OBJModel
extends AbstractOBJModel {
    public final float[] vertices;
    public final float[] textureCoords;
    public final float[] normals;
    public final int[] indices;
    public final boolean isEmpty;
    protected final Map<AbstractOBJModel.EnumOBJRenderMethod, IOBJModelRenderer<?>> renderers = new HashMap();

    public OBJModel(float[] vertices, float[] textureCoords, float[] normals, int[] indices) {
        this.vertices = vertices;
        this.textureCoords = textureCoords;
        this.normals = normals;
        this.indices = indices;
        this.isEmpty = vertices.length == 0;
    }

    @Override
    public IOBJModelRenderer<?> renderer(AbstractOBJModel.EnumOBJRenderMethod method) {
        if (method == AbstractOBJModel.EnumOBJRenderMethod.GUI) {
            GUIOBJModelRenderer renderer = this.renderers.get((Object)method);
            if (renderer == null) {
                renderer = new GUIOBJModelRenderer(this);
                this.renderers.put(method, renderer);
            }
            return renderer;
        }
        if (method == AbstractOBJModel.EnumOBJRenderMethod.LEGACY) {
            LegacyOBJModelRenderer renderer = this.renderers.get((Object)method);
            if (renderer == null) {
                renderer = new LegacyOBJModelRenderer(this);
                this.renderers.put(method, renderer);
            }
            return renderer;
        }
        InGameOBJModelRenderer renderer = this.renderers.get((Object)method);
        if (renderer == null) {
            renderer = new InGameOBJModelRenderer(this);
            this.renderers.put(method, renderer);
        }
        return renderer;
    }

    @Override
    public boolean isEmpty() {
        return this.vertices.length < 1;
    }
}

