/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.multistructure.mergehelper;

import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.stargate.StargateSizeEnum;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.multistructure.mergehelper.StargateAbstractMergeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public abstract class StargateClassicMergeHelper
extends StargateAbstractMergeHelper {
    public static final Map<StargateSizeEnum, List<BlockPos>> RINGS_POSITIONS = new HashMap<StargateSizeEnum, List<BlockPos>>(){
        {
            this.put(StargateSizeEnum.SMALL, new ArrayList<BlockPos>(){
                {
                    this.addAll(Arrays.asList(new BlockPos(2, 1, 0), new BlockPos(3, 3, 0), new BlockPos(3, 5, 0), new BlockPos(1, 7, 0), new BlockPos(-1, 7, 0), new BlockPos(-3, 5, 0), new BlockPos(-3, 3, 0), new BlockPos(-2, 1, 0)));
                }
            });
            this.put(StargateSizeEnum.MEDIUM, new ArrayList<BlockPos>(){
                {
                    this.addAll(Arrays.asList(new BlockPos(2, 1, 0), new BlockPos(3, 3, 0), new BlockPos(3, 5, 0), new BlockPos(1, 7, 0), new BlockPos(-1, 7, 0), new BlockPos(-3, 5, 0), new BlockPos(-3, 3, 0), new BlockPos(-2, 1, 0)));
                }
            });
            this.put(StargateSizeEnum.LARGE, new ArrayList<BlockPos>(){
                {
                    this.addAll(Arrays.asList(new BlockPos(-1, 0, 0), new BlockPos(-3, 1, 0), new BlockPos(-4, 3, 0), new BlockPos(-5, 4, 0), new BlockPos(-4, 6, 0), new BlockPos(-4, 7, 0), new BlockPos(-2, 9, 0), new BlockPos(-1, 9, 0), new BlockPos(1, 9, 0), new BlockPos(2, 9, 0), new BlockPos(4, 7, 0), new BlockPos(4, 6, 0), new BlockPos(5, 4, 0), new BlockPos(4, 3, 0), new BlockPos(3, 1, 0), new BlockPos(1, 0, 0)));
                }
            });
        }
    };
    public static final Map<StargateSizeEnum, List<BlockPos>> CHEVRONS_POSITIONS = new HashMap<StargateSizeEnum, List<BlockPos>>(){
        {
            this.put(StargateSizeEnum.SMALL, new ArrayList<BlockPos>(){
                {
                    this.addAll(Arrays.asList(new BlockPos(1, 0, 0), new BlockPos(3, 2, 0), new BlockPos(3, 4, 0), new BlockPos(2, 6, 0), new BlockPos(0, 7, 0), new BlockPos(-2, 6, 0), new BlockPos(-3, 4, 0), new BlockPos(-3, 2, 0), new BlockPos(-1, 0, 0)));
                }
            });
            this.put(StargateSizeEnum.MEDIUM, new ArrayList<BlockPos>(){
                {
                    this.addAll(Arrays.asList(new BlockPos(1, 0, 0), new BlockPos(3, 2, 0), new BlockPos(3, 4, 0), new BlockPos(2, 6, 0), new BlockPos(0, 7, 0), new BlockPos(-2, 6, 0), new BlockPos(-3, 4, 0), new BlockPos(-3, 2, 0), new BlockPos(-1, 0, 0)));
                }
            });
            this.put(StargateSizeEnum.LARGE, new ArrayList<BlockPos>(){
                {
                    this.addAll(Arrays.asList(new BlockPos(3, 8, 0), new BlockPos(5, 5, 0), new BlockPos(4, 2, 0), new BlockPos(-4, 2, 0), new BlockPos(-5, 5, 0), new BlockPos(-3, 8, 0), new BlockPos(2, 0, 0), new BlockPos(-2, 0, 0), new BlockPos(0, 9, 0)));
                }
            });
        }
    };

    public StargateClassicMergeHelper(StargateAbstractBaseBE tileEntity) {
        super(tileEntity);
    }

    public List<BlockPos> getChevrons() {
        if (this.stargateSize == null) {
            this.stargateSize = JSGConfig.Stargate.stargateSize.get();
        }
        return CHEVRONS_POSITIONS.get((Object)this.stargateSize);
    }

    @Override
    public List<BlockPos> getRings() {
        if (this.stargateSize == null) {
            this.stargateSize = JSGConfig.Stargate.stargateSize.get();
        }
        return RINGS_POSITIONS.get((Object)this.stargateSize);
    }

    public abstract Block getChevronBlock();

    @Override
    public Map<BlockPos, BlockState> getBlocks(boolean offsetAndRotate) {
        Map<BlockPos, BlockState> map = super.getBlocks(offsetAndRotate);
        Iterator<BlockPos> iterator = this.getChevrons().iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            BlockPos newPos = pos = iterator.next();
            if (offsetAndRotate) {
                newPos = this.stargate.relative(pos);
            }
            map.put(newPos, (BlockState)((BlockState)((BlockState)this.getChevronBlock().m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)this.horizontalFacing)).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(this.verticalFacing)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(offsetAndRotate && Objects.requireNonNull(this.stargate.m_58904_()).m_6425_(newPos).m_76152_() == Fluids.f_76193_)));
        }
        return map;
    }

    @Override
    @Nonnull
    public Block getMatchBlock(boolean chevron) {
        if (chevron) {
            return this.getChevronBlock();
        }
        return super.getMatchBlock(false);
    }
}

