/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.api.packet.JSGPacket;
import dev.tauri.jsg.item.notebook.NotebookActionEnum;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class NotebookActionPacketToServer
extends JSGPacket {
    private NotebookActionEnum action;
    private InteractionHand hand;
    private boolean next;

    public NotebookActionPacketToServer() {
    }

    public NotebookActionPacketToServer(NotebookActionEnum action, InteractionHand hand, boolean next) {
        this.action = action;
        this.hand = hand;
        this.next = next;
    }

    public NotebookActionPacketToServer(FriendlyByteBuf buf) {
        this.fromBytes(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.writeBoolean(this.next);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.action = NotebookActionEnum.values()[buf.readInt()];
        this.hand = buf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.next = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        ServerLevel world = player.m_284548_();
        ctx.enqueueWork(() -> {
            ItemStack stack = player.m_21120_(this.hand);
            if (stack.m_41720_() == ItemRegistry.NOTEBOOK_ITEM.get() && stack.m_41782_()) {
                CompoundTag compound = stack.m_41783_();
                int selected = compound.m_128451_("selected");
                switch (this.action) {
                    case ADDRESS_CHANGE: {
                        int addressCount = compound.m_128437_("addressList", 10).size();
                        if (this.next && selected < addressCount - 1) {
                            compound.m_128405_("selected", (int)((byte)(selected + 1)));
                            JSGSoundHelper.playSoundEvent((Level)world, player.m_20183_(), SoundEvent.PAGE_FLIP);
                        }
                        if (this.next || selected <= 0) break;
                        compound.m_128405_("selected", (int)((byte)(selected - 1)));
                        JSGSoundHelper.playSoundEvent((Level)world, player.m_20183_(), SoundEvent.PAGE_FLIP);
                    }
                }
                stack.m_41751_(compound);
            }
        });
    }
}

