/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.blockentity.PrinterBE;
import dev.tauri.jsg.packet.PositionedPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PrinterButtonClickedToServer
extends PositionedPacket {
    public int button;

    public PrinterButtonClickedToServer(BlockPos pos, int button) {
        super(pos);
        this.button = button;
    }

    public PrinterButtonClickedToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.button);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.button = buf.readInt();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            PrinterBE tile = (PrinterBE)world.m_7702_(this.pos);
            if (tile == null) {
                return;
            }
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (this.button == 4) {
                ItemStack toGive = tile.insertPage(stack, false, player.m_6047_());
                if (toGive != null && !toGive.m_41619_()) {
                    player.m_36356_(toGive);
                }
                return;
            }
            if (this.button == 5) {
                ItemStack toGive = tile.takePage(false);
                if (toGive != null && !toGive.m_41619_()) {
                    player.m_36356_(toGive);
                }
                return;
            }
            tile.buttonClick(this.button, player);
        });
    }
}

