/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.state.IStateProvider;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.packet.PositionedPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.NotImplementedException;

public class StateUpdatePacketToClient
extends PositionedPacket {
    private StateType stateType;
    private State state;
    private ByteBuf stateBuf;

    public StateUpdatePacketToClient(BlockPos pos, StateType stateType, State state) {
        super(pos);
        this.stateType = stateType;
        if (state == null) {
            throw new NullPointerException("State was null! (State type: " + stateType.toString() + "; Pos: " + pos.toString() + ")");
        }
        this.state = state;
    }

    public StateUpdatePacketToClient(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stateType.id);
        this.state.toBytes((ByteBuf)buf);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.stateType = StateType.byId(buf.readInt());
        this.stateBuf = buf.copy();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        ctx.setPacketHandled(true);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientLevel level = player.f_108545_;
        ctx.enqueueWork(() -> {
            IStateProvider te = (IStateProvider)level.m_7702_(this.pos);
            try {
                if (te == null) {
                    return;
                }
                State state = te.createState(this.stateType);
                if (state == null) {
                    throw new NotImplementedException("State not implemented on " + te.getClass().getCanonicalName());
                }
                state.fromBytes(this.stateBuf);
                te.setState(this.stateType, state);
            }
            catch (Exception e) {
                JSG.logger.error("Error while handling packet!", e);
            }
        });
    }
}

