/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.entry;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.packet.JSGPacket;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.item.notebook.NotebookItem;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.packet.packets.entry.EntryActionEnum;
import dev.tauri.jsg.packet.packets.entry.EntryDataTypeEnum;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.teleportation.traveler.PlayerTraveler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ACEntryActionToServer
extends JSGPacket {
    private InteractionHand hand;
    private EntryDataTypeEnum dataType;
    private EntryActionEnum action;
    private int index;
    private String name;
    private int maxSymbols;
    private StargateAddressDynamic addressToDial;
    private BlockPos linkedGate;
    private StargatePos targetGatePos;
    private EnumDialingType dialType;
    private Map<AbstractSymbolType<?>, StargateAddress> addresses = new HashMap();

    public ACEntryActionToServer() {
    }

    public ACEntryActionToServer(InteractionHand hand, StargateAddressDynamic addressToDial, StargatePos targetPos, BlockPos linkedGate, EnumDialingType dialType) {
        this.hand = hand;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = EntryActionEnum.DIAL;
        this.index = -1;
        this.name = "";
        this.addressToDial = addressToDial;
        this.maxSymbols = -1;
        this.targetGatePos = targetPos;
        this.linkedGate = linkedGate;
        this.dialType = dialType;
    }

    public ACEntryActionToServer(InteractionHand hand, String name, StargatePos targetGate) {
        this.hand = hand;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = EntryActionEnum.RENAME;
        this.index = -1;
        this.name = name;
        this.targetGatePos = targetGate;
        this.addressToDial = null;
        this.linkedGate = null;
    }

    public ACEntryActionToServer(EntryActionEnum action, StargatePos targetGate, Map<AbstractSymbolType<?>, StargateAddress> addresses) {
        this.hand = InteractionHand.MAIN_HAND;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = action;
        this.index = 0;
        this.name = "";
        this.targetGatePos = targetGate;
        this.addressToDial = null;
        this.linkedGate = null;
        this.addresses = addresses;
    }

    public ACEntryActionToServer(EntryActionEnum action, StargatePos targetGate, BlockPos linkedPos) {
        this.hand = InteractionHand.MAIN_HAND;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = action;
        this.index = 0;
        this.name = "";
        this.targetGatePos = targetGate;
        this.addressToDial = null;
        this.linkedGate = linkedPos;
        this.addresses = null;
    }

    public ACEntryActionToServer(EntryActionEnum action, BlockPos linkedGate) {
        this.hand = InteractionHand.MAIN_HAND;
        this.dataType = EntryDataTypeEnum.ADMIN_CONTROLLER;
        this.action = action;
        this.index = -1;
        this.name = "";
        this.linkedGate = linkedGate;
    }

    public ACEntryActionToServer(InteractionHand hand, EntryDataTypeEnum dataType, EntryActionEnum action, int index, String name) {
        this.hand = hand;
        this.dataType = dataType;
        this.action = action;
        this.index = index;
        this.name = name;
        this.addressToDial = null;
        this.targetGatePos = null;
        this.linkedGate = null;
    }

    public ACEntryActionToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    private static void tagSwitchPlaces(ListTag list, int a, int b) {
        Tag tagA = list.get(a);
        list.set(a, list.get(b));
        list.set(b, tagA);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.hand.ordinal());
        buf.writeInt(this.dataType.ordinal());
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.index);
        buf.m_130070_(this.name);
        buf.writeInt(this.maxSymbols);
        if (this.addressToDial != null) {
            buf.writeBoolean(true);
            this.addressToDial.toBytes((ByteBuf)buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.linkedGate != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.linkedGate.m_121878_());
        } else {
            buf.writeBoolean(false);
        }
        if (this.targetGatePos != null) {
            buf.writeBoolean(true);
            this.targetGatePos.toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.dialType == null) {
            this.dialType = EnumDialingType.NORMAL;
        }
        buf.writeInt(this.dialType.ordinal());
        if (this.addresses != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.addresses.size());
            for (Map.Entry<AbstractSymbolType<?>, StargateAddress> e : this.addresses.entrySet()) {
                buf.writeInt(AbstractSymbolType.getId(e.getKey()));
                e.getValue().toBytes((ByteBuf)buf);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.hand = InteractionHand.values()[buf.readInt()];
        this.dataType = EntryDataTypeEnum.values()[buf.readInt()];
        this.action = EntryActionEnum.values()[buf.readInt()];
        this.index = buf.readInt();
        this.name = buf.m_130277_();
        this.maxSymbols = buf.readInt();
        if (buf.readBoolean()) {
            this.addressToDial = new StargateAddressDynamic((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.linkedGate = BlockPos.m_122022_((long)buf.readLong());
        }
        if (buf.readBoolean()) {
            this.targetGatePos = new StargatePos((ByteBuf)buf);
        }
        int i = buf.readInt();
        if (EnumDialingType.values().length <= i) {
            i = 0;
        }
        this.dialType = EnumDialingType.values()[i];
        if (buf.readBoolean()) {
            this.addresses = new HashMap();
            int ii = buf.readInt();
            for (int j = 0; j < ii; ++j) {
                AbstractSymbolType<?> s = AbstractSymbolType.byId(buf.readInt());
                StargateAddress sa = new StargateAddress((ByteBuf)buf);
                this.addresses.put(s, sa);
            }
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            if (this.dataType.admin()) {
                switch (this.action) {
                    case RENAME: {
                        Stargate<?> gateTile = this.targetGatePos.getStargate();
                        if (gateTile == null) {
                            JSG.logger.warn("Gate was null when trying to rename!", new Exception("Trying to rename null gate"));
                            return;
                        }
                        gateTile.renameStargatePos(this.name);
                        break;
                    }
                    case DIAL: {
                        StargateClassicBaseBE gateTile1 = (StargateClassicBaseBE)world.m_7702_(this.linkedGate);
                        if (gateTile1 == null) {
                            return;
                        }
                        if (((StargateAbstractDialingManager)gateTile1.getDialingManager()).getStargateState().engaged()) {
                            ((StargateAbstractDialingManager)gateTile1.getDialingManager()).attemptClose(StargateClosedReasonEnum.REQUESTED);
                            break;
                        }
                        if (this.maxSymbols == -1) {
                            this.maxSymbols = ((StargateAbstractDialingManager)Objects.requireNonNull(gateTile1).getDialingManager()).getMinimalSymbolsToDial(this.targetGatePos.getGateSymbolType(), this.targetGatePos);
                        }
                        StargateAddressDynamic addressToDial = new StargateAddressDynamic(this.addressToDial.getSymbolType(), this.addressToDial.subList(0, this.maxSymbols - 1)).addOriginIfMissingAndImmutable();
                        ((StargateAbstractDialingManager)gateTile1.getDialingManager()).dialAddress(addressToDial, true, true, this.dialType);
                        break;
                    }
                    case ABORT: {
                        StargateClassicBaseBE gateTile2 = (StargateClassicBaseBE)world.m_7702_(this.linkedGate);
                        if (gateTile2 == null) {
                            return;
                        }
                        if (!((StargateAbstractDialingManager)gateTile2.getDialingManager()).getStargateState().dialing()) break;
                        ((StargateAbstractDialingManager)gateTile2.getDialingManager()).abortDialingSequence();
                        break;
                    }
                    case TOGGLE_IRIS: {
                        StargateClassicBaseBE gateTile3 = (StargateClassicBaseBE)world.m_7702_(this.linkedGate);
                        if (gateTile3 == null) {
                            return;
                        }
                        if (!gateTile3.getIrisManager().hasIris()) break;
                        gateTile3.getIrisManager().toggleIris();
                        break;
                    }
                    case GIVE_NOTEBOOK: {
                        ListTag pages = new ListTag();
                        Map<AbstractSymbolType<?>, StargateAddress> addresses = StargateNetwork.INSTANCE.getAddresses(this.targetGatePos);
                        if (addresses == null) break;
                        for (AbstractSymbolType<?> s : SymbolTypeRegistry.values(SymbolUsage.STARGATES)) {
                            StargateAddress address = addresses.get(s);
                            CompoundTag pageCompound = PageNotebookItemFilled.getCompoundFromAddress((IAddress)address, new int[]{1, 2, 3, 4, 5, 6, 7, 8}, PageNotebookItemFilled.getBiomeKeyFromWorld(world, this.targetGatePos.gatePos), null, NotebookPageSerialization.STARGATES);
                            PageNotebookItemFilled.setName(pageCompound, s.getId());
                            pages.add((Object)pageCompound);
                        }
                        ItemStack notebook = NotebookItem.createNotebook(pages);
                        if (!this.targetGatePos.getName().isEmpty()) {
                            notebook.m_41714_((Component)Component.m_237113_((String)this.targetGatePos.getName()));
                        } else {
                            notebook.m_41714_((Component)Component.m_237113_((String)BlockHelper.blockPosToBetterString(this.targetGatePos.gatePos)));
                        }
                        player.m_36356_(notebook);
                        break;
                    }
                    case TELEPORT_TO_POS: {
                        Stargate<?> targetGate = this.targetGatePos.getStargate();
                        Stargate sourceGate = (Stargate)world.m_7702_(this.linkedGate);
                        if (sourceGate == null || targetGate == null) {
                            return;
                        }
                        ((PlayerTraveler)sourceGate.getEventHorizonManager().getStaticTraveler(targetGate, (Entity)player)).confirmSend();
                        break;
                    }
                }
            }
        });
    }
}

